/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.common.tedis.commands;

import com.taobao.common.tedis.TedisException;
import com.taobao.common.tedis.binary.RedisCommands;
import com.taobao.common.tedis.core.BaseCommands;
import com.taobao.common.tedis.core.HashCommands;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class DefaultHashCommands
extends BaseCommands
implements HashCommands {
    protected RedisCommands redisCommands;

    public DefaultHashCommands() {
    }

    public DefaultHashCommands(RedisCommands redisCommands) {
        this.redisCommands = redisCommands;
    }

    public RedisCommands getRedisCommands() {
        return this.redisCommands;
    }

    public void setRedisCommands(RedisCommands redisCommands) {
        this.redisCommands = redisCommands;
    }

    public void init() {
        if (this.commandsProvider == null) {
            throw new TedisException("commandsProvider is null.please set a commandsProvider first.");
        }
        this.redisCommands = this.commandsProvider.getTedis();
    }

    public <H, HK, HV> void delete(final int namespace, final H key, final Object ... hashKey) {
        this.doInTedis(namespace, new BaseCommands.TedisBlock(this.redisCommands){

            public Object execute() {
                return this.commands.hDel(DefaultHashCommands.this.rawKey(namespace, key), DefaultHashCommands.this.rawHashKeys(hashKey));
            }
        });
    }

    public <H, HK, HV> Map<HK, HV> entries(final int namespace, final H key) {
        return this.deserializeHashMap((Map)this.doInTedis(namespace, new BaseCommands.TedisBlock(this.redisCommands){

            public Object execute() {
                return this.commands.hGetAll(DefaultHashCommands.this.rawKey(namespace, key));
            }
        }));
    }

    public <H, HK, HV> HV get(final int namespace, final H key, final Object hashKey) {
        return (HV)this.deserializeHashValue((byte[])this.doInTedis(namespace, new BaseCommands.TedisBlock(this.redisCommands){

            public Object execute() {
                return this.commands.hGet(DefaultHashCommands.this.rawKey(namespace, key), DefaultHashCommands.this.rawHashKey(hashKey));
            }
        }));
    }

    public <H, HK, HV> Boolean hasKey(final int namespace, final H key, final Object hashKey) {
        return (Boolean)this.doInTedis(namespace, new BaseCommands.TedisBlock(this.redisCommands){

            public Object execute() {
                return this.commands.hExists(DefaultHashCommands.this.rawKey(namespace, key), DefaultHashCommands.this.rawHashKey(hashKey));
            }
        });
    }

    public <H, HK, HV> Long increment(final int namespace, final H key, final HK hashKey, final long delta) {
        return (Long)this.doInTedis(namespace, new BaseCommands.TedisBlock(this.redisCommands){

            public Object execute() {
                return this.commands.hIncrBy(DefaultHashCommands.this.rawKey(namespace, key), DefaultHashCommands.this.rawHashKey(hashKey), delta);
            }
        });
    }

    public <H, HK, HV> Set<HK> keys(final int namespace, final H key) {
        return this.deserializeHashKeys((Set)this.doInTedis(namespace, new BaseCommands.TedisBlock(this.redisCommands){

            public Object execute() {
                return this.commands.hKeys(DefaultHashCommands.this.rawKey(namespace, key));
            }
        }));
    }

    public <H, HK, HV> Collection<HV> multiGet(int namespace, H key, Collection<HK> hashKeys) {
        if (hashKeys == null || hashKeys.isEmpty()) {
            return Collections.emptyList();
        }
        final byte[] rawKey = this.rawKey(namespace, key);
        final byte[][] rawHashKeys = new byte[hashKeys.size()][];
        int counter = 0;
        for (HK hashKey : hashKeys) {
            rawHashKeys[counter++] = this.rawHashKey(hashKey);
        }
        return this.deserializeHashValues((List)this.doInTedis(namespace, new BaseCommands.TedisBlock(this.redisCommands){

            public Object execute() {
                return this.commands.hMGet(rawKey, rawHashKeys);
            }
        }));
    }

    public <H, HK, HV> void put(final int namespace, final H key, final HK hashKey, final HV value) {
        this.doInTedis(namespace, new BaseCommands.TedisBlock(this.redisCommands){

            public Object execute() {
                return this.commands.hSet(DefaultHashCommands.this.rawKey(namespace, key), DefaultHashCommands.this.rawHashKey(hashKey), DefaultHashCommands.this.rawHashValue(value));
            }
        });
    }

    public <H, HK, HV> void putAll(int namespace, H key, Map<? extends HK, ? extends HV> m) {
        if (m.isEmpty()) {
            return;
        }
        final byte[] rawKey = this.rawKey(namespace, key);
        final LinkedHashMap<byte[], byte[]> hashes = new LinkedHashMap<byte[], byte[]>(m.size());
        for (Map.Entry<HK, HV> entry : m.entrySet()) {
            hashes.put(this.rawHashKey(entry.getKey()), this.rawHashValue(entry.getValue()));
        }
        this.doInTedis(namespace, new BaseCommands.TedisBlock(this.redisCommands){

            public Object execute() {
                this.commands.hMSet(rawKey, hashes);
                return null;
            }
        });
    }

    public <H, HK, HV> Boolean putIfAbsent(final int namespace, final H key, final HK hashKey, final HV value) {
        return (Boolean)this.doInTedis(namespace, new BaseCommands.TedisBlock(this.redisCommands){

            public Object execute() {
                return this.commands.hSetNX(DefaultHashCommands.this.rawKey(namespace, key), DefaultHashCommands.this.rawHashKey(hashKey), DefaultHashCommands.this.rawHashValue(value));
            }
        });
    }

    public <H, HK, HV> Long size(final int namespace, final H key) {
        return (Long)this.doInTedis(namespace, new BaseCommands.TedisBlock(this.redisCommands){

            public Object execute() {
                return this.commands.hLen(DefaultHashCommands.this.rawKey(namespace, key));
            }
        });
    }

    public <H, HK, HV> Collection<HV> values(final int namespace, final H key) {
        return this.deserializeHashValues((List)this.doInTedis(namespace, new BaseCommands.TedisBlock(this.redisCommands){

            public Object execute() {
                return this.commands.hVals(DefaultHashCommands.this.rawKey(namespace, key));
            }
        }));
    }
}

