/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.common.tedis.commands;

import com.taobao.common.tedis.TedisException;
import com.taobao.common.tedis.binary.RedisCommands;
import com.taobao.common.tedis.binary.RedisListCommands;
import com.taobao.common.tedis.core.BaseCommands;
import com.taobao.common.tedis.core.ListCommands;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class DefaultListCommands
extends BaseCommands
implements ListCommands {
    protected RedisCommands redisCommands;

    public DefaultListCommands() {
    }

    public DefaultListCommands(RedisCommands redisCommands) {
        this.redisCommands = redisCommands;
    }

    public RedisCommands getRedisCommands() {
        return this.redisCommands;
    }

    public void setRedisCommands(RedisCommands redisCommands) {
        this.redisCommands = redisCommands;
    }

    public void init() {
        if (this.commandsProvider == null) {
            throw new TedisException("commandsProvider is null.please set a commandsProvider first.");
        }
        this.redisCommands = this.commandsProvider.getTedis();
    }

    public <K, V> V index(final int namespace, final K key, final long index) {
        return (V)this.deserializeValue((byte[])this.doInTedis(namespace, new BaseCommands.TedisBlock(this.redisCommands){

            public Object execute() {
                return this.commands.lIndex(DefaultListCommands.this.rawKey(namespace, key), index);
            }
        }));
    }

    public <K, V> V leftPop(final int namespace, final K key) {
        return (V)this.deserializeValue((byte[])this.doInTedis(namespace, new BaseCommands.TedisBlock(this.redisCommands){

            public Object execute() {
                return this.commands.lPop(DefaultListCommands.this.rawKey(namespace, key));
            }
        }));
    }

    public <K, V> V leftPop(final int namespace, final K key, long timeout, TimeUnit unit) {
        final int tm = (int)unit.toSeconds(timeout);
        return (V)this.deserializeValue((byte[])this.doInTedis(namespace, new BaseCommands.TedisBlock(this.redisCommands){

            public Object execute() {
                return this.commands.bLPop(tm, (byte[][])new byte[][]{DefaultListCommands.this.rawKey(namespace, key)});
            }
        }));
    }

    public <K, V> Long leftPush(final int namespace, final K key, final V ... value) {
        return (Long)this.doInTedis(namespace, new BaseCommands.TedisBlock(this.redisCommands){

            public Object execute() {
                return this.commands.lPush(DefaultListCommands.this.rawKey(namespace, key), DefaultListCommands.this.rawValues(value));
            }
        });
    }

    public <K, V> Long leftInsert(final int namespace, final K key, final V pivot, final V value) {
        return (Long)this.doInTedis(namespace, new BaseCommands.TedisBlock(this.redisCommands){

            public Object execute() {
                return this.commands.lInsert(DefaultListCommands.this.rawKey(namespace, key), RedisListCommands.Position.BEFORE, DefaultListCommands.this.rawValue(pivot), DefaultListCommands.this.rawValue(value));
            }
        });
    }

    public <K, V> Long leftPushIfPresent(final int namespace, final K key, final V value) {
        return (Long)this.doInTedis(namespace, new BaseCommands.TedisBlock(this.redisCommands){

            public Object execute() {
                return this.commands.lPushX(DefaultListCommands.this.rawKey(namespace, key), DefaultListCommands.this.rawValue(value));
            }
        });
    }

    public <K, V> List<V> range(final int namespace, final K key, final long start, final long end) {
        return this.deserializeValues((List)this.doInTedis(namespace, new BaseCommands.TedisBlock(this.redisCommands){

            public Object execute() {
                return this.commands.lRange(DefaultListCommands.this.rawKey(namespace, key), start, end);
            }
        }));
    }

    public <K, V> Long remove(final int namespace, final K key, final long i, final Object value) {
        return (Long)this.doInTedis(namespace, new BaseCommands.TedisBlock(this.redisCommands){

            public Object execute() {
                return this.commands.lRem(DefaultListCommands.this.rawKey(namespace, key), i, DefaultListCommands.this.rawValue(value));
            }
        });
    }

    public <K, V> V rightPop(final int namespace, final K key) {
        return (V)this.deserializeValue((byte[])this.doInTedis(namespace, new BaseCommands.TedisBlock(this.redisCommands){

            public Object execute() {
                return this.commands.rPop(DefaultListCommands.this.rawKey(namespace, key));
            }
        }));
    }

    public <K, V> V rightPop(final int namespace, final K key, long timeout, TimeUnit unit) {
        final int tm = (int)unit.toSeconds(timeout);
        return (V)this.deserializeValue((byte[])this.doInTedis(namespace, new BaseCommands.TedisBlock(this.redisCommands){

            public Object execute() {
                return this.commands.bRPop(tm, (byte[][])new byte[][]{DefaultListCommands.this.rawKey(namespace, key)});
            }
        }));
    }

    public <K, V> V rightPopAndLeftPush(final int namespace, final K sourceKey, final K destinationKey) {
        return (V)this.deserializeValue((byte[])this.doInTedis(namespace, new BaseCommands.TedisBlock(this.redisCommands){

            public Object execute() {
                return this.commands.rPopLPush(DefaultListCommands.this.rawKey(namespace, sourceKey), DefaultListCommands.this.rawKey(namespace, destinationKey));
            }
        }));
    }

    public <K, V> V rightPopAndLeftPush(final int namespace, final K sourceKey, final K destinationKey, long timeout, TimeUnit unit) {
        final int tm = (int)unit.toSeconds(timeout);
        return (V)this.deserializeValue((byte[])this.doInTedis(namespace, new BaseCommands.TedisBlock(this.redisCommands){

            public Object execute() {
                return this.commands.bRPopLPush(tm, DefaultListCommands.this.rawKey(namespace, sourceKey), DefaultListCommands.this.rawKey(namespace, destinationKey));
            }
        }));
    }

    public <K, V> Long rightPush(final int namespace, final K key, final V ... value) {
        return (Long)this.doInTedis(namespace, new BaseCommands.TedisBlock(this.redisCommands){

            public Object execute() {
                return this.commands.rPush(DefaultListCommands.this.rawKey(namespace, key), DefaultListCommands.this.rawValues(value));
            }
        });
    }

    public <K, V> Long rightInsert(final int namespace, final K key, final V pivot, final V value) {
        return (Long)this.doInTedis(namespace, new BaseCommands.TedisBlock(this.redisCommands){

            public Object execute() {
                return this.commands.lInsert(DefaultListCommands.this.rawKey(namespace, key), RedisListCommands.Position.AFTER, DefaultListCommands.this.rawValue(pivot), DefaultListCommands.this.rawValue(value));
            }
        });
    }

    public <K, V> Long rightPushIfPresent(final int namespace, final K key, final V value) {
        return (Long)this.doInTedis(namespace, new BaseCommands.TedisBlock(this.redisCommands){

            public Object execute() {
                return this.commands.rPushX(DefaultListCommands.this.rawKey(namespace, key), DefaultListCommands.this.rawValue(value));
            }
        });
    }

    public <K, V> void set(final int namespace, final K key, final long index, final V value) {
        this.doInTedis(namespace, new BaseCommands.TedisBlock(this.redisCommands){

            public Object execute() {
                this.commands.lSet(DefaultListCommands.this.rawKey(namespace, key), index, DefaultListCommands.this.rawValue(value));
                return null;
            }
        });
    }

    public <K, V> Long size(final int namespace, final K key) {
        return (Long)this.doInTedis(namespace, new BaseCommands.TedisBlock(this.redisCommands){

            public Object execute() {
                return this.commands.lLen(DefaultListCommands.this.rawKey(namespace, key));
            }
        });
    }

    public <K, V> void trim(final int namespace, final K key, final long start, final long end) {
        this.doInTedis(namespace, new BaseCommands.TedisBlock(this.redisCommands){

            public Object execute() {
                this.commands.lTrim(DefaultListCommands.this.rawKey(namespace, key), start, end);
                return null;
            }
        });
    }
}

