/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.common.tedis.commands;

import com.taobao.common.tedis.TedisException;
import com.taobao.common.tedis.binary.RedisCommands;
import com.taobao.common.tedis.core.BaseCommands;
import com.taobao.common.tedis.core.SetCommands;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;

public class DefaultSetCommands
extends BaseCommands
implements SetCommands {
    private RedisCommands redisCommands;

    public DefaultSetCommands() {
    }

    public DefaultSetCommands(RedisCommands redisCommands) {
        this.redisCommands = redisCommands;
    }

    public RedisCommands getRedisCommands() {
        return this.redisCommands;
    }

    public void setRedisCommands(RedisCommands redisCommands) {
        this.redisCommands = redisCommands;
    }

    public void init() {
        if (this.commandsProvider == null) {
            throw new TedisException("commandsProvider is null.please set a commandsProvider first.");
        }
        this.redisCommands = this.commandsProvider.getTedis();
    }

    public <K, V> Long add(final int namespace, final K key, final V ... value) {
        return (Long)this.doInTedis(namespace, new BaseCommands.TedisBlock(this.redisCommands){

            public Object execute() {
                return this.commands.sAdd(DefaultSetCommands.this.rawKey(namespace, key), DefaultSetCommands.this.rawValues(value));
            }
        });
    }

    public <K, V> Set<V> difference(int namespace, K key, K otherKey) {
        return this.difference(namespace, key, (Collection<K>)Collections.singleton(otherKey));
    }

    public <K, V> Set<V> difference(final int namespace, final K key, final Collection<K> otherKeys) {
        return this.deserializeValues((Set)this.doInTedis(namespace, new BaseCommands.TedisBlock(this.redisCommands){

            public Object execute() {
                return this.commands.sDiff(DefaultSetCommands.this.rawKeys(namespace, key, otherKeys));
            }
        }));
    }

    public <K, V> void differenceAndStore(int namespace, K key, K otherKey, K destKey) {
        this.differenceAndStore(namespace, key, (Collection<K>)Collections.singleton(otherKey), destKey);
    }

    public <K, V> void differenceAndStore(final int namespace, final K key, final Collection<K> otherKeys, final K destKey) {
        this.doInTedis(namespace, new BaseCommands.TedisBlock(this.redisCommands){

            public Object execute() {
                this.commands.sDiffStore(DefaultSetCommands.this.rawKey(namespace, destKey), DefaultSetCommands.this.rawKeys(namespace, key, otherKeys));
                return null;
            }
        });
    }

    public <K, V> Set<V> intersect(int namespace, K key, K otherKey) {
        return this.intersect(namespace, key, (Collection<K>)Collections.singleton(otherKey));
    }

    public <K, V> Set<V> intersect(final int namespace, final K key, final Collection<K> otherKeys) {
        return this.deserializeValues((Set)this.doInTedis(namespace, new BaseCommands.TedisBlock(this.redisCommands){

            public Object execute() {
                return this.commands.sInter(DefaultSetCommands.this.rawKeys(namespace, key, otherKeys));
            }
        }));
    }

    public <K, V> void intersectAndStore(int namespace, K key, K otherKey, K destKey) {
        this.intersectAndStore(namespace, key, (Collection<K>)Collections.singleton(otherKey), destKey);
    }

    public <K, V> void intersectAndStore(final int namespace, final K key, final Collection<K> otherKeys, final K destKey) {
        this.doInTedis(namespace, new BaseCommands.TedisBlock(this.redisCommands){

            public Object execute() {
                this.commands.sInterStore(DefaultSetCommands.this.rawKey(namespace, destKey), DefaultSetCommands.this.rawKeys(namespace, key, otherKeys));
                return null;
            }
        });
    }

    public <K, V> Boolean isMember(final int namespace, final K key, final Object o) {
        return (Boolean)this.doInTedis(namespace, new BaseCommands.TedisBlock(this.redisCommands){

            public Object execute() {
                return this.commands.sIsMember(DefaultSetCommands.this.rawKey(namespace, key), DefaultSetCommands.this.rawValue(o));
            }
        });
    }

    public <K, V> Set<V> members(final int namespace, final K key) {
        return this.deserializeValues((Set)this.doInTedis(namespace, new BaseCommands.TedisBlock(this.redisCommands){

            public Object execute() {
                return this.commands.sMembers(DefaultSetCommands.this.rawKey(namespace, key));
            }
        }));
    }

    public <K, V> Boolean move(final int namespace, final K key, final V value, final K destKey) {
        return (Boolean)this.doInTedis(namespace, new BaseCommands.TedisBlock(this.redisCommands){

            public Object execute() {
                return this.commands.sMove(DefaultSetCommands.this.rawKey(namespace, key), DefaultSetCommands.this.rawKey(namespace, destKey), DefaultSetCommands.this.rawValue(value));
            }
        });
    }

    public <K, V> V pop(final int namespace, final K key) {
        return (V)this.deserializeValue((byte[])this.doInTedis(namespace, new BaseCommands.TedisBlock(this.redisCommands){

            public Object execute() {
                return this.commands.sPop(DefaultSetCommands.this.rawKey(namespace, key));
            }
        }));
    }

    public <K, V> V randomMember(final int namespace, final K key) {
        return (V)this.deserializeValue((byte[])this.doInTedis(namespace, new BaseCommands.TedisBlock(this.redisCommands){

            public Object execute() {
                return this.commands.sRandMember(DefaultSetCommands.this.rawKey(namespace, key));
            }
        }));
    }

    public <K, V> Long remove(final int namespace, final K key, final Object ... o) {
        return (Long)this.doInTedis(namespace, new BaseCommands.TedisBlock(this.redisCommands){

            public Object execute() {
                return this.commands.sRem(DefaultSetCommands.this.rawKey(namespace, key), DefaultSetCommands.this.rawValues(o));
            }
        });
    }

    public <K, V> Long size(final int namespace, final K key) {
        return (Long)this.doInTedis(namespace, new BaseCommands.TedisBlock(this.redisCommands){

            public Object execute() {
                return this.commands.sCard(DefaultSetCommands.this.rawKey(namespace, key));
            }
        });
    }

    public <K, V> Set<V> union(int namespace, K key, K otherKey) {
        return this.union(namespace, key, (Collection<K>)Collections.singleton(otherKey));
    }

    public <K, V> Set<V> union(final int namespace, final K key, final Collection<K> otherKeys) {
        return this.deserializeValues((Set)this.doInTedis(namespace, new BaseCommands.TedisBlock(this.redisCommands){

            public Object execute() {
                return this.commands.sUnion(DefaultSetCommands.this.rawKeys(namespace, key, otherKeys));
            }
        }));
    }

    public <K, V> void unionAndStore(int namespace, K key, K otherKey, K destKey) {
        this.unionAndStore(namespace, key, (Collection<K>)Collections.singleton(otherKey), destKey);
    }

    public <K, V> void unionAndStore(final int namespace, final K key, final Collection<K> otherKeys, final K destKey) {
        this.doInTedis(namespace, new BaseCommands.TedisBlock(this.redisCommands){

            public Object execute() {
                this.commands.sUnionStore(DefaultSetCommands.this.rawKey(namespace, destKey), DefaultSetCommands.this.rawKeys(namespace, key, otherKeys));
                return null;
            }
        });
    }
}

