/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.common.tedis.commands;

import com.taobao.common.tedis.TedisException;
import com.taobao.common.tedis.binary.RedisCommands;
import com.taobao.common.tedis.core.BaseCommands;
import com.taobao.common.tedis.core.StringCommands;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class DefaultStringCommands
extends BaseCommands
implements StringCommands {
    private RedisCommands redisCommands;

    public DefaultStringCommands() {
        this.setKeySerializer(this.stringSerializer);
        this.setValueSerializer(this.stringSerializer);
    }

    public DefaultStringCommands(RedisCommands redisCommands) {
        this.redisCommands = redisCommands;
        this.setKeySerializer(this.stringSerializer);
        this.setValueSerializer(this.stringSerializer);
    }

    public RedisCommands getRedisCommands() {
        return this.redisCommands;
    }

    public void setRedisCommands(RedisCommands redisCommands) {
        this.redisCommands = redisCommands;
    }

    public void init() {
        if (this.commandsProvider == null) {
            throw new TedisException("commandsProvider is null.please set a commandsProvider first.");
        }
        this.redisCommands = this.commandsProvider.getTedis();
    }

    public Long append(final int namespace, final String key, final String value) {
        return (Long)this.doInTedis(namespace, new BaseCommands.TedisBlock(this.redisCommands){

            public Object execute() {
                return this.commands.append(DefaultStringCommands.this.rawKey(namespace, key), DefaultStringCommands.this.rawString(value));
            }
        });
    }

    public String get(final int namespace, final Object key) {
        return this.deserializeString((byte[])this.doInTedis(namespace, new BaseCommands.TedisBlock(this.redisCommands){

            public Object execute() {
                return this.commands.get(DefaultStringCommands.this.rawKey(namespace, key));
            }
        }));
    }

    public String get(final int namespace, final String key, final long start, final long end) {
        return this.deserializeString((byte[])this.doInTedis(namespace, new BaseCommands.TedisBlock(this.redisCommands){

            public Object execute() {
                return this.commands.getRange(DefaultStringCommands.this.rawKey(namespace, key), (long)((int)start), (long)((int)end));
            }
        }));
    }

    public String getAndSet(final int namespace, final String key, final String value) {
        return this.deserializeString((byte[])this.doInTedis(namespace, new BaseCommands.TedisBlock(this.redisCommands){

            public Object execute() {
                return this.commands.getSet(DefaultStringCommands.this.rawKey(namespace, key), DefaultStringCommands.this.rawString(value));
            }
        }));
    }

    public List<String> multiGet(int namespace, Collection<String> keys) {
        if (keys.isEmpty()) {
            return Collections.emptyList();
        }
        final byte[][] rawKeys = new byte[keys.size()][];
        int counter = 0;
        for (String hashKey : keys) {
            rawKeys[counter++] = this.rawKey(namespace, hashKey);
        }
        return this.deserializeStrings((List)this.doInTedis(namespace, new BaseCommands.TedisBlock(this.redisCommands){

            public Object execute() {
                return this.commands.mGet(rawKeys);
            }
        }));
    }

    public void multiSet(int namespace, Map<String, String> m) {
        if (m.isEmpty()) {
            return;
        }
        final LinkedHashMap<byte[], byte[]> rawKeys = new LinkedHashMap<byte[], byte[]>(m.size());
        for (Map.Entry<String, String> entry : m.entrySet()) {
            rawKeys.put(this.rawKey(namespace, entry.getKey()), this.rawString(entry.getValue()));
        }
        this.doInTedis(namespace, new BaseCommands.TedisBlock(this.redisCommands){

            public Object execute() {
                this.commands.mSet(rawKeys);
                return null;
            }
        });
    }

    public void multiSetIfAbsent(int namespace, Map<String, String> m) {
        if (m.isEmpty()) {
            return;
        }
        final LinkedHashMap<byte[], byte[]> rawKeys = new LinkedHashMap<byte[], byte[]>(m.size());
        for (Map.Entry<String, String> entry : m.entrySet()) {
            rawKeys.put(this.rawKey(namespace, entry.getKey()), this.rawString(entry.getValue()));
        }
        this.doInTedis(namespace, new BaseCommands.TedisBlock(this.redisCommands){

            public Object execute() {
                this.commands.mSetNX(rawKeys);
                return null;
            }
        });
    }

    public void set(final int namespace, final String key, final String value) {
        this.doInTedis(namespace, new BaseCommands.TedisBlock(this.redisCommands){

            public Object execute() {
                this.commands.set(DefaultStringCommands.this.rawKey(namespace, key), DefaultStringCommands.this.rawString(value));
                return null;
            }
        });
    }

    public void set(final int namespace, final String key, final String value, final long timeout, final TimeUnit unit) {
        this.doInTedis(namespace, new BaseCommands.TedisBlock(this.redisCommands){

            public Object execute() {
                this.commands.setEx(DefaultStringCommands.this.rawKey(namespace, key), (long)((int)unit.toSeconds(timeout)), DefaultStringCommands.this.rawString(value));
                return null;
            }
        });
    }

    public void set(final int namespace, final String key, final String value, final long offset) {
        this.doInTedis(namespace, new BaseCommands.TedisBlock(this.redisCommands){

            public Object execute() {
                this.commands.setRange(DefaultStringCommands.this.rawKey(namespace, key), DefaultStringCommands.this.rawString(value), offset);
                return null;
            }
        });
    }

    public Boolean setIfAbsent(final int namespace, final String key, final String value) {
        return (Boolean)this.doInTedis(namespace, new BaseCommands.TedisBlock(this.redisCommands){

            public Object execute() {
                return this.commands.setNX(DefaultStringCommands.this.rawKey(namespace, key), DefaultStringCommands.this.rawString(value));
            }
        });
    }

    public Long size(final int namespace, final String key) {
        return (Long)this.doInTedis(namespace, new BaseCommands.TedisBlock(this.redisCommands){

            public Object execute() {
                return this.commands.strLen(DefaultStringCommands.this.rawKey(namespace, key));
            }
        });
    }
}

