/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.common.tedis.commands;

import com.taobao.common.tedis.Group;
import com.taobao.common.tedis.TedisException;
import com.taobao.common.tedis.binary.DataType;
import com.taobao.common.tedis.binary.RedisCommands;
import com.taobao.common.tedis.commands.DefaultAtomicCommands;
import com.taobao.common.tedis.commands.DefaultHashCommands;
import com.taobao.common.tedis.commands.DefaultListCommands;
import com.taobao.common.tedis.commands.DefaultSetCommands;
import com.taobao.common.tedis.commands.DefaultStringCommands;
import com.taobao.common.tedis.commands.DefaultValueCommands;
import com.taobao.common.tedis.commands.DefaultZSetCommands;
import com.taobao.common.tedis.core.AtomicCommands;
import com.taobao.common.tedis.core.BaseCommands;
import com.taobao.common.tedis.core.HashCommands;
import com.taobao.common.tedis.core.ListCommands;
import com.taobao.common.tedis.core.SetCommands;
import com.taobao.common.tedis.core.StringCommands;
import com.taobao.common.tedis.core.TedisManager;
import com.taobao.common.tedis.core.ValueCommands;
import com.taobao.common.tedis.core.ZSetCommands;
import com.taobao.common.tedis.serializer.SerializationUtils;
import com.taobao.common.tedis.serializer.TedisSerializer;
import com.taobao.common.tedis.util.SortParams;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;

public class DefaultTedisManager
extends BaseCommands
implements TedisManager {
    private RedisCommands redisCommands;
    private DefaultAtomicCommands atomicCommands;
    private DefaultStringCommands stringCommands;
    private DefaultValueCommands valueCommands;
    private DefaultListCommands listCommands;
    private DefaultHashCommands hashCommands;
    private DefaultSetCommands setCommands;
    private DefaultZSetCommands zSetCommands;

    public DefaultTedisManager() {
    }

    public DefaultTedisManager(Group provider) {
        this.commandsProvider = provider;
        this.init();
    }

    public void setRedisCommands(Group provider) {
        this.commandsProvider = provider;
        this.init();
    }

    private void init() {
        if (this.commandsProvider == null) {
            throw new TedisException("commandsProvider is null.please set a commandsProvider first.");
        }
        this.redisCommands = this.commandsProvider.getTedis();
    }

    public <K> void delete(int namespace, K key) {
        this.delete(namespace, (Collection<K>)Collections.singleton(key));
    }

    public <K> void delete(final int namespace, final Collection<K> keys) {
        this.doInTedis(namespace, new BaseCommands.TedisBlock(this.redisCommands){

            public Object execute() {
                this.commands.del(DefaultTedisManager.this.rawKeys(namespace, keys));
                return null;
            }
        });
    }

    public <K> Boolean expire(final int namespace, final K key, long timeout, TimeUnit unit) {
        final long seconds = unit.toSeconds(timeout);
        return (Boolean)this.doInTedis(namespace, new BaseCommands.TedisBlock(this.redisCommands){

            public Object execute() {
                return this.commands.expire(DefaultTedisManager.this.rawKey(namespace, key), seconds);
            }
        });
    }

    public <K> Boolean expireAt(final int namespace, final K key, final Date date) {
        return (Boolean)this.doInTedis(namespace, new BaseCommands.TedisBlock(this.redisCommands){

            public Object execute() {
                return this.commands.expireAt(DefaultTedisManager.this.rawKey(namespace, key), date.getTime());
            }
        });
    }

    public AtomicCommands getAtomicCommands() {
        if (this.atomicCommands == null) {
            this.atomicCommands = new DefaultAtomicCommands(this.redisCommands);
            this.initSerializer(this.atomicCommands);
        }
        return this.atomicCommands;
    }

    public <K> Long getExpire(final int namespace, final K key) {
        return (Long)this.doInTedis(namespace, new BaseCommands.TedisBlock(this.redisCommands){

            public Object execute() {
                return this.commands.ttl(DefaultTedisManager.this.rawKey(namespace, key));
            }
        });
    }

    public HashCommands getHashCommands() {
        if (this.hashCommands == null) {
            this.hashCommands = new DefaultHashCommands(this.redisCommands);
            this.initSerializer(this.hashCommands);
        }
        return this.hashCommands;
    }

    public ListCommands getListCommands() {
        if (this.listCommands == null) {
            this.listCommands = new DefaultListCommands(this.redisCommands);
            this.initSerializer(this.listCommands);
        }
        return this.listCommands;
    }

    public SetCommands getSetCommands() {
        if (this.setCommands == null) {
            this.setCommands = new DefaultSetCommands(this.redisCommands);
            this.initSerializer(this.setCommands);
        }
        return this.setCommands;
    }

    public StringCommands getStringCommands() {
        if (this.stringCommands == null) {
            this.stringCommands = new DefaultStringCommands(this.redisCommands);
            this.initSerializer(this.stringCommands);
        }
        return this.stringCommands;
    }

    public ValueCommands getValueCommands() {
        if (this.valueCommands == null) {
            this.valueCommands = new DefaultValueCommands(this.redisCommands);
            this.initSerializer(this.valueCommands);
        }
        return this.valueCommands;
    }

    public ZSetCommands getZSetCommands() {
        if (this.zSetCommands == null) {
            this.zSetCommands = new DefaultZSetCommands(this.redisCommands);
            this.initSerializer(this.zSetCommands);
        }
        return this.zSetCommands;
    }

    private void initSerializer(BaseCommands baseCommands) {
        baseCommands.setKeySerializer(this.getKeySerializer());
        baseCommands.setValueSerializer(this.getValueSerializer());
        baseCommands.setStringSerializer(this.getStringSerializer());
        baseCommands.setHashKeySerializer(this.getHashKeySerializer());
        baseCommands.setHashValueSerializer(this.getHashValueSerializer());
    }

    public <K> Boolean hasKey(final int namespace, final K key) {
        return (Boolean)this.doInTedis(namespace, new BaseCommands.TedisBlock(this.redisCommands){

            public Object execute() {
                return this.commands.exists(DefaultTedisManager.this.rawKey(namespace, key));
            }
        });
    }

    public <K> Set<K> keys(final int namespace, final String pattern) {
        Set bytekeys = (Set)this.doInTedis(namespace, new BaseCommands.TedisBlock(this.redisCommands){

            public Object execute() {
                return this.commands.keys((namespace + ":" + pattern).getBytes());
            }
        });
        HashSet<byte[]> newbytekeys = new HashSet<byte[]>();
        for (byte[] bytekey : bytekeys) {
            newbytekeys.add(this.removeNamespaceFromKey(bytekey));
        }
        return SerializationUtils.deserialize(newbytekeys, (TedisSerializer)this.getKeySerializer());
    }

    public <K> Boolean persist(final int namespace, final K key) {
        return (Boolean)this.doInTedis(namespace, new BaseCommands.TedisBlock(this.redisCommands){

            public Object execute() {
                return this.commands.persist(DefaultTedisManager.this.rawKey(namespace, key));
            }
        });
    }

    public <K> void rename(final int namespace, final K oldKey, final K newKey) {
        this.doInTedis(namespace, new BaseCommands.TedisBlock(this.redisCommands){

            public Object execute() {
                this.commands.rename(DefaultTedisManager.this.rawKey(namespace, oldKey), DefaultTedisManager.this.rawKey(namespace, newKey));
                return null;
            }
        });
    }

    public <K> Boolean renameIfAbsent(final int namespace, final K oldKey, final K newKey) {
        return (Boolean)this.doInTedis(namespace, new BaseCommands.TedisBlock(this.redisCommands){

            public Object execute() {
                return this.commands.renameNX(DefaultTedisManager.this.rawKey(namespace, oldKey), DefaultTedisManager.this.rawKey(namespace, newKey));
            }
        });
    }

    public <K, V> List<V> sort(final int namespace, final K key, final SortParams params) {
        return this.deserializeValues((List)this.doInTedis(namespace, new BaseCommands.TedisBlock(this.redisCommands){

            public Object execute() {
                return this.commands.sort(DefaultTedisManager.this.rawKey(namespace, key), params);
            }
        }));
    }

    public <K> Long sort(final int namespace, final K key, final SortParams params, final K storeKey) {
        return (Long)this.doInTedis(namespace, new BaseCommands.TedisBlock(this.redisCommands){

            public Object execute() {
                return this.commands.sort(DefaultTedisManager.this.rawKey(namespace, key), params, DefaultTedisManager.this.rawKey(namespace, storeKey));
            }
        });
    }

    public <K> DataType type(final int namespace, final K key) {
        return DataType.fromCode((String)((String)this.doInTedis(namespace, new BaseCommands.TedisBlock(this.redisCommands){

            public Object execute() {
                return this.commands.type(DefaultTedisManager.this.rawKey(namespace, key));
            }
        })));
    }

    public Group getProvider() {
        return this.commandsProvider;
    }

    public void destroy() {
        if (this.commandsProvider != null) {
            this.commandsProvider.destroy();
        }
    }
}

