/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.common.tedis.commands;

import com.taobao.common.tedis.TedisException;
import com.taobao.common.tedis.binary.RedisCommands;
import com.taobao.common.tedis.cache.DefaultLocalCache;
import com.taobao.common.tedis.cache.LocalCache;
import com.taobao.common.tedis.core.BaseCommands;
import com.taobao.common.tedis.core.ValueCommands;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class DefaultValueCommands
extends BaseCommands
implements ValueCommands {
    protected RedisCommands redisCommands;
    protected LocalCache localCache;

    public DefaultValueCommands() {
        this.localCache = new DefaultLocalCache();
    }

    public DefaultValueCommands(RedisCommands redisCommands) {
        this.redisCommands = redisCommands;
        this.localCache = new DefaultLocalCache();
    }

    public RedisCommands getRedisCommands() {
        return this.redisCommands;
    }

    public void setRedisCommands(RedisCommands redisCommands) {
        this.redisCommands = redisCommands;
    }

    public void init() {
        if (this.commandsProvider == null) {
            throw new TedisException("commandsProvider is null.please set a commandsProvider first.");
        }
        this.redisCommands = this.commandsProvider.getTedis();
    }

    public <K, V> V get(final int namespace, final K key) {
        return (V)this.deserializeValue((byte[])this.doInTedis(namespace, new BaseCommands.TedisBlock(this.redisCommands){

            public Object execute() {
                return this.commands.get(DefaultValueCommands.this.rawKey(namespace, key));
            }
        }));
    }

    public <K, V> V getAndSet(final int namespace, final K key, final V value) {
        return (V)this.deserializeValue((byte[])this.doInTedis(namespace, new BaseCommands.TedisBlock(this.redisCommands){

            public Object execute() {
                return this.commands.getSet(DefaultValueCommands.this.rawKey(namespace, key), DefaultValueCommands.this.rawValue(value));
            }
        }));
    }

    public <K, V> List<V> multiGet(int namespace, Collection<K> keys) {
        if (keys.isEmpty()) {
            return Collections.emptyList();
        }
        final byte[][] rawKeys = new byte[keys.size()][];
        int counter = 0;
        for (K hashKey : keys) {
            rawKeys[counter++] = this.rawKey(namespace, hashKey);
        }
        return this.deserializeValues((List)this.doInTedis(namespace, new BaseCommands.TedisBlock(this.redisCommands){

            public Object execute() {
                return this.commands.mGet(rawKeys);
            }
        }));
    }

    public <K, V> void multiSet(int namespace, Map<? extends K, ? extends V> m) {
        if (m.isEmpty()) {
            return;
        }
        final LinkedHashMap<byte[], byte[]> rawKeys = new LinkedHashMap<byte[], byte[]>(m.size());
        for (Map.Entry<K, V> entry : m.entrySet()) {
            rawKeys.put(this.rawKey(namespace, entry.getKey()), this.rawValue(entry.getValue()));
        }
        this.doInTedis(namespace, new BaseCommands.TedisBlock(this.redisCommands){

            public Object execute() {
                this.commands.mSet(rawKeys);
                return null;
            }
        });
    }

    public <K, V> void multiSetIfAbsent(int namespace, Map<? extends K, ? extends V> m) {
        if (m.isEmpty()) {
            return;
        }
        final LinkedHashMap<byte[], byte[]> rawKeys = new LinkedHashMap<byte[], byte[]>(m.size());
        for (Map.Entry<K, V> entry : m.entrySet()) {
            rawKeys.put(this.rawKey(namespace, entry.getKey()), this.rawValue(entry.getValue()));
        }
        this.doInTedis(namespace, new BaseCommands.TedisBlock(this.redisCommands){

            public Object execute() {
                this.commands.mSetNX(rawKeys);
                return null;
            }
        });
    }

    public <K, V> void set(final int namespace, final K key, final V value) {
        this.doInTedis(namespace, new BaseCommands.TedisBlock(this.redisCommands){

            public Object execute() {
                this.commands.set(DefaultValueCommands.this.rawKey(namespace, key), DefaultValueCommands.this.rawValue(value));
                return null;
            }
        });
    }

    public <K, V> void set(final int namespace, final K key, final V value, final long timeout, final TimeUnit unit) {
        this.doInTedis(namespace, new BaseCommands.TedisBlock(this.redisCommands){

            public Object execute() {
                this.commands.setEx(DefaultValueCommands.this.rawKey(namespace, key), (long)((int)unit.toSeconds(timeout)), DefaultValueCommands.this.rawValue(value));
                return null;
            }
        });
    }

    public <K, V> Boolean setIfAbsent(final int namespace, final K key, final V value) {
        return (Boolean)this.doInTedis(namespace, new BaseCommands.TedisBlock(this.redisCommands){

            public Object execute() {
                return this.commands.setNX(DefaultValueCommands.this.rawKey(namespace, key), DefaultValueCommands.this.rawValue(value));
            }
        });
    }

    public <K, V> V get(int namespace, K key, long timeout, TimeUnit unit) {
        Object result = this.localCache.get(key);
        if (result == null && (result = this.get(namespace, key)) != null) {
            this.localCache.put(key, result, (int)unit.toSeconds(timeout));
        }
        return (V)result;
    }

    public <K, V> V get(int namespace, K key, Date expireAt) {
        Object result = this.localCache.get(key);
        if (result == null && (result = this.get(namespace, key)) != null) {
            this.localCache.put(key, result, expireAt);
        }
        return (V)result;
    }

    public <K, V> List<V> multiGet(int namespace, Collection<K> keys, long timeout, TimeUnit unit) {
        throw new UnsupportedOperationException();
    }

    public <K, V> List<V> multiGet(int namespace, Collection<K> keys, Date expireAt) {
        throw new UnsupportedOperationException();
    }
}

