/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.common.tedis.commands;

import com.taobao.common.tedis.TedisException;
import com.taobao.common.tedis.binary.RedisCommands;
import com.taobao.common.tedis.binary.RedisZSetCommands;
import com.taobao.common.tedis.core.BaseCommands;
import com.taobao.common.tedis.core.ZSetCommands;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;

public class DefaultZSetCommands
extends BaseCommands
implements ZSetCommands {
    private RedisCommands redisCommands;

    public <K, V> DefaultZSetCommands() {
    }

    public <K, V> DefaultZSetCommands(RedisCommands redisCommands) {
        this.redisCommands = redisCommands;
    }

    public <K, V> RedisCommands getRedisCommands() {
        return this.redisCommands;
    }

    public <K, V> void setRedisCommands(RedisCommands redisCommands) {
        this.redisCommands = redisCommands;
    }

    public <K, V> void init() {
        if (this.commandsProvider == null) {
            throw new TedisException("commandsProvider is null.please set a commandsProvider first.");
        }
        this.redisCommands = this.commandsProvider.getTedis();
    }

    public <K, V> Boolean add(final int namespace, final K key, final V value, final double score) {
        return (Boolean)this.doInTedis(namespace, new BaseCommands.TedisBlock(this.redisCommands){

            public Object execute() {
                return this.commands.zAdd(DefaultZSetCommands.this.rawKey(namespace, key), score, DefaultZSetCommands.this.rawValue(value));
            }
        });
    }

    public <K, V> Long add(final int namespace, final K key, Map<V, Double> maps) {
        final RedisZSetCommands.Tuple[] tuples = new RedisZSetCommands.Tuple[maps.size()];
        int i = 0;
        for (Map.Entry<V, Double> m : maps.entrySet()) {
            tuples[i++] = new RedisZSetCommands.Tuple(this.rawValue(m.getKey()), m.getValue().doubleValue());
        }
        return (Long)this.doInTedis(namespace, new BaseCommands.TedisBlock(this.redisCommands){

            public Object execute() {
                return this.commands.zAdd(DefaultZSetCommands.this.rawKey(namespace, key), tuples);
            }
        });
    }

    public <K, V> Long count(final int namespace, final K key, final double min, final double max) {
        return (Long)this.doInTedis(namespace, new BaseCommands.TedisBlock(this.redisCommands){

            public Object execute() {
                return this.commands.zCount(DefaultZSetCommands.this.rawKey(namespace, key), min, max);
            }
        });
    }

    public <K, V> Double incrementScore(final int namespace, final K key, final V value, final double delta) {
        return (Double)this.doInTedis(namespace, new BaseCommands.TedisBlock(this.redisCommands){

            public Object execute() {
                return this.commands.zIncrBy(DefaultZSetCommands.this.rawKey(namespace, key), delta, DefaultZSetCommands.this.rawValue(value));
            }
        });
    }

    public <K, V> void intersectAndStore(int namespace, K key, K otherKey, K destKey) {
        this.intersectAndStore(namespace, key, (Collection<K>)Collections.singleton(otherKey), destKey);
    }

    public <K, V> void intersectAndStore(final int namespace, final K key, final Collection<K> otherKeys, final K destKey) {
        this.doInTedis(namespace, new BaseCommands.TedisBlock(this.redisCommands){

            public Object execute() {
                return this.commands.zInterStore(DefaultZSetCommands.this.rawKey(namespace, destKey), DefaultZSetCommands.this.rawKeys(namespace, key, otherKeys));
            }
        });
    }

    public <K, V> Set<V> range(final int namespace, final K key, final long start, final long end) {
        return this.deserializeValues((Set)this.doInTedis(namespace, new BaseCommands.TedisBlock(this.redisCommands){

            public Object execute() {
                return this.commands.zRange(DefaultZSetCommands.this.rawKey(namespace, key), start, end);
            }
        }));
    }

    public <K, V> Map<V, Double> rangeWithScore(final int namespace, final K key, final long start, final long end) {
        return this.deserializeTruble((Set)this.doInTedis(namespace, new BaseCommands.TedisBlock(this.redisCommands){

            public Object execute() {
                return this.commands.zRangeWithScore(DefaultZSetCommands.this.rawKey(namespace, key), start, end);
            }
        }));
    }

    public <K, V> Set<V> rangeByScore(final int namespace, final K key, final double min, final double max) {
        return this.deserializeValues((Set)this.doInTedis(namespace, new BaseCommands.TedisBlock(this.redisCommands){

            public Object execute() {
                return this.commands.zRangeByScore(DefaultZSetCommands.this.rawKey(namespace, key), min, max);
            }
        }));
    }

    public <K, V> Set<V> rangeByScore(final int namespace, final K key, final double min, final double max, final int offset, final int count) {
        return this.deserializeValues((Set)this.doInTedis(namespace, new BaseCommands.TedisBlock(this.redisCommands){

            public Object execute() {
                return this.commands.zRangeByScore(DefaultZSetCommands.this.rawKey(namespace, key), min, max, (long)offset, (long)count);
            }
        }));
    }

    public <K, V> Map<V, Double> rangeByScoreWithScore(final int namespace, final K key, final double min, final double max) {
        return this.deserializeTruble((Set)this.doInTedis(namespace, new BaseCommands.TedisBlock(this.redisCommands){

            public Object execute() {
                return this.commands.zRangeByScoreWithScore(DefaultZSetCommands.this.rawKey(namespace, key), min, max);
            }
        }));
    }

    public <K, V> Long rank(final int namespace, final K key, final Object o) {
        return (Long)this.doInTedis(namespace, new BaseCommands.TedisBlock(this.redisCommands){

            public Object execute() {
                return this.commands.zRank(DefaultZSetCommands.this.rawKey(namespace, key), DefaultZSetCommands.this.rawValue(o));
            }
        });
    }

    public <K, V> Long remove(final int namespace, final K key, final Object ... o) {
        return (Long)this.doInTedis(namespace, new BaseCommands.TedisBlock(this.redisCommands){

            public Object execute() {
                return this.commands.zRem(DefaultZSetCommands.this.rawKey(namespace, key), DefaultZSetCommands.this.rawValues(o));
            }
        });
    }

    public <K, V> void removeRange(final int namespace, final K key, final long start, final long end) {
        this.doInTedis(namespace, new BaseCommands.TedisBlock(this.redisCommands){

            public Object execute() {
                return this.commands.zRemRange(DefaultZSetCommands.this.rawKey(namespace, key), start, end);
            }
        });
    }

    public <K, V> void removeRangeByScore(final int namespace, final K key, final double min, final double max) {
        this.doInTedis(namespace, new BaseCommands.TedisBlock(this.redisCommands){

            public Object execute() {
                return this.commands.zRemRangeByScore(DefaultZSetCommands.this.rawKey(namespace, key), min, max);
            }
        });
    }

    public <K, V> Set<V> reverseRange(final int namespace, final K key, final long start, final long end) {
        return this.deserializeValues((Set)this.doInTedis(namespace, new BaseCommands.TedisBlock(this.redisCommands){

            public Object execute() {
                return this.commands.zRevRange(DefaultZSetCommands.this.rawKey(namespace, key), start, end);
            }
        }));
    }

    public <K, V> Set<V> reverseRangeByScore(final int namespace, final K key, final double min, final double max) {
        return this.deserializeValues((Set)this.doInTedis(namespace, new BaseCommands.TedisBlock(this.redisCommands){

            public Object execute() {
                return this.commands.zRevRangeByScore(DefaultZSetCommands.this.rawKey(namespace, key), min, max);
            }
        }));
    }

    public <K, V> Map<V, Double> reverseRangeWithScore(final int namespace, final K key, final long start, final long end) {
        return this.deserializeTruble((Set)this.doInTedis(namespace, new BaseCommands.TedisBlock(this.redisCommands){

            public Object execute() {
                return this.commands.zRevRangeWithScore(DefaultZSetCommands.this.rawKey(namespace, key), start, end);
            }
        }));
    }

    public <K, V> Long reverseRank(final int namespace, final K key, final Object o) {
        return (Long)this.doInTedis(namespace, new BaseCommands.TedisBlock(this.redisCommands){

            public Object execute() {
                return this.commands.zRevRank(DefaultZSetCommands.this.rawKey(namespace, key), DefaultZSetCommands.this.rawValue(o));
            }
        });
    }

    public <K, V> Double score(final int namespace, final K key, final Object o) {
        return (Double)this.doInTedis(namespace, new BaseCommands.TedisBlock(this.redisCommands){

            public Object execute() {
                return this.commands.zScore(DefaultZSetCommands.this.rawKey(namespace, key), DefaultZSetCommands.this.rawValue(o));
            }
        });
    }

    public <K, V> Long size(final int namespace, final K key) {
        return (Long)this.doInTedis(namespace, new BaseCommands.TedisBlock(this.redisCommands){

            public Object execute() {
                return this.commands.zCard(DefaultZSetCommands.this.rawKey(namespace, key));
            }
        });
    }

    public <K, V> void unionAndStore(int namespace, K key, K otherKey, K destKey) {
        this.unionAndStore(namespace, key, (Collection<K>)Collections.singleton(otherKey), destKey);
    }

    public <K, V> void unionAndStore(final int namespace, final K key, final Collection<K> otherKeys, final K destKey) {
        this.doInTedis(namespace, new BaseCommands.TedisBlock(this.redisCommands){

            public Object execute() {
                return this.commands.zUnionStore(DefaultZSetCommands.this.rawKey(namespace, destKey), DefaultZSetCommands.this.rawKeys(namespace, key, otherKeys));
            }
        });
    }

    public <K, V> Set<V> reverseRangeByScore(final int namespace, final K key, final double min, final double max, final int offset, final int count) {
        return this.deserializeValues((Set)this.doInTedis(namespace, new BaseCommands.TedisBlock(this.redisCommands){

            public Object execute() {
                return this.commands.zRevRangeByScore(DefaultZSetCommands.this.rawKey(namespace, key), min, max, (long)offset, (long)count);
            }
        }));
    }
}

