/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.common.tedis.commands;

import com.taobao.common.tedis.commands.DefaultTedisManager;
import com.taobao.common.tedis.core.TedisManager;
import com.taobao.common.tedis.group.TedisGroup;
import com.taobao.common.tedis.serializer.TedisSerializer;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class TedisManagerFactory {
    private static ConcurrentHashMap<String, TedisManager> managers = new ConcurrentHashMap();

    public static synchronized TedisManager create(String appName, String version) {
        String key = appName + "-" + version;
        TedisManager manager = managers.get(key);
        if (manager == null) {
            TedisGroup tedisGroup = new TedisGroup(appName, version);
            tedisGroup.init();
            manager = new DefaultTedisManager(tedisGroup);
            managers.put(key, manager);
        }
        return manager;
    }

    public static synchronized TedisManager create(String appName, String version, TedisSerializer<?> serializer) {
        String key = appName + "-" + version;
        DefaultTedisManager manager = (DefaultTedisManager)managers.get(key);
        if (manager == null) {
            TedisGroup tedisGroup = new TedisGroup(appName, version);
            tedisGroup.init();
            manager = new DefaultTedisManager(tedisGroup);
            managers.put(key, manager);
        }
        manager.setKeySerializer(serializer);
        manager.setValueSerializer(serializer);
        manager.setHashKeySerializer(serializer);
        return manager;
    }

    public static synchronized void destroy(TedisManager manager) {
        Iterator<Map.Entry<String, TedisManager>> it = managers.entrySet().iterator();
        while (it.hasNext()) {
            if (!it.next().getValue().equals(manager)) continue;
            it.remove();
        }
        manager.destroy();
    }
}

