/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.common.tedis.group;

import com.taobao.common.tedis.config.ConfigManager;
import com.taobao.common.tedis.config.HAConfig;
import com.taobao.common.tedis.config.Router;
import com.taobao.common.tedis.group.MSRandomRouter;
import com.taobao.common.tedis.group.RandomRouter;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FileConfigManager
implements ConfigManager {
    static Log logger = LogFactory.getLog(FileConfigManager.class);
    public static String defaultConfigFile = "tedis.config";
    volatile Router router;
    String configKey;
    int timeout = 3000;
    public volatile HAConfig haConfig;
    Executor e = Executors.newSingleThreadExecutor();
    String appName;
    String version;

    public FileConfigManager(String appName, String version) {
        this.initLocal(appName, version);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initLocal(String appName, String version) {
        this.appName = appName;
        this.version = version;
        InputStream in = null;
        BufferedReader reader = null;
        StringBuilder configString = new StringBuilder();
        try {
            in = FileConfigManager.class.getResourceAsStream("/" + appName + "." + version + "." + defaultConfigFile);
            reader = new BufferedReader(new InputStreamReader(in));
            String line = null;
            while ((line = reader.readLine()) != null) {
                configString.append(line).append("\r\n");
            }
        }
        catch (Exception e) {
            logger.error((Object)"Init from local file failed.", (Throwable)e);
            return;
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {}
            }
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {}
            }
        }
        this.haConfig = FileConfigManager.parseConfig(configString.toString());
        if (this.haConfig.password != null) {
            for (HAConfig.ServerProperties sp : this.haConfig.groups) {
                sp.password = this.haConfig.password;
            }
        }
        this.router = this.haConfig.ms ? new MSRandomRouter(this.haConfig.groups, this.haConfig.failover) : new RandomRouter(this.haConfig.groups, this.haConfig.failover);
    }

    public Router getRouter() {
        return this.router;
    }

    public void setDefaultConfigKey(String key) {
        this.configKey = key;
    }

    public void destroy() {
    }

    public static HAConfig parseConfig(String configString) {
        Pattern p;
        Matcher m;
        Pattern p_password;
        Matcher m_password;
        Pattern p_pool_size;
        Matcher m_pool_size;
        HAConfig config = new HAConfig();
        Pattern p_timeout = Pattern.compile("timeout=([\\s\\S]+?);");
        Matcher m_timeout = p_timeout.matcher(configString);
        if (m_timeout.find()) {
            String s_timeout = m_timeout.group(1);
            logger.info((Object)("timeout=" + s_timeout));
            try {
                config.timeout = Integer.parseInt(s_timeout.trim());
            }
            catch (Exception ex) {
                logger.error((Object)"timeout\u89e3\u6790\u9519\u8bef:", (Throwable)ex);
            }
        }
        if ((m_pool_size = (p_pool_size = Pattern.compile("pool_size=([\\s\\S]+?);")).matcher(configString)).find()) {
            String s_pool_size = m_pool_size.group(1);
            logger.info((Object)("pool_size=" + s_pool_size));
            try {
                config.pool_size = Integer.parseInt(s_pool_size.trim());
            }
            catch (Exception ex) {
                logger.error((Object)"pool_size\u89e3\u6790\u9519\u8bef:", (Throwable)ex);
            }
        }
        if ((m_password = (p_password = Pattern.compile("password=([\\s\\S]+?);")).matcher(configString)).find()) {
            String s_password = m_password.group(1);
            logger.info((Object)("password=" + s_password));
            try {
                config.password = s_password.trim();
            }
            catch (Exception ex) {
                logger.error((Object)"password\u89e3\u6790\u9519\u8bef:", (Throwable)ex);
            }
        }
        if ((m = (p = Pattern.compile("servers=([\\s\\S]+?);", 2)).matcher(configString)).find()) {
            String s_servers = m.group(1);
            logger.info((Object)("servers=" + s_servers));
            String[] array = s_servers.trim().split(",");
            ArrayList<HAConfig.ServerProperties> servers = new ArrayList<HAConfig.ServerProperties>();
            for (String s : array) {
                HAConfig.ServerProperties sp = new HAConfig.ServerProperties();
                sp.server = new HAConfig.ServerInfo();
                String[] ss = s.split(":");
                if (ss.length >= 2) {
                    sp.server.addr = ss[0];
                    sp.server.port = Integer.parseInt(ss[1]);
                    sp.pool_size = config.pool_size;
                    sp.timeout = config.timeout;
                    sp.password = config.password;
                    if (ss.length == 3) {
                        sp.readWeight = Integer.parseInt(ss[2].toLowerCase().replace("r", "").trim());
                    }
                } else {
                    logger.error((Object)("\u914d\u7f6e\u9519\u8bef:" + s));
                }
                servers.add(sp);
            }
            config.groups = servers;
        } else {
            logger.error((Object)("servers\u914d\u7f6e\u89e3\u6790\u4e0d\u5230:" + configString));
        }
        Pattern p_failover = Pattern.compile("failover=([\\s\\S]+?);", 2);
        Matcher m_failover = p_failover.matcher(configString);
        if (m_failover.find()) {
            try {
                String s_failover = m.group(1);
                config.failover = Boolean.parseBoolean(s_failover.trim());
            }
            catch (Throwable t) {
                logger.error((Object)"failover\u5f00\u5173\u89e3\u6790\u51fa\u9519", t);
            }
        }
        return config;
    }
}

