/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.common.tedis.group;

import com.taobao.common.tedis.Single;
import com.taobao.common.tedis.atomic.TedisSingle;
import com.taobao.common.tedis.binary.RedisCommands;
import com.taobao.common.tedis.config.HAConfig;
import com.taobao.common.tedis.config.Router;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class RandomRouter
implements Router {
    static final Log logger = LogFactory.getLog(RandomRouter.class);
    Random random = new Random();
    private List<HAConfig.ServerProperties> all_props;
    boolean failover;
    volatile Router.RouteData routeData;
    private Router.RouteData allRouteData;
    final Map<String, TedisSingle> singleCache = new HashMap<String, TedisSingle>();
    ExecutorService executor_retry = Executors.newSingleThreadExecutor();
    final Retry retry = new Retry();

    public RandomRouter(List<HAConfig.ServerProperties> props, boolean failover) {
        this.all_props = props;
        this.failover = failover;
        this.routeData = this.createRandomData(props);
        this.allRouteData = this.createRandomData(props);
        this.startRetry();
    }

    private Router.RouteData createRandomData(List<HAConfig.ServerProperties> props) {
        int[] weights = new int[props.size()];
        TedisSingle[] group = new TedisSingle[props.size()];
        int prev = 0;
        for (int i = 0; i < props.size(); ++i) {
            group[i] = this.getAtomic(props.get(i));
            int n = i;
            weights[n] = weights[n] + (prev + props.get((int)i).readWeight);
            prev = weights[i];
        }
        return new Router.RouteData(props, weights, (Single[])group);
    }

    public synchronized void onError(Single single) {
        if (!this.failover) {
            return;
        }
        logger.warn((Object)("onError:" + single));
        HAConfig.ServerProperties prop = single.getProperties();
        List new_props = (List)((ArrayList)this.routeData.props).clone();
        new_props.remove(prop);
        this.routeData = this.createRandomData(new_props);
        this.retry.addRetry(single);
    }

    private synchronized void onReturn(TedisSingle single) {
        logger.warn((Object)("onReturn:" + single));
        HAConfig.ServerProperties prop = single.getProperties();
        List new_props = (List)((ArrayList)this.routeData.props).clone();
        if (!new_props.contains(single.getProperties())) {
            new_props.add(prop);
        }
        this.routeData = this.createRandomData(new_props);
    }

    private Single route(Router.RouteData routeData) throws Exception {
        int max_random = routeData.weights[routeData.weights.length - 1];
        int x = this.random.nextInt(max_random);
        for (int i = 0; i < routeData.weights.length; ++i) {
            if (x >= routeData.weights[i]) continue;
            return routeData.group[i];
        }
        throw new Exception("routeData is empty");
    }

    public Single route() throws Exception {
        return this.route(this.routeData);
    }

    public Router.RouteData getReadData() {
        return this.routeData;
    }

    public Router.RouteData getWriteData() {
        return this.routeData;
    }

    public Router.RouteData getAllRouteData() {
        return this.allRouteData;
    }

    synchronized TedisSingle getAtomic(HAConfig.ServerProperties prop) {
        TedisSingle s = this.singleCache.get(prop.generateKey());
        if (s == null) {
            s = new TedisSingle(prop);
            this.singleCache.put(prop.generateKey(), s);
        }
        return s;
    }

    public Single getAtomic(String key) {
        return (Single)this.singleCache.get(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        this.retry.exit = true;
        Object object = this.retry;
        synchronized (object) {
            this.retry.notify();
        }
        this.executor_retry.shutdownNow();
        object = this.singleCache;
        synchronized (object) {
            for (Map.Entry<String, TedisSingle> entry : this.singleCache.entrySet()) {
                entry.getValue().destroy();
            }
        }
    }

    final void startRetry() {
        this.executor_retry.execute(this.retry);
    }

    public String toString() {
        return "RandomRouter{all_props=" + this.all_props + ", routeData=" + this.routeData + '}';
    }

    final class Retry
    implements Runnable {
        volatile boolean exit = false;
        CopyOnWriteArraySet<Single> set = new CopyOnWriteArraySet();

        Retry() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addRetry(Single single) {
            this.set.add(single);
            Retry retry = this;
            synchronized (retry) {
                this.notify();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (!this.exit) {
                for (Single s : this.set) {
                    logger.warn((Object)("retry:" + s));
                    try {
                        Map<String, TedisSingle> map = RandomRouter.this.singleCache;
                        synchronized (map) {
                            RandomRouter.this.singleCache.remove(s.getProperties().generateKey()).destroy();
                        }
                    }
                    catch (Exception e) {
                        logger.warn((Object)"", (Throwable)e);
                    }
                    TedisSingle ss = null;
                    try {
                        ss = new TedisSingle(s.getProperties());
                        RedisCommands tedis = ss.getTedis();
                        tedis.ping();
                        Map<String, TedisSingle> map = RandomRouter.this.singleCache;
                        synchronized (map) {
                            RandomRouter.this.singleCache.put(ss.getProperties().generateKey(), ss);
                        }
                        RandomRouter.this.onReturn(ss);
                        this.set.remove(s);
                    }
                    catch (Throwable t) {
                        s.getErrorCount().incrementAndGet();
                        if (ss != null) {
                            try {
                                ss.destroy();
                            }
                            catch (Exception e) {
                                // empty catch block
                            }
                        }
                        logger.warn((Object)("retry throwable : " + s), t);
                    }
                }
                try {
                    Retry i$ = this;
                    synchronized (i$) {
                        this.wait(20000L);
                    }
                }
                catch (InterruptedException ex) {
                    logger.warn((Object)"Retry Thread InterruptedException", (Throwable)ex);
                }
            }
        }
    }
}

