/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.common.tedis.group;

import com.juhuasuan.osprey.Message;
import com.juhuasuan.osprey.OspreyManager;
import com.juhuasuan.osprey.OspreyProcessor;
import com.juhuasuan.osprey.Result;
import com.taobao.common.tedis.Group;
import com.taobao.common.tedis.Single;
import com.taobao.common.tedis.TedisConnectionException;
import com.taobao.common.tedis.TedisException;
import com.taobao.common.tedis.binary.RedisCommands;
import com.taobao.common.tedis.config.ConfigManager;
import com.taobao.common.tedis.config.Process;
import com.taobao.common.tedis.config.Router;
import com.taobao.common.tedis.group.DiamondConfigManager;
import com.taobao.common.tedis.group.ReliableAsynMessage;
import com.taobao.common.tedis.monitor.BufferedStatLogWriter;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ReliableAsynTedisGroup
implements Group {
    static final Log logger = LogFactory.getLog(ReliableAsynTedisGroup.class);
    private ConfigManager cm;
    private RedisCommands tedis;
    private String appName;
    private String version;
    private volatile boolean inited = false;
    private OspreyManager ospreyManager;

    public ReliableAsynTedisGroup() {
    }

    public ReliableAsynTedisGroup(String appName, String version) {
        this.appName = appName;
        this.version = version;
    }

    public void init() {
        if (!this.inited) {
            try {
                if (this.cm == null) {
                    this.cm = new DiamondConfigManager(this.appName, this.version);
                }
                this.ospreyManager = new OspreyManager("tedis-" + this.appName + "-" + this.version);
                this.ospreyManager.registerProcessor((OspreyProcessor)new OspreyProcessor<ReliableAsynMessage>(){

                    public Class<ReliableAsynMessage> interest() {
                        return ReliableAsynMessage.class;
                    }

                    public Result process(ReliableAsynMessage message) {
                        Result result = new Result();
                        long time = System.currentTimeMillis();
                        Single single = ReliableAsynTedisGroup.this.cm.getRouter().getAtomic(message.getSingleKey());
                        if (single == null) {
                            result.setSuccess(false);
                            result.setErrorMessage("Current atomic is null");
                            return result;
                        }
                        try {
                            message.getMethod().invoke((Object)single.getTedis(), message.getArgs());
                        }
                        catch (Throwable t) {
                            logger.warn((Object)("write exception:" + single.getProperties()), t);
                            try {
                                ReliableAsynTedisGroup.this.statLog(message.getMethod().getName(), false, time);
                                InvocationTargetException ite = (InvocationTargetException)t;
                                UndeclaredThrowableException ute = (UndeclaredThrowableException)ite.getTargetException();
                                if (ute.getUndeclaredThrowable() instanceof TimeoutException) {
                                    result.setSuccess(false);
                                    result.setErrorMessage("TimeoutException");
                                    result.setRuntimeException((RuntimeException)ute);
                                    return result;
                                }
                                ExecutionException ee = (ExecutionException)ute.getUndeclaredThrowable();
                                InvocationTargetException ite_1 = (InvocationTargetException)ee.getCause();
                                TedisException te = (TedisException)ite_1.getTargetException();
                                if (te.getCause() instanceof TedisConnectionException) {
                                    result.setSuccess(false);
                                    result.setErrorMessage("TedisConnectionException");
                                    result.setRuntimeException((RuntimeException)te);
                                    return result;
                                }
                            }
                            catch (Throwable tt) {
                                logger.warn((Object)"\u89e3\u5305\u5f02\u5e38:", tt);
                            }
                        }
                        return result;
                    }
                });
                this.ospreyManager.init();
                this.tedis = (RedisCommands)Proxy.newProxyInstance(RedisCommands.class.getClassLoader(), new Class[]{RedisCommands.class}, (InvocationHandler)new TedisGroupInvocationHandler());
            }
            catch (Exception e) {
                throw new TedisException("init failed", (Throwable)e);
            }
            this.inited = true;
        }
    }

    public RedisCommands getTedis() {
        if (this.tedis == null) {
            throw new TedisException("please invoke the init method first.");
        }
        return this.tedis;
    }

    private void statLog(String methodName, Boolean flag, long time) {
        BufferedStatLogWriter.add((Object)this.appName, (Object)methodName, (Object)flag, (long)1L, (long)(System.currentTimeMillis() - time));
    }

    public void destroy() {
        Router rr = this.cm.getRouter();
        rr.destroy();
    }

    public String getAppName() {
        return this.appName;
    }

    public void setAppName(String appName) {
        this.appName = appName;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public ConfigManager getConfigManager() {
        return this.cm;
    }

    public void setConfigManager(ConfigManager cm) {
        this.cm = cm;
    }

    public class TedisGroupInvocationHandler
    implements InvocationHandler {
        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            long time = System.currentTimeMillis();
            String name = method.getName();
            Router rr = ReliableAsynTedisGroup.this.cm.getRouter();
            Process annotation = method.getAnnotation(Process.class);
            Throwable exception = null;
            if (annotation.value() == Process.Policy.READ) {
                while (rr.getReadData().props.size() > 0) {
                    Single s = rr.route();
                    try {
                        Object result = method.invoke((Object)s.getTedis(), args);
                        ReliableAsynTedisGroup.this.statLog(name, true, time);
                        return result;
                    }
                    catch (Throwable t) {
                        ReliableAsynTedisGroup.this.statLog(name, false, time);
                        exception = t;
                        logger.warn((Object)("read exception:" + s.getProperties()), t);
                        boolean connectionError = false;
                        try {
                            if (t instanceof InvocationTargetException) {
                                InvocationTargetException ite = (InvocationTargetException)t;
                                UndeclaredThrowableException ute = (UndeclaredThrowableException)ite.getTargetException();
                                if (ute.getUndeclaredThrowable() instanceof TimeoutException) {
                                    connectionError = true;
                                    rr.onError(s);
                                } else {
                                    ExecutionException ee = (ExecutionException)ute.getUndeclaredThrowable();
                                    InvocationTargetException ite_1 = (InvocationTargetException)ee.getCause();
                                    TedisException te = (TedisException)ite_1.getTargetException();
                                    if (te.getCause() instanceof TedisConnectionException) {
                                        connectionError = true;
                                        rr.onError(s);
                                    }
                                }
                            }
                        }
                        catch (Throwable tt) {
                            logger.warn((Object)"\u89e3\u5305\u5f02\u5e38:", tt);
                        }
                        if (connectionError) continue;
                        throw t;
                    }
                }
                throw new Exception("read RouteData is empty," + rr, exception);
            }
            if (annotation.value() == Process.Policy.WRITE) {
                Single[] ss = rr.getWriteData().group;
                if (ss == null || ss.length == 0) {
                    throw new Exception("write RouteData is empty," + rr, exception);
                }
                Object result = null;
                int e = 0;
                List<ReliableAsynMessage> messages = null;
                for (Single s : ss) {
                    try {
                        result = method.invoke((Object)s.getTedis(), args);
                    }
                    catch (Throwable t) {
                        ++e;
                        ReliableAsynTedisGroup.this.statLog(name, false, time);
                        logger.warn((Object)("write exception:" + s.getProperties()), t);
                        exception = t;
                        try {
                            InvocationTargetException ite = (InvocationTargetException)t;
                            UndeclaredThrowableException ute = (UndeclaredThrowableException)ite.getTargetException();
                            if (ute.getUndeclaredThrowable() instanceof TimeoutException) {
                                messages = this.onError(args, name, rr, messages, s);
                                continue;
                            }
                            ExecutionException ee = (ExecutionException)ute.getUndeclaredThrowable();
                            InvocationTargetException ite_1 = (InvocationTargetException)ee.getCause();
                            TedisException te = (TedisException)ite_1.getTargetException();
                            if (!(te.getCause() instanceof TedisConnectionException)) continue;
                            messages = this.onError(args, name, rr, messages, s);
                        }
                        catch (Throwable tt) {
                            logger.warn((Object)"\u89e3\u5305\u5f02\u5e38:", tt);
                        }
                    }
                }
                if (e >= 2) {
                    throw exception;
                }
                if (messages != null && messages.size() > 0) {
                    for (ReliableAsynMessage m : messages) {
                        ReliableAsynTedisGroup.this.ospreyManager.addMessage((Message)m, true);
                    }
                    messages.clear();
                }
                ReliableAsynTedisGroup.this.statLog(name, true, time);
                return result;
            }
            if ("toString".equals(name)) {
                return "";
            }
            if ("hashCode".equals(name)) {
                Single s = rr.route();
                if (s != null) {
                    return s.hashCode();
                }
                return 0;
            }
            if ("equals".equals(name)) {
                Single s = rr.route();
                if (args.length == 1) {
                    return s.equals(args[0]);
                }
            }
            ReliableAsynTedisGroup.this.statLog(name, false, time);
            throw new Exception("method don't match:" + name);
        }

        private List<ReliableAsynMessage> onError(Object[] args, String name, Router rr, List<ReliableAsynMessage> messages, Single s) {
            if (rr.getAtomic(s.getProperties().generateKey()) != null) {
                rr.onError(s);
            }
            if (messages == null) {
                messages = new ArrayList<ReliableAsynMessage>();
            }
            String[] types = new String[args.length];
            for (int n = 0; n < args.length; ++n) {
                types[n] = args[n].getClass().getName();
            }
            messages.add(new ReliableAsynMessage(s.getProperties().generateKey(), args, RedisCommands.class.getName(), name, types));
            return messages;
        }
    }
}

