/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.common.tedis.group;

import com.taobao.common.tedis.Group;
import com.taobao.common.tedis.Single;
import com.taobao.common.tedis.TedisConnectionException;
import com.taobao.common.tedis.TedisException;
import com.taobao.common.tedis.binary.RedisCommands;
import com.taobao.common.tedis.config.ConfigManager;
import com.taobao.common.tedis.config.Process;
import com.taobao.common.tedis.config.Router;
import com.taobao.common.tedis.group.DiamondConfigManager;
import com.taobao.common.tedis.monitor.BufferedStatLogWriter;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TedisGroup
implements Group {
    static final Log logger = LogFactory.getLog(TedisGroup.class);
    private ConfigManager cm;
    private RedisCommands tedis;
    private String appName;
    private String version;
    private volatile boolean inited = false;
    private static final int retryTimes = 3;

    public TedisGroup() {
    }

    public TedisGroup(String appName, String version) {
        this.appName = appName;
        this.version = version;
    }

    public void init() {
        if (!this.inited) {
            if (this.cm == null) {
                this.cm = new DiamondConfigManager(this.appName, this.version);
            }
            try {
                this.tedis = (RedisCommands)Proxy.newProxyInstance(RedisCommands.class.getClassLoader(), new Class[]{RedisCommands.class}, (InvocationHandler)new RedisGroupInvocationHandler());
            }
            catch (Exception e) {
                throw new TedisException("init failed", (Throwable)e);
            }
            this.inited = true;
        }
    }

    public RedisCommands getTedis() {
        if (this.tedis == null) {
            throw new TedisException("please invoke the init method first.");
        }
        return this.tedis;
    }

    private void statLog(String methodName, Boolean flag, long time) {
        BufferedStatLogWriter.add((Object)this.appName, (Object)methodName, (Object)flag, (long)1L, (long)(System.currentTimeMillis() - time));
    }

    public void destroy() {
        Router rr = this.cm.getRouter();
        rr.destroy();
    }

    public String getAppName() {
        return this.appName;
    }

    public void setAppName(String appName) {
        this.appName = appName;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public void setConfigManager(ConfigManager cm) {
        this.cm = cm;
    }

    public ConfigManager getConfigManager() {
        return this.cm;
    }

    public class RedisGroupInvocationHandler
    implements InvocationHandler {
        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            long time = System.currentTimeMillis();
            String name = method.getName();
            Router rr = TedisGroup.this.cm.getRouter();
            Process annotation = method.getAnnotation(Process.class);
            Throwable exception = null;
            if (annotation.value() == Process.Policy.READ) {
                int errorCount = 0;
                while (rr.getReadData().props.size() > 0) {
                    Single s = rr.route();
                    try {
                        Object result = method.invoke((Object)s.getTedis(), args);
                        TedisGroup.this.statLog(name, true, time);
                        return result;
                    }
                    catch (Throwable t) {
                        TedisGroup.this.statLog(name, false, time);
                        if (++errorCount < 3) continue;
                        exception = t;
                        logger.warn((Object)("read exception:" + s.getProperties()), t);
                        boolean connectionError = false;
                        try {
                            if (t instanceof InvocationTargetException) {
                                InvocationTargetException ite = (InvocationTargetException)t;
                                UndeclaredThrowableException ute = (UndeclaredThrowableException)ite.getTargetException();
                                if (ute.getUndeclaredThrowable() instanceof TimeoutException) {
                                    connectionError = true;
                                    rr.onError(s);
                                } else {
                                    ExecutionException ee = (ExecutionException)ute.getUndeclaredThrowable();
                                    InvocationTargetException ite_1 = (InvocationTargetException)ee.getCause();
                                    if (ite_1.getCause() instanceof ClassCastException) {
                                        connectionError = true;
                                        rr.onError(s);
                                    } else {
                                        TedisException te = (TedisException)ite_1.getTargetException();
                                        if (te instanceof TedisConnectionException || te.getCause() instanceof TedisConnectionException) {
                                            connectionError = true;
                                            rr.onError(s);
                                        }
                                    }
                                }
                            }
                        }
                        catch (Throwable tt) {
                            logger.warn((Object)"\u89e3\u5305\u5f02\u5e38:", tt);
                        }
                        if (connectionError) continue;
                        throw t;
                    }
                }
                throw new Exception("Read RouteData is empty," + rr, exception);
            }
            if (annotation.value() == Process.Policy.WRITE) {
                Single[] ss = rr.getWriteData().group;
                if (ss == null || ss.length == 0) {
                    throw new Exception("write RouteData is empty," + rr, exception);
                }
                Object result = null;
                int e = 0;
                block9: for (Single s : ss) {
                    for (int i = 0; i < 3; ++i) {
                        try {
                            result = method.invoke((Object)s.getTedis(), args);
                            continue block9;
                        }
                        catch (Throwable t) {
                            if (i != 2) continue;
                            ++e;
                            TedisGroup.this.statLog(name, false, time);
                            logger.warn((Object)("write exception:" + s.getProperties()), t);
                            exception = t;
                            try {
                                InvocationTargetException ite = (InvocationTargetException)t;
                                UndeclaredThrowableException ute = (UndeclaredThrowableException)ite.getTargetException();
                                if (ute.getUndeclaredThrowable() instanceof TimeoutException) {
                                    rr.onError(s);
                                    continue block9;
                                }
                                ExecutionException ee = (ExecutionException)ute.getUndeclaredThrowable();
                                InvocationTargetException ite_1 = (InvocationTargetException)ee.getCause();
                                if (ite_1.getCause() instanceof ClassCastException) {
                                    rr.onError(s);
                                    continue block9;
                                }
                                TedisException te = (TedisException)ite_1.getTargetException();
                                if (!(te instanceof TedisConnectionException) && !(te.getCause() instanceof TedisConnectionException)) continue block9;
                                rr.onError(s);
                            }
                            catch (Throwable tt) {
                                logger.warn((Object)"\u89e3\u5305\u5f02\u5e38:", tt);
                            }
                            continue block9;
                        }
                    }
                }
                if (e >= 2) {
                    throw exception;
                }
                TedisGroup.this.statLog(name, true, time);
                return result;
            }
            if ("toString".equals(name)) {
                return "";
            }
            if ("hashCode".equals(name)) {
                Single s = rr.route();
                if (s != null) {
                    return s.hashCode();
                }
                return 0;
            }
            if ("equals".equals(name)) {
                Single s = rr.route();
                if (args.length == 1) {
                    return s.equals(args[0]);
                }
            }
            TedisGroup.this.statLog(name, false, time);
            throw new Exception("method don't match:" + name);
        }
    }
}

