/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.common.tedis.group;

import com.taobao.common.tedis.config.ConfigManager;
import com.taobao.common.tedis.config.HAConfig;
import com.taobao.common.tedis.config.Router;
import com.taobao.common.tedis.dislock.ZKClient;
import com.taobao.common.tedis.dislock.ZKException;
import com.taobao.common.tedis.group.MSRandomRouter;
import com.taobao.common.tedis.group.RandomRouter;
import com.taobao.common.tedis.util.ZKUtil;
import java.util.ArrayList;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;

public class ZookeeperConfigManager
implements ConfigManager {
    static Log logger = LogFactory.getLog(ZookeeperConfigManager.class);
    volatile Router router;
    private ZKClient zkClient;
    private String zkAddress;
    private int zkTimeout = 500000;
    int timeout = 3000;
    public volatile HAConfig haConfig;
    Executor e = Executors.newSingleThreadExecutor();
    String appName;
    String version;

    public ZookeeperConfigManager(String appName, String version) {
        this.appName = appName;
        this.version = version;
    }

    public void setZkAddress(String zkAddress) {
        this.zkAddress = zkAddress;
    }

    public void setZkTimeout(int zkTimeout) {
        this.zkTimeout = zkTimeout;
    }

    public void init() throws Exception {
        this.zkClient = new ZKClient(this.zkAddress, this.zkTimeout);
        this.zkClient.init();
        String path = ZKUtil.contact((String)"tedis-config", (String)this.appName);
        path = ZKUtil.contact((String)path, (String)this.version);
        String configString = new String(this.zkClient.getData(ZKUtil.normalize((String)path), (Watcher)new ManagerWatcher()));
        this.haConfig = ZookeeperConfigManager.parseConfig(configString);
        if (this.haConfig.password != null) {
            for (HAConfig.ServerProperties sp : this.haConfig.groups) {
                sp.password = this.haConfig.password;
            }
        }
        this.router = this.haConfig.ms ? new MSRandomRouter(this.haConfig.groups, this.haConfig.failover) : new RandomRouter(this.haConfig.groups, this.haConfig.failover);
    }

    public Router getRouter() {
        return this.router;
    }

    public void destroy() {
    }

    public static HAConfig parseConfig(String configString) {
        Pattern p;
        Matcher m;
        Pattern p_password;
        Matcher m_password;
        Pattern p_pool_size;
        Matcher m_pool_size;
        HAConfig config = new HAConfig();
        Pattern p_timeout = Pattern.compile("timeout=([\\s\\S]+?);");
        Matcher m_timeout = p_timeout.matcher(configString);
        if (m_timeout.find()) {
            String s_timeout = m_timeout.group(1);
            logger.info((Object)("timeout=" + s_timeout));
            try {
                config.timeout = Integer.parseInt(s_timeout.trim());
            }
            catch (Exception ex) {
                logger.error((Object)"timeout\u89e3\u6790\u9519\u8bef:", (Throwable)ex);
            }
        }
        if ((m_pool_size = (p_pool_size = Pattern.compile("pool_size=([\\s\\S]+?);")).matcher(configString)).find()) {
            String s_pool_size = m_pool_size.group(1);
            logger.info((Object)("pool_size=" + s_pool_size));
            try {
                config.pool_size = Integer.parseInt(s_pool_size.trim());
            }
            catch (Exception ex) {
                logger.error((Object)"pool_size\u89e3\u6790\u9519\u8bef:", (Throwable)ex);
            }
        }
        if ((m_password = (p_password = Pattern.compile("password=([\\s\\S]+?);")).matcher(configString)).find()) {
            String s_password = m_password.group(1);
            logger.info((Object)("password=" + s_password));
            try {
                config.password = s_password.trim();
            }
            catch (Exception ex) {
                logger.error((Object)"password\u89e3\u6790\u9519\u8bef:", (Throwable)ex);
            }
        }
        if ((m = (p = Pattern.compile("servers=([\\s\\S]+?);", 2)).matcher(configString)).find()) {
            String s_servers = m.group(1);
            logger.info((Object)("servers=" + s_servers));
            String[] array = s_servers.trim().split(",");
            ArrayList<HAConfig.ServerProperties> servers = new ArrayList<HAConfig.ServerProperties>();
            for (String s : array) {
                HAConfig.ServerProperties sp = new HAConfig.ServerProperties();
                sp.server = new HAConfig.ServerInfo();
                String[] ss = s.split(":");
                if (ss.length >= 2) {
                    sp.server.addr = ss[0];
                    sp.server.port = Integer.parseInt(ss[1]);
                    sp.pool_size = config.pool_size;
                    sp.timeout = config.timeout;
                    sp.password = config.password;
                    if (ss.length == 3) {
                        sp.readWeight = Integer.parseInt(ss[2].toLowerCase().replace("r", "").trim());
                    }
                } else {
                    logger.error((Object)("\u914d\u7f6e\u9519\u8bef:" + s));
                }
                servers.add(sp);
            }
            config.groups = servers;
        } else {
            logger.error((Object)("servers\u914d\u7f6e\u89e3\u6790\u4e0d\u5230:" + configString));
        }
        Pattern p_failover = Pattern.compile("failover=([\\s\\S]+?);", 2);
        Matcher m_failover = p_failover.matcher(configString);
        if (m_failover.find()) {
            try {
                String s_failover = m.group(1);
                config.failover = Boolean.parseBoolean(s_failover.trim());
            }
            catch (Throwable t) {
                logger.error((Object)"failover\u5f00\u5173\u89e3\u6790\u51fa\u9519", t);
            }
        }
        return config;
    }

    public class ManagerWatcher
    implements Watcher {
        public void process(WatchedEvent event) {
            String string = null;
            try {
                string = new String(ZookeeperConfigManager.this.zkClient.getData(event.getPath(), (Watcher)this));
            }
            catch (ZKException e) {
                logger.error((Object)"Get config error.", (Throwable)e);
                return;
            }
            logger.warn((Object)("\u914d\u7f6e\u53d8\u66f4\uff1a" + string));
            if (string != null) {
                ZookeeperConfigManager.this.haConfig = ZookeeperConfigManager.parseConfig(string);
                Router old = ZookeeperConfigManager.this.router;
                ZookeeperConfigManager.this.router = ZookeeperConfigManager.this.haConfig.ms ? new MSRandomRouter(ZookeeperConfigManager.this.haConfig.groups, ZookeeperConfigManager.this.haConfig.failover) : new RandomRouter(ZookeeperConfigManager.this.haConfig.groups, ZookeeperConfigManager.this.haConfig.failover);
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException ex) {
                    logger.warn((Object)"InterruptedException:", (Throwable)ex);
                }
                old.destroy();
            }
        }
    }
}

