/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.shadow.dynamic.host;

import android.app.Application;
import android.content.Intent;
import android.os.IBinder;
import android.os.RemoteException;
import android.text.TextUtils;
import android.util.Log;
import com.tencent.shadow.core.common.InstalledApk;
import com.tencent.shadow.dynamic.host.BasePluginProcessService;
import com.tencent.shadow.dynamic.host.FailedException;
import com.tencent.shadow.dynamic.host.LoaderImplLoader;
import com.tencent.shadow.dynamic.host.MultiDynamicContainer;
import com.tencent.shadow.dynamic.host.MultiLoaderPpsBinder;
import com.tencent.shadow.dynamic.host.MultiLoaderPpsController;
import com.tencent.shadow.dynamic.host.NotFoundException;
import com.tencent.shadow.dynamic.host.PluginLoaderImpl;
import com.tencent.shadow.dynamic.host.PpsStatus;
import com.tencent.shadow.dynamic.host.UuidManager;
import java.io.File;
import java.util.HashMap;

public class MultiLoaderPluginProcessService
extends BasePluginProcessService {
    static final BasePluginProcessService.ActivityHolder sActivityHolder = new BasePluginProcessService.ActivityHolder();
    private final MultiLoaderPpsBinder mPpsControllerBinder = new MultiLoaderPpsBinder(this);
    private HashMap<String, String> mUuidMap = new HashMap();
    private HashMap<String, UuidManager> mUuidManagerMap = new HashMap();
    private HashMap<String, PluginLoaderImpl> mPluginLoaderMap = new HashMap();
    private HashMap<String, Boolean> mRuntimeLoadedMap = new HashMap();

    public static Application.ActivityLifecycleCallbacks getActivityHolder() {
        return sActivityHolder;
    }

    public static MultiLoaderPpsController wrapBinder(IBinder ppsBinder) {
        return new MultiLoaderPpsController(ppsBinder);
    }

    public IBinder onBind(Intent intent) {
        if (this.mLogger.isInfoEnabled()) {
            this.mLogger.info("onBind:" + (Object)((Object)this));
        }
        return this.mPpsControllerBinder;
    }

    synchronized void loadRuntimeForPlugin(String pluginKey, String uuid) throws FailedException {
        String logIdentity = "pluginKey=" + pluginKey + "|uuid=" + uuid;
        if (this.mLogger.isInfoEnabled()) {
            this.mLogger.info("loadRuntimeForPlugin:" + logIdentity);
        }
        UuidManager uuidManager = this.checkUuidManagerNotNull(pluginKey);
        this.addUuidForPlugin(pluginKey, uuid);
        if (this.isRuntimeLoaded(pluginKey)) {
            throw new FailedException(7, "\u91cd\u590d\u8c03\u7528loadRuntime," + logIdentity);
        }
        try {
            InstalledApk installedApk;
            try {
                installedApk = uuidManager.getRuntime(uuid);
            }
            catch (RemoteException e) {
                Log.i((String)"PluginProcessService", (String)"uuidManager.getRuntime new FailedException");
                throw new FailedException(5, e.getMessage());
            }
            catch (NotFoundException e) {
                Log.i((String)"PluginProcessService", (String)"uuidManager.getRuntime new NotFoundException");
                throw new FailedException(3, "pluginKey=" + pluginKey + ", uuid=" + uuid + "\u7684Runtime\u6ca1\u6709\u627e\u5230\u3002cause:" + e.getMessage());
            }
            InstalledApk installedRuntimeApk = new InstalledApk(installedApk.apkFilePath, installedApk.oDexPath, installedApk.libraryPath);
            MultiDynamicContainer.loadContainerApk(pluginKey, installedRuntimeApk);
            this.markRuntimeLoaded(pluginKey);
        }
        catch (RuntimeException e) {
            if (this.mLogger.isErrorEnabled()) {
                this.mLogger.error("loadRuntimeForPlugin\u53d1\u751fRuntimeException", (Throwable)e);
            }
            throw new FailedException(e);
        }
    }

    synchronized void loadPluginLoaderForPlugin(String pluginKey, String uuid) throws FailedException {
        String logIdentity = "pluginKey=" + pluginKey + "|uuid=" + uuid;
        if (this.mLogger.isInfoEnabled()) {
            this.mLogger.info("loadPluginLoader:" + logIdentity);
        }
        UuidManager uuidManager = this.checkUuidManagerNotNull(pluginKey);
        this.addUuidForPlugin(pluginKey, uuid);
        if (this.mPluginLoaderMap.get(pluginKey) != null) {
            throw new FailedException(8, "\u91cd\u590d\u8c03\u7528loadPluginLoader");
        }
        try {
            InstalledApk installedApk;
            try {
                installedApk = uuidManager.getPluginLoader(uuid);
                if (this.mLogger.isInfoEnabled()) {
                    this.mLogger.info("\u53d6\u51fa" + logIdentity + "\u7684Loader apk:" + installedApk.apkFilePath);
                }
            }
            catch (RemoteException e) {
                if (this.mLogger.isErrorEnabled()) {
                    this.mLogger.error("\u83b7\u53d6Loader Apk\u5931\u8d25", (Throwable)e);
                }
                throw new FailedException(5, e.getMessage());
            }
            catch (NotFoundException e) {
                throw new FailedException(3, logIdentity + "\u7684PluginLoader\u6ca1\u6709\u627e\u5230\u3002cause:" + e.getMessage());
            }
            File file = new File(installedApk.apkFilePath);
            if (!file.exists()) {
                throw new FailedException(3, file.getAbsolutePath() + "\u6587\u4ef6\u4e0d\u5b58\u5728");
            }
            PluginLoaderImpl pluginLoader = new LoaderImplLoader().load(installedApk, uuid, this.getApplicationContext());
            pluginLoader.setUuidManager(uuidManager);
            this.mPluginLoaderMap.put(pluginKey, pluginLoader);
        }
        catch (RuntimeException e) {
            if (this.mLogger.isErrorEnabled()) {
                this.mLogger.error("loadPluginLoader\u53d1\u751fRuntimeException", (Throwable)e);
            }
            throw new FailedException(e);
        }
        catch (FailedException e) {
            throw e;
        }
        catch (Exception e) {
            if (this.mLogger.isErrorEnabled()) {
                this.mLogger.error("loadPluginLoader\u53d1\u751fException", (Throwable)e);
            }
            String msg = e.getCause() != null ? e.getCause().getMessage() : e.getMessage();
            throw new FailedException(2, "\u52a0\u8f7d\u52a8\u6001\u5b9e\u73b0\u5931\u8d25 cause\uff1a" + msg);
        }
    }

    synchronized void setUuidManagerForPlugin(String pluginKey, UuidManager uuidManager) {
        if (this.mLogger.isInfoEnabled()) {
            this.mLogger.info("setUuidManagerForPlugin pluginKey=" + pluginKey + ", uuidManager==" + uuidManager);
        }
        this.mUuidManagerMap.put(pluginKey, uuidManager);
        PluginLoaderImpl pluginLoader = this.mPluginLoaderMap.get(pluginKey);
        if (pluginLoader != null) {
            if (this.mLogger.isInfoEnabled()) {
                this.mLogger.info("\u66f4\u65b0PluginLoader\u7684uuidManager");
            }
            pluginLoader.setUuidManager(uuidManager);
        }
    }

    synchronized PpsStatus getPpsStatusForPlugin(String pluginKey) {
        return new PpsStatus(this.mUuidMap.get(pluginKey), this.isRuntimeLoaded(pluginKey), this.mPluginLoaderMap.get(pluginKey) != null, this.mUuidManagerMap.get(pluginKey) != null);
    }

    synchronized IBinder getPluginLoaderForPlugin(String pluginKey) {
        return (IBinder)this.mPluginLoaderMap.get(pluginKey);
    }

    void exit() {
        if (this.mLogger.isInfoEnabled()) {
            this.mLogger.info("exit ");
        }
        sActivityHolder.finishAll();
        System.exit(0);
        try {
            ((Object)((Object)this)).wait();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private UuidManager checkUuidManagerNotNull(String pluginKey) throws FailedException {
        UuidManager uuidManager = this.mUuidManagerMap.get(pluginKey);
        if (uuidManager == null) {
            throw new FailedException(4, "mUuidManager == null");
        }
        return uuidManager;
    }

    private boolean isRuntimeLoaded(String pluginKey) {
        Boolean result = this.mRuntimeLoadedMap.get(pluginKey);
        return result != null && result != false;
    }

    private void markRuntimeLoaded(String pluginKey) {
        this.mRuntimeLoadedMap.put(pluginKey, true);
    }

    private void addUuidForPlugin(String pluginKey, String uuid) throws FailedException {
        String preUuid = this.mUuidMap.get(pluginKey);
        if (preUuid != null && !TextUtils.equals((CharSequence)uuid, (CharSequence)preUuid)) {
            throw new FailedException(6, "Plugin=" + pluginKey + "\u5df2\u8bbe\u7f6e\u8fc7uuid==" + preUuid + ", \u8bd5\u56fe\u8bbe\u7f6euuid==" + uuid);
        }
        if (preUuid == null) {
            this.mUuidMap.put(pluginKey, uuid);
        }
    }
}

