/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.shadow.dynamic.manager;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.Bundle;
import android.os.IBinder;
import android.os.Looper;
import android.os.Parcel;
import com.tencent.shadow.core.common.InstalledApk;
import com.tencent.shadow.core.common.Logger;
import com.tencent.shadow.core.common.LoggerFactory;
import com.tencent.shadow.core.load_parameters.LoadParameters;
import com.tencent.shadow.core.manager.BasePluginManager;
import com.tencent.shadow.core.manager.installplugin.InstalledPlugin;
import com.tencent.shadow.dynamic.host.FailedException;
import com.tencent.shadow.dynamic.host.NotFoundException;
import com.tencent.shadow.dynamic.manager.UuidManagerImpl;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;

public abstract class BaseDynamicPluginManager
extends BasePluginManager
implements UuidManagerImpl {
    private static final Logger mLogger = LoggerFactory.getLogger(BaseDynamicPluginManager.class);
    private AtomicBoolean mServiceConnecting = new AtomicBoolean(false);
    private AtomicReference<CountDownLatch> mConnectCountDownLatch = new AtomicReference();

    public BaseDynamicPluginManager(Context context) {
        super(context);
    }

    public final void bindPluginProcessService(final String serviceName) {
        if (this.mServiceConnecting.get()) {
            if (mLogger.isInfoEnabled()) {
                mLogger.info("pps service connecting");
            }
            return;
        }
        if (mLogger.isInfoEnabled()) {
            mLogger.info("bindPluginProcessService " + serviceName);
        }
        this.mConnectCountDownLatch.set(new CountDownLatch(1));
        this.mServiceConnecting.set(true);
        final CountDownLatch startBindingLatch = new CountDownLatch(1);
        final boolean[] asyncResult = new boolean[1];
        this.mUiHandler.post(new Runnable(){

            @Override
            public void run() {
                boolean binding;
                Intent intent = new Intent();
                intent.setComponent(new ComponentName(BaseDynamicPluginManager.this.mHostContext, serviceName));
                asyncResult[0] = binding = BaseDynamicPluginManager.this.mHostContext.bindService(intent, new ServiceConnection(){

                    public void onServiceConnected(ComponentName name, IBinder service) {
                        if (mLogger.isInfoEnabled()) {
                            mLogger.info("onServiceConnected connectCountDownLatch:" + BaseDynamicPluginManager.this.mConnectCountDownLatch);
                        }
                        BaseDynamicPluginManager.this.mServiceConnecting.set(false);
                        BaseDynamicPluginManager.this.onPluginServiceConnected(name, service);
                        ((CountDownLatch)BaseDynamicPluginManager.this.mConnectCountDownLatch.get()).countDown();
                        if (mLogger.isInfoEnabled()) {
                            mLogger.info("onServiceConnected countDown:" + BaseDynamicPluginManager.this.mConnectCountDownLatch);
                        }
                    }

                    public void onServiceDisconnected(ComponentName name) {
                        if (mLogger.isInfoEnabled()) {
                            mLogger.info("onServiceDisconnected");
                        }
                        BaseDynamicPluginManager.this.mServiceConnecting.set(false);
                        BaseDynamicPluginManager.this.onPluginServiceDisconnected(name);
                    }
                }, 1);
                startBindingLatch.countDown();
            }
        });
        try {
            startBindingLatch.await(10L, TimeUnit.SECONDS);
            if (!asyncResult[0]) {
                throw new IllegalArgumentException("\u65e0\u6cd5\u7ed1\u5b9aPPS:" + serviceName);
            }
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    public final void waitServiceConnected(int timeout, TimeUnit timeUnit) throws TimeoutException {
        if (Looper.myLooper() == Looper.getMainLooper()) {
            throw new RuntimeException("waitServiceConnected \u4e0d\u80fd\u5728\u4e3b\u7ebf\u7a0b\u4e2d\u8c03\u7528");
        }
        try {
            boolean isTimeout;
            if (mLogger.isInfoEnabled()) {
                mLogger.info("waiting service connect connectCountDownLatch:" + this.mConnectCountDownLatch);
            }
            long s = System.currentTimeMillis();
            boolean bl = isTimeout = !this.mConnectCountDownLatch.get().await(timeout, timeUnit);
            if (isTimeout) {
                throw new TimeoutException("\u8fde\u63a5Service\u8d85\u65f6 ,\u7b49\u5f85\u4e86\uff1a" + (System.currentTimeMillis() - s));
            }
            if (mLogger.isInfoEnabled()) {
                mLogger.info("service connected " + (System.currentTimeMillis() - s));
            }
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    protected abstract void onPluginServiceConnected(ComponentName var1, IBinder var2);

    protected abstract void onPluginServiceDisconnected(ComponentName var1);

    public void onCreate(Bundle bundle) {
        if (mLogger.isInfoEnabled()) {
            mLogger.info("onCreate bundle:" + bundle);
        }
    }

    public void onSaveInstanceState(Bundle bundle) {
        if (mLogger.isInfoEnabled()) {
            mLogger.info("onSaveInstanceState:" + bundle);
        }
    }

    public void onDestroy() {
        if (mLogger.isInfoEnabled()) {
            mLogger.info("onDestroy:");
        }
    }

    @Override
    public InstalledApk getPlugin(String uuid, String partKey) throws FailedException, NotFoundException {
        try {
            InstalledPlugin.Part part;
            try {
                part = this.getPluginPartByPartKey(uuid, partKey);
            }
            catch (RuntimeException e) {
                throw new NotFoundException("uuid==" + uuid + "partKey==" + partKey + "\u7684Plugin\u627e\u4e0d\u5230");
            }
            String businessName = part instanceof InstalledPlugin.PluginPart ? ((InstalledPlugin.PluginPart)part).businessName : null;
            String[] dependsOn = part instanceof InstalledPlugin.PluginPart ? ((InstalledPlugin.PluginPart)part).dependsOn : null;
            String[] hostWhiteList = part instanceof InstalledPlugin.PluginPart ? ((InstalledPlugin.PluginPart)part).hostWhiteList : null;
            LoadParameters loadParameters = new LoadParameters(businessName, partKey, dependsOn, hostWhiteList);
            Parcel parcelExtras = Parcel.obtain();
            loadParameters.writeToParcel(parcelExtras, 0);
            byte[] parcelBytes = parcelExtras.marshall();
            parcelExtras.recycle();
            return new InstalledApk(part.pluginFile.getAbsolutePath(), part.oDexDir == null ? null : part.oDexDir.getAbsolutePath(), part.libraryDir == null ? null : part.libraryDir.getAbsolutePath(), parcelBytes);
        }
        catch (RuntimeException e) {
            if (mLogger.isErrorEnabled()) {
                mLogger.error("getPlugin exception:", (Throwable)e);
            }
            throw new FailedException(e);
        }
    }

    private InstalledApk getInstalledPL(String uuid, int type) throws FailedException, NotFoundException {
        try {
            InstalledPlugin.Part part;
            try {
                part = this.getLoaderOrRunTimePart(uuid, type);
            }
            catch (RuntimeException e) {
                if (mLogger.isErrorEnabled()) {
                    mLogger.error("getInstalledPL exception:", (Throwable)e);
                }
                throw new NotFoundException("uuid==" + uuid + " type==" + type + "\u6ca1\u627e\u5230\u3002cause\uff1a" + e.getMessage());
            }
            return new InstalledApk(part.pluginFile.getAbsolutePath(), part.oDexDir == null ? null : part.oDexDir.getAbsolutePath(), part.libraryDir == null ? null : part.libraryDir.getAbsolutePath());
        }
        catch (RuntimeException e) {
            throw new FailedException(e);
        }
    }

    @Override
    public InstalledApk getPluginLoader(String uuid) throws FailedException, NotFoundException {
        return this.getInstalledPL(uuid, 3);
    }

    @Override
    public InstalledApk getRuntime(String uuid) throws FailedException, NotFoundException {
        return this.getInstalledPL(uuid, 4);
    }
}

