/*
 * Copyright (c) 2017-2018 THL A29 Limited, a Tencent company. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.tencentcloudapi.teo.v20220106.models;

import com.tencentcloudapi.common.AbstractModel;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;

public class ExceptConfig extends AbstractModel{

    /**
    * 开关。
1. on 开启
2. off 关闭
注意：此字段可能返回 null，表示取不到有效值。
    */
    @SerializedName("Switch")
    @Expose
    private String Switch;

    /**
    * 例外规则详情。
注意：此字段可能返回 null，表示取不到有效值。
    */
    @SerializedName("UserRules")
    @Expose
    private ExceptUserRule [] UserRules;

    /**
     * Get 开关。
1. on 开启
2. off 关闭
注意：此字段可能返回 null，表示取不到有效值。 
     * @return Switch 开关。
1. on 开启
2. off 关闭
注意：此字段可能返回 null，表示取不到有效值。
     */
    public String getSwitch() {
        return this.Switch;
    }

    /**
     * Set 开关。
1. on 开启
2. off 关闭
注意：此字段可能返回 null，表示取不到有效值。
     * @param Switch 开关。
1. on 开启
2. off 关闭
注意：此字段可能返回 null，表示取不到有效值。
     */
    public void setSwitch(String Switch) {
        this.Switch = Switch;
    }

    /**
     * Get 例外规则详情。
注意：此字段可能返回 null，表示取不到有效值。 
     * @return UserRules 例外规则详情。
注意：此字段可能返回 null，表示取不到有效值。
     */
    public ExceptUserRule [] getUserRules() {
        return this.UserRules;
    }

    /**
     * Set 例外规则详情。
注意：此字段可能返回 null，表示取不到有效值。
     * @param UserRules 例外规则详情。
注意：此字段可能返回 null，表示取不到有效值。
     */
    public void setUserRules(ExceptUserRule [] UserRules) {
        this.UserRules = UserRules;
    }

    public ExceptConfig() {
    }

    /**
     * NOTE: Any ambiguous key set via .set("AnyKey", "value") will be a shallow copy,
     *       and any explicit key, i.e Foo, set via .setFoo("value") will be a deep copy.
     */
    public ExceptConfig(ExceptConfig source) {
        if (source.Switch != null) {
            this.Switch = new String(source.Switch);
        }
        if (source.UserRules != null) {
            this.UserRules = new ExceptUserRule[source.UserRules.length];
            for (int i = 0; i < source.UserRules.length; i++) {
                this.UserRules[i] = new ExceptUserRule(source.UserRules[i]);
            }
        }
    }


    /**
     * Internal implementation, normal users should not use it.
     */
    public void toMap(HashMap<String, String> map, String prefix) {
        this.setParamSimple(map, prefix + "Switch", this.Switch);
        this.setParamArrayObj(map, prefix + "UserRules.", this.UserRules);

    }
}

