/*
 * Decompiled with CFR 0.152.
 */
package com.tetragramato.resttemplate;

import java.io.IOException;
import java.util.Map;
import org.springframework.http.HttpRequest;
import org.springframework.http.client.ClientHttpRequestExecution;
import org.springframework.http.client.ClientHttpRequestInterceptor;
import org.springframework.http.client.ClientHttpResponse;

public class HeadersInterceptor
implements ClientHttpRequestInterceptor {
    private Map<String, String> headers;

    public HeadersInterceptor(Map<String, String> headers) {
        this.headers = headers;
    }

    public ClientHttpResponse intercept(HttpRequest request, byte[] body, ClientHttpRequestExecution execution) throws IOException {
        this.headers.forEach((key, value) -> {
            if (!request.getHeaders().containsKey(key)) {
                request.getHeaders().add(key, value);
            }
        });
        return execution.execute(request, body);
    }
}

