/*
 * Decompiled with CFR 0.152.
 */
package com.to.aboomy.pager2banner;

import android.content.Context;
import android.graphics.Outline;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.view.ViewOutlineProvider;
import android.widget.RelativeLayout;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.LinearSmoothScroller;
import androidx.recyclerview.widget.RecyclerView;
import androidx.viewpager2.widget.CompositePageTransformer;
import androidx.viewpager2.widget.MarginPageTransformer;
import androidx.viewpager2.widget.ViewPager2;
import com.to.aboomy.pager2banner.Indicator;
import java.lang.reflect.Field;

public class Banner
extends RelativeLayout {
    private static final long DEFAULT_AUTO_TIME = 2500L;
    private static final long DEFAULT_PAGER_DURATION = 800L;
    private static final int NORMAL_COUNT = 2;
    private ViewPager2.OnPageChangeCallback changeCallback;
    private CompositePageTransformer compositePageTransformer;
    private BannerAdapterWrapper adapterWrapper;
    private ViewPager2 viewPager2;
    private Indicator indicator;
    private boolean isAutoPlay = true;
    private boolean isBeginPagerChange = true;
    private long autoTurningTime = 2500L;
    private long pagerScrollDuration = 800L;
    private int needPage = 2;
    private int sidePage = this.needPage / 2;
    private int tempPosition;
    private float startX;
    private float startY;
    private float lastX;
    private float lastY;
    private int scaledTouchSlop;
    private final Runnable task = new Runnable(){

        @Override
        public void run() {
            if (Banner.this.isAutoPlay()) {
                Banner.this.tempPosition++;
                if (Banner.this.tempPosition == Banner.this.getRealCount() + Banner.this.sidePage + 1) {
                    Banner.this.isBeginPagerChange = false;
                    Banner.this.viewPager2.setCurrentItem(Banner.this.sidePage, false);
                    Banner.this.post(Banner.this.task);
                } else {
                    Banner.this.isBeginPagerChange = true;
                    Banner.this.viewPager2.setCurrentItem(Banner.this.tempPosition);
                    Banner.this.postDelayed(Banner.this.task, Banner.this.autoTurningTime);
                }
            }
        }
    };
    private RecyclerView.AdapterDataObserver itemDataSetChangeObserver = new RecyclerView.AdapterDataObserver(){

        public final void onItemRangeChanged(int positionStart, int itemCount, @Nullable Object payload) {
            this.onChanged();
        }

        public final void onItemRangeInserted(int positionStart, int itemCount) {
            if (positionStart > 1) {
                this.onChanged();
            }
        }

        public final void onItemRangeMoved(int fromPosition, int toPosition, int itemCount) {
            this.onChanged();
        }

        public void onChanged() {
            Banner.this.startPager(Banner.this.getCurrentPager());
        }
    };

    public Banner(Context context) {
        this(context, null);
    }

    public Banner(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public Banner(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.scaledTouchSlop = ViewConfiguration.get((Context)context).getScaledTouchSlop() >> 1;
        this.initViews(context);
    }

    private void initViews(Context context) {
        this.viewPager2 = new ViewPager2(context);
        this.viewPager2.setLayoutParams(new ViewGroup.LayoutParams(-1, -1));
        this.compositePageTransformer = new CompositePageTransformer();
        this.viewPager2.setPageTransformer((ViewPager2.PageTransformer)this.compositePageTransformer);
        this.viewPager2.registerOnPageChangeCallback((ViewPager2.OnPageChangeCallback)new OnPageChangeCallback());
        this.adapterWrapper = new BannerAdapterWrapper();
        this.viewPager2.setAdapter((RecyclerView.Adapter)this.adapterWrapper);
        this.setOffscreenPageLimit(1);
        this.initViewPagerScrollProxy();
        this.addView((View)this.viewPager2);
    }

    private void startPager(int startPosition) {
        this.tempPosition = startPosition + this.sidePage;
        this.viewPager2.setCurrentItem(this.tempPosition, false);
        this.adapterWrapper.notifyDataSetChanged();
        if (this.indicator != null) {
            this.indicator.initIndicatorCount(this.getRealCount());
        }
        if (this.isAutoPlay()) {
            this.startTurning();
        }
    }

    private int getRealCount() {
        return this.adapterWrapper.getRealCount();
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        if (this.isAutoPlay()) {
            this.startTurning();
        }
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        if (this.isAutoPlay()) {
            this.stopTurning();
        }
    }

    private int toRealPosition(int position) {
        int realPosition = 0;
        if (this.getRealCount() > 1) {
            realPosition = (position - this.sidePage) % this.getRealCount();
        }
        if (realPosition < 0) {
            realPosition += this.getRealCount();
        }
        return realPosition;
    }

    public boolean dispatchTouchEvent(MotionEvent ev) {
        if (this.isAutoPlay() && this.viewPager2.isUserInputEnabled()) {
            int action = ev.getAction();
            if (action == 1 || action == 3 || action == 4) {
                this.startTurning();
            } else if (action == 0) {
                this.stopTurning();
            }
        }
        return super.dispatchTouchEvent(ev);
    }

    public boolean onInterceptTouchEvent(MotionEvent ev) {
        int action = ev.getAction();
        if (action == 0) {
            this.startX = this.lastX = ev.getRawX();
            this.startY = this.lastY = ev.getRawY();
        } else if (action == 2) {
            this.lastX = ev.getRawX();
            this.lastY = ev.getRawY();
            if (this.viewPager2.isUserInputEnabled()) {
                float distanceX = Math.abs(this.lastX - this.startX);
                float distanceY = Math.abs(this.lastY - this.startY);
                boolean disallowIntercept = this.viewPager2.getOrientation() == 0 ? distanceX > (float)this.scaledTouchSlop && distanceX > distanceY : distanceY > (float)this.scaledTouchSlop && distanceY > distanceX;
                this.getParent().requestDisallowInterceptTouchEvent(disallowIntercept);
            }
        } else if (action == 3 || action == 1) {
            return Math.abs(this.lastX - this.startX) > (float)this.scaledTouchSlop || Math.abs(this.lastY - this.startY) > (float)this.scaledTouchSlop;
        }
        return super.onInterceptTouchEvent(ev);
    }

    private void initViewPagerScrollProxy() {
        try {
            RecyclerView recyclerView = (RecyclerView)this.viewPager2.getChildAt(0);
            recyclerView.setOverScrollMode(2);
            ProxyLayoutManger proxyLayoutManger = new ProxyLayoutManger(this.getContext(), this.viewPager2.getOrientation());
            recyclerView.setLayoutManager((RecyclerView.LayoutManager)proxyLayoutManger);
            Field LayoutMangerField = ViewPager2.class.getDeclaredField("mLayoutManager");
            LayoutMangerField.setAccessible(true);
            LayoutMangerField.set(this.viewPager2, (Object)proxyLayoutManger);
            Field pageTransformerAdapterField = ViewPager2.class.getDeclaredField("mPageTransformerAdapter");
            pageTransformerAdapterField.setAccessible(true);
            Object mPageTransformerAdapter = pageTransformerAdapterField.get(this.viewPager2);
            if (mPageTransformerAdapter != null) {
                Class<?> aClass = mPageTransformerAdapter.getClass();
                Field layoutManager = aClass.getDeclaredField("mLayoutManager");
                layoutManager.setAccessible(true);
                layoutManager.set(mPageTransformerAdapter, (Object)proxyLayoutManger);
            }
            Field scrollEventAdapterField = ViewPager2.class.getDeclaredField("mScrollEventAdapter");
            scrollEventAdapterField.setAccessible(true);
            Object mScrollEventAdapter = scrollEventAdapterField.get(this.viewPager2);
            if (mScrollEventAdapter != null) {
                Class<?> aClass = mScrollEventAdapter.getClass();
                Field layoutManager = aClass.getDeclaredField("mLayoutManager");
                layoutManager.setAccessible(true);
                layoutManager.set(mScrollEventAdapter, (Object)proxyLayoutManger);
            }
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
    }

    public Banner setPageMargin(int multiWidth, int pageMargin) {
        return this.setPageMargin(multiWidth, multiWidth, pageMargin);
    }

    public Banner setPageMargin(int tlWidth, int brWidth, int pageMargin) {
        if (pageMargin < 0) {
            pageMargin = 0;
        }
        this.addPageTransformer((ViewPager2.PageTransformer)new MarginPageTransformer(pageMargin));
        RecyclerView recyclerView = (RecyclerView)this.viewPager2.getChildAt(0);
        if (this.viewPager2.getOrientation() == 1) {
            recyclerView.setPadding(this.viewPager2.getPaddingLeft(), tlWidth + Math.abs(pageMargin), this.viewPager2.getPaddingRight(), brWidth + Math.abs(pageMargin));
        } else {
            recyclerView.setPadding(tlWidth + Math.abs(pageMargin), this.viewPager2.getPaddingTop(), brWidth + Math.abs(pageMargin), this.viewPager2.getPaddingBottom());
        }
        recyclerView.setClipToPadding(false);
        this.needPage = 4;
        this.sidePage = 2;
        return this;
    }

    public Banner addPageTransformer(ViewPager2.PageTransformer transformer) {
        this.compositePageTransformer.addTransformer(transformer);
        return this;
    }

    public Banner setAutoTurningTime(long autoTurningTime) {
        this.autoTurningTime = autoTurningTime;
        return this;
    }

    public Banner setOuterPageChangeListener(ViewPager2.OnPageChangeCallback listener) {
        this.changeCallback = listener;
        return this;
    }

    public Banner setOffscreenPageLimit(int limit) {
        this.viewPager2.setOffscreenPageLimit(limit);
        return this;
    }

    public Banner setPagerScrollDuration(long pagerScrollDuration) {
        this.pagerScrollDuration = pagerScrollDuration;
        return this;
    }

    public Banner setOrientation(int orientation) {
        this.viewPager2.setOrientation(orientation);
        return this;
    }

    public Banner addItemDecoration(@NonNull RecyclerView.ItemDecoration decor) {
        this.viewPager2.addItemDecoration(decor);
        return this;
    }

    public Banner addItemDecoration(@NonNull RecyclerView.ItemDecoration decor, int index) {
        this.viewPager2.addItemDecoration(decor, index);
        return this;
    }

    public Banner setAutoPlay(boolean autoPlay) {
        this.isAutoPlay = autoPlay;
        if (this.isAutoPlay && this.getRealCount() > 1) {
            this.startTurning();
        }
        return this;
    }

    public boolean isAutoPlay() {
        return this.isAutoPlay && this.getRealCount() > 1;
    }

    public Banner setIndicator(Indicator indicator) {
        return this.setIndicator(indicator, true);
    }

    public Banner setIndicator(Indicator indicator, boolean attachToRoot) {
        if (this.indicator != null) {
            this.removeView(this.indicator.getView());
        }
        if (indicator != null) {
            this.indicator = indicator;
            if (attachToRoot) {
                this.addView(this.indicator.getView(), (ViewGroup.LayoutParams)this.indicator.getParams());
            }
        }
        return this;
    }

    @RequiresApi(api=21)
    public Banner setRoundCorners(final float radius) {
        this.setOutlineProvider(new ViewOutlineProvider(){

            public void getOutline(View view, Outline outline) {
                outline.setRoundRect(0, 0, view.getWidth(), view.getHeight(), radius);
            }
        });
        this.setClipToOutline(true);
        return this;
    }

    public int getCurrentPager() {
        int position = this.toRealPosition(this.tempPosition);
        return Math.max(position, 0);
    }

    public ViewPager2 getViewPager2() {
        return this.viewPager2;
    }

    public RecyclerView.Adapter getAdapter() {
        return this.adapterWrapper.adapter;
    }

    public void startTurning() {
        this.stopTurning();
        this.postDelayed(this.task, this.autoTurningTime);
    }

    public void stopTurning() {
        this.removeCallbacks(this.task);
    }

    public void setAdapter(@Nullable RecyclerView.Adapter adapter) {
        this.setAdapter(adapter, 0);
    }

    public void setAdapter(@Nullable RecyclerView.Adapter adapter, int startPosition) {
        this.adapterWrapper.registerAdapter(adapter);
        this.startPager(startPosition);
    }

    private class ProxyLayoutManger
    extends LinearLayoutManager {
        ProxyLayoutManger(Context context, int orientation) {
            super(context, orientation, false);
        }

        public void smoothScrollToPosition(RecyclerView recyclerView, RecyclerView.State state, int position) {
            LinearSmoothScroller linearSmoothScroller = new LinearSmoothScroller(recyclerView.getContext()){

                protected int calculateTimeForDeceleration(int dx) {
                    return (int)((double)Banner.this.pagerScrollDuration * 0.6644);
                }
            };
            linearSmoothScroller.setTargetPosition(position);
            this.startSmoothScroll((RecyclerView.SmoothScroller)linearSmoothScroller);
        }
    }

    private class BannerAdapterWrapper
    extends RecyclerView.Adapter<RecyclerView.ViewHolder> {
        private RecyclerView.Adapter adapter;

        private BannerAdapterWrapper() {
        }

        @NonNull
        public RecyclerView.ViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
            return this.adapter.onCreateViewHolder(parent, viewType);
        }

        public void onBindViewHolder(@NonNull RecyclerView.ViewHolder holder, int position) {
            this.adapter.onBindViewHolder(holder, Banner.this.toRealPosition(position));
        }

        public int getItemViewType(int position) {
            return this.adapter.getItemViewType(Banner.this.toRealPosition(position));
        }

        public int getItemCount() {
            return this.getRealCount() > 1 ? this.getRealCount() + Banner.this.needPage : this.getRealCount();
        }

        public long getItemId(int position) {
            return this.adapter.getItemId(Banner.this.toRealPosition(position));
        }

        int getRealCount() {
            return this.adapter == null ? 0 : this.adapter.getItemCount();
        }

        void registerAdapter(RecyclerView.Adapter adapter) {
            if (this.adapter != null) {
                this.adapter.unregisterAdapterDataObserver(Banner.this.itemDataSetChangeObserver);
            }
            this.adapter = adapter;
            if (this.adapter != null) {
                this.adapter.registerAdapterDataObserver(Banner.this.itemDataSetChangeObserver);
            }
        }
    }

    private class OnPageChangeCallback
    extends ViewPager2.OnPageChangeCallback {
        private OnPageChangeCallback() {
        }

        public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
            int realPosition = Banner.this.toRealPosition(position);
            if (Banner.this.changeCallback != null) {
                Banner.this.changeCallback.onPageScrolled(realPosition, positionOffset, positionOffsetPixels);
            }
            if (Banner.this.indicator != null) {
                Banner.this.indicator.onPageScrolled(realPosition, positionOffset, positionOffsetPixels);
            }
        }

        public void onPageSelected(int position) {
            if (Banner.this.getRealCount() > 1) {
                Banner.this.tempPosition = position;
            }
            if (Banner.this.isBeginPagerChange) {
                int realPosition = Banner.this.toRealPosition(position);
                if (Banner.this.changeCallback != null) {
                    Banner.this.changeCallback.onPageSelected(realPosition);
                }
                if (Banner.this.indicator != null) {
                    Banner.this.indicator.onPageSelected(realPosition);
                }
            }
        }

        public void onPageScrollStateChanged(int state) {
            if (state == 1) {
                if (Banner.this.tempPosition == Banner.this.sidePage - 1) {
                    Banner.this.isBeginPagerChange = false;
                    Banner.this.viewPager2.setCurrentItem(Banner.this.getRealCount() + Banner.this.tempPosition, false);
                } else if (Banner.this.tempPosition == Banner.this.getRealCount() + Banner.this.sidePage) {
                    Banner.this.isBeginPagerChange = false;
                    Banner.this.viewPager2.setCurrentItem(Banner.this.sidePage, false);
                } else {
                    Banner.this.isBeginPagerChange = true;
                }
            }
            if (Banner.this.changeCallback != null) {
                Banner.this.changeCallback.onPageScrollStateChanged(state);
            }
            if (Banner.this.indicator != null) {
                Banner.this.indicator.onPageScrollStateChanged(state);
            }
        }
    }
}

