/*
 * Decompiled with CFR 0.152.
 */
package com.to.aboomy.pager2banner;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.RectF;
import android.util.AttributeSet;
import android.view.View;
import android.view.animation.AccelerateInterpolator;
import android.view.animation.DecelerateInterpolator;
import android.view.animation.Interpolator;
import android.widget.RelativeLayout;
import androidx.annotation.ColorInt;
import androidx.annotation.Nullable;
import com.to.aboomy.pager2banner.Indicator;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public class IndicatorView
extends View
implements Indicator {
    private final Interpolator interpolator = new DecelerateInterpolator();
    private Interpolator accelerateInterpolator;
    private Path path;
    private float offset;
    private int selectedPage;
    private int pagerCount;
    private int unColor = -7829368;
    private int selectedColor = -1;
    private final Paint indicatorPaint;
    private final RectF rectF;
    private RelativeLayout.LayoutParams params;
    private int indicatorStyle;
    private float indicatorRadius = this.dip2px(3.5f);
    private float indicatorRatio = 1.0f;
    private float indicatorSelectedRadius = this.dip2px(3.5f);
    private float indicatorSelectedRatio = 1.0f;
    private float indicatorSpacing = this.dip2px(10.0f);

    public IndicatorView(Context context) {
        this(context, null);
    }

    public IndicatorView(Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public IndicatorView(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.rectF = new RectF();
        this.indicatorPaint = new Paint(1);
    }

    @Override
    public void initIndicatorCount(int pagerCount) {
        this.pagerCount = pagerCount;
        this.setVisibility(pagerCount > 1 ? 0 : 8);
        this.requestLayout();
    }

    @Override
    public View getView() {
        return this;
    }

    @Override
    public RelativeLayout.LayoutParams getParams() {
        if (this.params == null) {
            this.params = new RelativeLayout.LayoutParams(-2, -2);
            this.params.addRule(12);
            this.params.addRule(14);
            this.params.bottomMargin = this.dip2px(10.0f);
        }
        return this.params;
    }

    @Override
    public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
        this.selectedPage = position;
        this.offset = positionOffset;
        this.invalidate();
    }

    @Override
    public void onPageSelected(int position) {
    }

    @Override
    public void onPageScrollStateChanged(int state) {
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        this.setMeasuredDimension(this.measureWidth(widthMeasureSpec), this.measureHeight(heightMeasureSpec));
    }

    private int measureWidth(int widthMeasureSpec) {
        int mode = View.MeasureSpec.getMode((int)widthMeasureSpec);
        int width = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int result = 0;
        switch (mode) {
            case 0x40000000: {
                result = width;
                break;
            }
            case -2147483648: 
            case 0: {
                float ratioSelectedRadius = this.getRatioSelectedRadius();
                float ratioRadius = this.getRatioRadius();
                float diameterDistance = Math.max(ratioSelectedRadius, ratioRadius) * 2.0f * (float)this.pagerCount;
                float spacingDistance = (float)(this.pagerCount - 1) * this.indicatorSpacing;
                float al = ratioSelectedRadius - ratioRadius;
                result = (int)(diameterDistance + spacingDistance + al + (float)this.getPaddingLeft() + (float)this.getPaddingRight());
                break;
            }
        }
        return result;
    }

    private int measureHeight(int heightMeasureSpec) {
        int mode = View.MeasureSpec.getMode((int)heightMeasureSpec);
        int height = View.MeasureSpec.getSize((int)heightMeasureSpec);
        int result = 0;
        switch (mode) {
            case 0x40000000: {
                result = height;
                break;
            }
            case -2147483648: 
            case 0: {
                float ratioSelectedRadius = this.getRatioSelectedRadius();
                float ratioRadius = this.getRatioRadius();
                float diameterDistance = Math.max(ratioSelectedRadius, ratioRadius) * 2.0f;
                result = (int)(diameterDistance + (float)this.getPaddingTop() + (float)this.getPaddingBottom());
                break;
            }
        }
        return result;
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        if (this.pagerCount == 0) {
            return;
        }
        float midY = (float)this.getHeight() / 2.0f + 0.5f;
        if (this.indicatorStyle == 0) {
            this.drawCircle(canvas, midY);
        } else if (this.indicatorStyle == 1) {
            this.drawCircleRect(canvas, midY);
        } else if (this.indicatorStyle == 2) {
            this.drawBezier(canvas, midY);
        } else if (this.indicatorStyle == 3) {
            this.drawDash(canvas, midY);
        } else if (this.indicatorStyle == 4) {
            this.drawBigCircle(canvas, midY);
        }
    }

    private void drawCircle(Canvas canvas, float midY) {
        this.drawPagerCountCircle(canvas, midY);
        float indicatorStartX = this.indicatorStartX(this.selectedPage);
        float nextIndicatorStartX = this.indicatorStartX((this.selectedPage + 1) % this.pagerCount);
        float ratioRadius = this.getRatioSelectedRadius();
        float left = indicatorStartX - ratioRadius;
        float right = indicatorStartX + ratioRadius;
        float nextLeft = nextIndicatorStartX - ratioRadius;
        float nextRight = nextIndicatorStartX + ratioRadius;
        float leftX = left + (nextLeft - left) * this.interpolatedOffset();
        float rightX = right + (nextRight - right) * this.interpolatedOffset();
        this.rectF.set(leftX, midY - this.indicatorSelectedRadius, rightX, midY + this.indicatorSelectedRadius);
        this.indicatorPaint.setColor(this.selectedColor);
        canvas.drawRoundRect(this.rectF, this.indicatorSelectedRadius, this.indicatorSelectedRadius, this.indicatorPaint);
    }

    private void drawCircleRect(Canvas canvas, float midY) {
        float rightX;
        float leftX;
        this.drawPagerCountCircle(canvas, midY);
        float indicatorStartX = this.indicatorStartX(this.selectedPage);
        float ratioRadius = this.getRatioSelectedRadius();
        float left = indicatorStartX - ratioRadius;
        float right = indicatorStartX + ratioRadius;
        float offset = this.interpolatedOffset();
        float distance = this.indicatorSpacing + Math.max(this.getRatioRadius(), ratioRadius) * 2.0f;
        if ((this.selectedPage + 1) % this.pagerCount == 0) {
            leftX = left + Math.max((distance *= (float)(-this.selectedPage)) * offset * 2.0f, distance);
            rightX = right + Math.min(distance * (offset - 0.5f) * 2.0f, 0.0f);
        } else {
            leftX = left + Math.max(distance * (offset - 0.5f) * 2.0f, 0.0f);
            rightX = right + Math.min(distance * offset * 2.0f, distance);
        }
        this.rectF.set(leftX, midY - this.indicatorSelectedRadius, rightX, midY + this.indicatorSelectedRadius);
        this.indicatorPaint.setColor(this.selectedColor);
        canvas.drawRoundRect(this.rectF, this.indicatorSelectedRadius, this.indicatorSelectedRadius, this.indicatorPaint);
    }

    private void drawBezier(Canvas canvas, float midY) {
        this.drawPagerCountCircle(canvas, midY);
        if (this.path == null) {
            this.path = new Path();
        }
        if (this.accelerateInterpolator == null) {
            this.accelerateInterpolator = new AccelerateInterpolator();
        }
        float indicatorStartX = this.indicatorStartX(this.selectedPage);
        float nextIndicatorStartX = this.indicatorStartX((this.selectedPage + 1) % this.pagerCount);
        float leftX = indicatorStartX + (nextIndicatorStartX - indicatorStartX) * this.accelerateInterpolator.getInterpolation(this.offset);
        float rightX = indicatorStartX + (nextIndicatorStartX - indicatorStartX) * this.interpolatedOffset();
        float ratioSelectedRadius = this.getRatioSelectedRadius();
        float minRadius = this.indicatorSelectedRadius * 0.57f;
        float minRatioRadius = minRadius * this.indicatorSelectedRatio;
        float leftRadius = ratioSelectedRadius + (minRatioRadius - ratioSelectedRadius) * this.interpolatedOffset();
        float rightRadius = minRatioRadius + (ratioSelectedRadius - minRatioRadius) * this.accelerateInterpolator.getInterpolation(this.offset);
        float leftTopOrBottomOffset = (this.indicatorSelectedRadius - minRadius) * this.interpolatedOffset();
        float rightTopOrBottomOffset = (this.indicatorSelectedRadius - minRadius) * this.accelerateInterpolator.getInterpolation(this.offset);
        this.indicatorPaint.setColor(this.selectedColor);
        this.rectF.set(leftX - leftRadius, midY - this.indicatorSelectedRadius + leftTopOrBottomOffset, leftX + leftRadius, midY + this.indicatorSelectedRadius - leftTopOrBottomOffset);
        canvas.drawRoundRect(this.rectF, leftRadius, leftRadius, this.indicatorPaint);
        this.rectF.set(rightX - rightRadius, midY - minRadius - rightTopOrBottomOffset, rightX + rightRadius, midY + minRadius + rightTopOrBottomOffset);
        canvas.drawRoundRect(this.rectF, rightRadius, rightRadius, this.indicatorPaint);
        this.path.reset();
        this.path.moveTo(rightX, midY);
        this.path.lineTo(rightX, midY - minRadius - rightTopOrBottomOffset);
        this.path.quadTo(rightX + (leftX - rightX) / 2.0f, midY, leftX, midY - this.indicatorSelectedRadius + leftTopOrBottomOffset);
        this.path.lineTo(leftX, midY + this.indicatorSelectedRadius - leftTopOrBottomOffset);
        this.path.quadTo(rightX + (leftX - rightX) / 2.0f, midY, rightX, midY + minRadius + rightTopOrBottomOffset);
        this.path.close();
        canvas.drawPath(this.path, this.indicatorPaint);
    }

    private void drawDash(Canvas canvas, float midY) {
        float offset = this.interpolatedOffset();
        float ratioSelectedRadius = this.getRatioSelectedRadius();
        float ratioIndicatorRadius = this.getRatioRadius();
        float distance = ratioSelectedRadius - ratioIndicatorRadius;
        float distanceOffset = distance * offset;
        int nextPage = (this.selectedPage + 1) % this.pagerCount;
        boolean isNextFirst = nextPage == 0;
        this.indicatorPaint.setColor(this.unColor);
        for (int i = 0; i < this.pagerCount; ++i) {
            float startCx = this.indicatorStartX(i);
            if (isNextFirst) {
                startCx += distanceOffset;
            }
            float left = startCx - ratioIndicatorRadius;
            float top = midY - this.indicatorRadius;
            float right = startCx + ratioIndicatorRadius;
            float bottom = midY + this.indicatorRadius;
            if (this.selectedPage + 1 <= i) {
                this.rectF.set(left + distance, top, right + distance, bottom);
            } else {
                this.rectF.set(left, top, right, bottom);
            }
            canvas.drawRoundRect(this.rectF, this.indicatorRadius, this.indicatorRadius, this.indicatorPaint);
        }
        this.indicatorPaint.setColor(this.selectedColor);
        if (offset < 0.99f) {
            float leftX = this.indicatorStartX(this.selectedPage) - ratioSelectedRadius;
            if (isNextFirst) {
                leftX += distanceOffset;
            }
            float rightX = leftX + ratioSelectedRadius * 2.0f + distance - distanceOffset;
            this.rectF.set(leftX, midY - this.indicatorSelectedRadius, rightX, midY + this.indicatorSelectedRadius);
            canvas.drawRoundRect(this.rectF, this.indicatorSelectedRadius, this.indicatorSelectedRadius, this.indicatorPaint);
        }
        if (offset > 0.1f) {
            float nextRightX = this.indicatorStartX(nextPage) + ratioSelectedRadius + (isNextFirst ? distanceOffset : distance);
            float nextLeftX = nextRightX - ratioSelectedRadius * 2.0f - distanceOffset;
            this.rectF.set(nextLeftX, midY - this.indicatorSelectedRadius, nextRightX, midY + this.indicatorSelectedRadius);
            canvas.drawRoundRect(this.rectF, this.indicatorSelectedRadius, this.indicatorSelectedRadius, this.indicatorPaint);
        }
    }

    private void drawBigCircle(Canvas canvas, float midY) {
        float bottom;
        float right;
        float left;
        float top;
        this.drawPagerCountCircle(canvas, midY);
        float offset = this.interpolatedOffset();
        float indicatorStartX = this.indicatorStartX(this.selectedPage);
        float nextIndicatorStartX = this.indicatorStartX((this.selectedPage + 1) % this.pagerCount);
        float ratioRadius = this.getRatioRadius();
        float maxRadius = this.indicatorSelectedRadius;
        float maxRatioRadius = maxRadius * this.indicatorSelectedRatio;
        float leftRadius = maxRatioRadius - (maxRatioRadius - ratioRadius) * offset;
        float rightRadius = ratioRadius + (maxRatioRadius - ratioRadius) * offset;
        float topOrBottomOffset = (maxRadius - this.indicatorRadius) * offset;
        this.indicatorPaint.setColor(this.selectedColor);
        if (offset < 0.99f) {
            top = midY - maxRadius + topOrBottomOffset;
            left = indicatorStartX - leftRadius;
            right = indicatorStartX + leftRadius;
            bottom = midY + maxRadius - topOrBottomOffset;
            this.rectF.set(left, top, right, bottom);
            canvas.drawRoundRect(this.rectF, leftRadius, leftRadius, this.indicatorPaint);
        }
        if (offset > 0.1f) {
            top = midY - this.indicatorRadius - topOrBottomOffset;
            left = nextIndicatorStartX - rightRadius;
            right = nextIndicatorStartX + rightRadius;
            bottom = midY + this.indicatorRadius + topOrBottomOffset;
            this.rectF.set(left, top, right, bottom);
            canvas.drawRoundRect(this.rectF, rightRadius, rightRadius, this.indicatorPaint);
        }
    }

    private void drawPagerCountCircle(Canvas canvas, float midY) {
        this.indicatorPaint.setColor(this.unColor);
        for (int i = 0; i < this.pagerCount; ++i) {
            float startCx = this.indicatorStartX(i);
            float ratioIndicatorRadius = this.getRatioRadius();
            float left = startCx - ratioIndicatorRadius;
            float top = midY - this.indicatorRadius;
            float right = startCx + ratioIndicatorRadius;
            float bottom = midY + this.indicatorRadius;
            this.rectF.set(left, top, right, bottom);
            canvas.drawRoundRect(this.rectF, this.indicatorRadius, this.indicatorRadius, this.indicatorPaint);
        }
    }

    private float indicatorStartX(int index) {
        float ratioRadius = this.getRatioRadius();
        float ratioSelectedRadius = this.getRatioSelectedRadius();
        float ratioIndicatorRadius = Math.max(ratioRadius, ratioSelectedRadius);
        float centerSpacing = ratioIndicatorRadius * 2.0f + this.indicatorSpacing;
        float centerX = ratioIndicatorRadius + (float)this.getPaddingLeft() + centerSpacing * (float)index;
        return centerX + (this.indicatorStyle == 3 ? 0.0f : (ratioIndicatorRadius - ratioRadius) / 2.0f);
    }

    private float getRatioRadius() {
        return this.indicatorRadius * this.indicatorRatio;
    }

    private float getRatioSelectedRadius() {
        return this.indicatorSelectedRadius * this.indicatorSelectedRatio;
    }

    private float interpolatedOffset() {
        return this.interpolator.getInterpolation(this.offset);
    }

    private int dip2px(float dp) {
        return (int)(dp * this.getContext().getResources().getDisplayMetrics().density);
    }

    public IndicatorView setIndicatorRadius(float indicatorRadius) {
        int indicatorRadiusDp = this.dip2px(indicatorRadius);
        if (this.indicatorRadius == this.indicatorSelectedRadius) {
            this.indicatorSelectedRadius = indicatorRadiusDp;
        }
        this.indicatorRadius = indicatorRadiusDp;
        return this;
    }

    public IndicatorView setIndicatorRatio(float indicatorRatio) {
        if (this.indicatorRatio == this.indicatorSelectedRatio) {
            this.indicatorSelectedRatio = indicatorRatio;
        }
        this.indicatorRatio = indicatorRatio;
        return this;
    }

    public IndicatorView setIndicatorSelectedRadius(float indicatorSelectedRadius) {
        this.indicatorSelectedRadius = this.dip2px(indicatorSelectedRadius);
        return this;
    }

    public IndicatorView setIndicatorSelectedRatio(float indicatorSelectedRatio) {
        this.indicatorSelectedRatio = indicatorSelectedRatio;
        return this;
    }

    public IndicatorView setIndicatorSpacing(float indicatorSpacing) {
        this.indicatorSpacing = this.dip2px(indicatorSpacing);
        return this;
    }

    public IndicatorView setIndicatorStyle(int indicatorStyle) {
        this.indicatorStyle = indicatorStyle;
        return this;
    }

    public IndicatorView setIndicatorColor(@ColorInt int indicatorColor) {
        this.unColor = indicatorColor;
        return this;
    }

    public IndicatorView setIndicatorSelectorColor(@ColorInt int indicatorSelectorColor) {
        this.selectedColor = indicatorSelectorColor;
        return this;
    }

    public IndicatorView setParams(RelativeLayout.LayoutParams params) {
        this.params = params;
        return this;
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface IndicatorStyle {
        public static final int INDICATOR_CIRCLE = 0;
        public static final int INDICATOR_CIRCLE_RECT = 1;
        public static final int INDICATOR_BEZIER = 2;
        public static final int INDICATOR_DASH = 3;
        public static final int INDICATOR_BIG_CIRCLE = 4;
    }
}

