/*
 * Decompiled with CFR 0.152.
 */
package anet.channel.statist;

import anet.channel.AwcnConfig;
import anet.channel.fulltrace.a;
import anet.channel.fulltrace.b;
import anet.channel.statist.AlarmObject;
import anet.channel.statist.Dimension;
import anet.channel.statist.Measure;
import anet.channel.statist.Monitor;
import anet.channel.statist.StatObject;
import anet.channel.util.ALog;
import org.json.JSONObject;

@Monitor(module="networkPrefer", monitorPoint="session")
public class SessionStatistic
extends StatObject {
    @Dimension
    public String host;
    @Dimension
    public String ip;
    @Dimension
    public int port;
    @Dimension
    public String closeReason;
    @Dimension
    public long retryTimes;
    @Dimension
    public long errorCode;
    @Dimension
    public int sdkv;
    @Dimension(name="protocolType")
    public String conntype;
    @Dimension
    public int isProxy = 0;
    @Dimension
    public String isTunnel;
    @Dimension
    public long isKL;
    @Dimension
    public int ret;
    @Dimension
    public boolean isBackground;
    @Dimension
    public String netType;
    @Dimension
    public int ipRefer = 0;
    @Dimension
    public int ipType = 1;
    @Dimension
    public JSONObject extra = null;
    @Dimension
    public String scid;
    @Dimension
    public String dcid;
    @Dimension
    public int congControlKind;
    @Dimension
    public int xqc0RttStatus;
    @Dimension
    public String xqcConnEnv;
    @Measure(name="connTime", max=15000.0)
    public long connectionTime;
    @Measure(max=15000.0)
    public long authTime;
    @Measure(max=15000.0)
    public long sslTime;
    @Measure(max=86400.0)
    public long liveTime = 0L;
    @Measure(constantValue=1.0)
    public long requestCount = 1L;
    @Measure
    public long cfRCount;
    @Measure(constantValue=0.0)
    public long stdRCount = 1L;
    @Measure
    public long ppkgCount;
    @Measure
    public long pRate;
    @Measure
    public long ackTime;
    @Measure
    public int lastPingInterval;
    @Measure(max=15000.0)
    public long sslCalTime;
    @Measure
    public long sendSizeCount;
    @Measure
    public long recvSizeCount;
    @Measure
    public long inceptCount;
    @Measure
    public double retransmissionRate;
    @Measure
    public double lossRate;
    @Measure
    public int tlpCount;
    @Measure
    public int rtoCount;
    @Measure
    public long srtt;
    public boolean isCommitted = false;
    public static int maxRetryTime;

    public SessionStatistic(anet.channel.entity.a a2) {
        if (a2 == null) {
            return;
        }
        this.ip = a2.a();
        this.port = a2.b();
        if (a2.a != null) {
            this.ipRefer = a2.a.getIpSource();
            this.ipType = a2.a.getIpType();
        }
        this.pRate = a2.g();
        this.conntype = a2.c().toString();
        this.retryTimes = a2.b;
        maxRetryTime = a2.c;
        String string = null;
        b b2 = a.a().getSceneInfo();
        if (b2 != null) {
            string = b2.f;
        }
        boolean bl = anet.channel.e.a.b();
        boolean bl2 = AwcnConfig.isHttp3OrangeEnable();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(bl2).append("_").append(bl).append("_").append(string);
        this.xqcConnEnv = stringBuilder.toString();
    }

    @Override
    public boolean beforeCommit() {
        if (this.ret == 0 && (this.retryTimes != (long)maxRetryTime || this.errorCode == -2613L || this.errorCode == -2601L)) {
            if (ALog.isPrintLog(1)) {
                ALog.d("SessionStat no need commit", null, "retry:", this.retryTimes, "maxRetryTime", maxRetryTime, "errorCode", this.errorCode);
            }
            return false;
        }
        if (this.isCommitted) {
            return false;
        }
        this.isCommitted = true;
        return true;
    }

    public AlarmObject getAlarmObject() {
        AlarmObject alarmObject = new AlarmObject();
        alarmObject.module = "networkPrefer";
        alarmObject.modulePoint = "connect_succ_rate";
        boolean bl = alarmObject.isSuccess = this.ret != 0;
        if (alarmObject.isSuccess) {
            alarmObject.arg = this.closeReason;
        } else {
            alarmObject.errorCode = String.valueOf(this.errorCode);
        }
        return alarmObject;
    }
}

