/*
 * Decompiled with CFR 0.152.
 */
package anet.channel.strategy.dispatch;

import android.content.Context;
import anet.channel.strategy.dispatch.IAmdcSign;
import anet.channel.util.ALog;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class AmdcRuntimeInfo {
    private static final String TAG = "awcn.AmdcRuntimeInfo";
    private static volatile Context context;
    private static volatile int amdcLimitLevel;
    private static volatile long amdcLimitTime;
    private static IAmdcSign iSign;
    public static volatile double latitude;
    public static volatile double longitude;
    public static volatile String appChannel;
    public static volatile String appName;
    public static volatile String appVersion;
    private static Map<String, String> params;
    private static volatile boolean forceHttps;
    private static volatile boolean timeoutRetryEnable;

    public static void updateAmdcLimit(int n2, int n3) {
        ALog.i(TAG, "set amdc limit", null, "level", n2, "time", n3);
        if (n2 < 0 || n2 > 3) {
            return;
        }
        amdcLimitLevel = n2;
        amdcLimitTime = System.currentTimeMillis() + (long)n3 * 1000L;
    }

    public static int getAmdcLimitLevel() {
        if (amdcLimitLevel > 0 && System.currentTimeMillis() - amdcLimitTime > 0L) {
            amdcLimitTime = 0L;
            amdcLimitLevel = 0;
        }
        return amdcLimitLevel;
    }

    public static void setContext(Context context) {
        AmdcRuntimeInfo.context = context;
    }

    public static Context getContext() {
        return context;
    }

    public static void setSign(IAmdcSign iAmdcSign) {
        iSign = iAmdcSign;
    }

    public static IAmdcSign getSign() {
        return iSign;
    }

    public static void updateLocation(double d2, double d3) {
        latitude = d2;
        longitude = d3;
    }

    public static void setAppInfo(String string, String string2, String string3) {
        appName = string;
        appVersion = string2;
        appChannel = string3;
    }

    public static synchronized void setParam(String string, String string2) {
        if (params == null) {
            params = new HashMap<String, String>();
        }
        params.put(string, string2);
    }

    public static synchronized Map<String, String> getParams() {
        if (params == null) {
            return Collections.EMPTY_MAP;
        }
        return new HashMap<String, String>(params);
    }

    public static boolean isForceHttps() {
        return forceHttps;
    }

    public static void setForceHttps(boolean bl) {
        forceHttps = bl;
    }

    public static void setTimeoutRetryEnable(boolean bl) {
        timeoutRetryEnable = bl;
    }

    public static boolean isTimeoutRetryEnable() {
        return timeoutRetryEnable;
    }

    static {
        amdcLimitLevel = 0;
        amdcLimitTime = 0L;
        iSign = null;
        latitude = 0.0;
        longitude = 0.0;
        appChannel = null;
        appName = null;
        appVersion = null;
        params = null;
        forceHttps = false;
        timeoutRetryEnable = true;
    }
}

