/*
 * Decompiled with CFR 0.152.
 */
package anet.channel.util;

import java.security.MessageDigest;

public class StringUtils {
    private static final char[] DIGITS_LOWER = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    public static String concatString(String string, String string2) {
        return new StringBuilder(string.length() + string2.length()).append(string).append(string2).toString();
    }

    public static String concatString(String string, String string2, String string3) {
        return new StringBuilder(string.length() + string2.length() + string3.length()).append(string).append(string2).append(string3).toString();
    }

    public static String buildKey(String string, String string2) {
        return StringUtils.concatString(string, "://", string2);
    }

    public static String simplifyString(String string, int n2) {
        if (string.length() <= n2) {
            return string;
        }
        return StringUtils.concatString(string.substring(0, n2), "......");
    }

    public static String stringNull2Empty(String string) {
        return string == null ? "" : string;
    }

    public static String md5ToHex(String string) {
        if (string == null) {
            return null;
        }
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            return StringUtils.bytesToHexString(messageDigest.digest(string.getBytes("utf-8")));
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static String bytesToHexString(byte[] byArray, char[] cArray) {
        int n2 = byArray.length;
        char[] cArray2 = new char[n2 << 1];
        int n3 = 0;
        for (int i2 = 0; i2 < n2; ++i2) {
            cArray2[n3++] = cArray[(0xF0 & byArray[i2]) >>> 4];
            cArray2[n3++] = cArray[0xF & byArray[i2]];
        }
        return new String(cArray2);
    }

    public static String bytesToHexString(byte[] byArray) {
        if (byArray == null) {
            return "";
        }
        return StringUtils.bytesToHexString(byArray, DIGITS_LOWER);
    }

    public static boolean isNotBlank(String string) {
        return !StringUtils.isBlank(string);
    }

    public static boolean isBlank(String string) {
        int n2;
        if (string == null || (n2 = string.length()) == 0) {
            return true;
        }
        for (int i2 = 0; i2 < n2; ++i2) {
            if (Character.isWhitespace(string.charAt(i2))) continue;
            return false;
        }
        return true;
    }

    public static boolean isStringEqual(String string, String string2) {
        return string == null && string2 == null || string != null && string.equals(string2);
    }
}

