/*
 * Decompiled with CFR 0.152.
 */
package anetwork.channel.unified;

import android.content.Context;
import android.os.RemoteException;
import android.text.TextUtils;
import anet.channel.bytes.ByteArray;
import anet.channel.bytes.a;
import anet.channel.util.ALog;
import anet.channel.util.StringUtils;
import anetwork.channel.aidl.Connection;
import anetwork.channel.aidl.NetworkResponse;
import anetwork.channel.aidl.ParcelableFuture;
import anetwork.channel.aidl.ParcelableInputStream;
import anetwork.channel.aidl.ParcelableNetworkListener;
import anetwork.channel.aidl.ParcelableRequest;
import anetwork.channel.aidl.RemoteNetwork;
import anetwork.channel.aidl.adapter.ConnectionDelegate;
import anetwork.channel.aidl.adapter.ParcelableFutureResponse;
import anetwork.channel.aidl.adapter.ParcelableNetworkListenerWrapper;
import anetwork.channel.entity.c;
import anetwork.channel.entity.g;
import anetwork.channel.http.NetworkSdkSetting;
import anetwork.channel.unified.k;
import java.io.ByteArrayOutputStream;

public abstract class UnifiedNetworkDelegate
extends RemoteNetwork.Stub {
    public static final int HTTP = 0;
    public static final int DEGRADABLE = 1;
    private static final String TAG = "anet.UnifiedNetworkDelegate";
    protected int type = 1;

    protected UnifiedNetworkDelegate(Context context) {
        NetworkSdkSetting.init(context);
    }

    @Override
    public NetworkResponse syncSend(ParcelableRequest parcelableRequest) throws RemoteException {
        return this.convertToSync(parcelableRequest);
    }

    @Override
    public ParcelableFuture asyncSend(ParcelableRequest parcelableRequest, ParcelableNetworkListener parcelableNetworkListener) throws RemoteException {
        try {
            return this.asyncSend(new g(parcelableRequest, this.type, false), parcelableNetworkListener);
        }
        catch (Exception exception) {
            ALog.e(TAG, "asyncSend failed", parcelableRequest.seqNo, exception, new Object[0]);
            throw new RemoteException(exception.getMessage());
        }
    }

    private ParcelableFuture asyncSend(g g2, ParcelableNetworkListener parcelableNetworkListener) throws RemoteException {
        k k2 = new k(g2, new c(parcelableNetworkListener, g2));
        return new ParcelableFutureResponse(k2.a());
    }

    @Override
    public Connection getConnection(ParcelableRequest parcelableRequest) throws RemoteException {
        try {
            g g2 = new g(parcelableRequest, this.type, true);
            ConnectionDelegate connectionDelegate = new ConnectionDelegate(g2);
            ParcelableNetworkListenerWrapper parcelableNetworkListenerWrapper = new ParcelableNetworkListenerWrapper(connectionDelegate, null, null);
            connectionDelegate.setFuture(this.asyncSend(g2, (ParcelableNetworkListener)parcelableNetworkListenerWrapper));
            return connectionDelegate;
        }
        catch (Exception exception) {
            ALog.e(TAG, "asyncSend failed", parcelableRequest.seqNo, exception, new Object[0]);
            throw new RemoteException(exception.getMessage());
        }
    }

    private NetworkResponse convertToSync(ParcelableRequest parcelableRequest) {
        NetworkResponse networkResponse = new NetworkResponse();
        try {
            int n2;
            ConnectionDelegate connectionDelegate = (ConnectionDelegate)this.getConnection(parcelableRequest);
            ParcelableInputStream parcelableInputStream = connectionDelegate.getInputStream();
            if (parcelableInputStream != null) {
                int n3;
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(parcelableInputStream.length() > 0 ? parcelableInputStream.length() : 1024);
                ByteArray byteArray = a.a.a.a(2048);
                while ((n3 = parcelableInputStream.read(byteArray.getBuffer())) != -1) {
                    byteArrayOutputStream.write(byteArray.getBuffer(), 0, n3);
                }
                networkResponse.setBytedata(byteArrayOutputStream.toByteArray());
            }
            if ((n2 = connectionDelegate.getStatusCode()) < 0) {
                networkResponse.setBytedata(null);
            } else {
                networkResponse.setConnHeadFields(connectionDelegate.getConnHeadFields());
            }
            networkResponse.setStatusCode(n2);
            networkResponse.setStatisticData(connectionDelegate.getStatisticData());
            return networkResponse;
        }
        catch (RemoteException remoteException) {
            networkResponse.setStatusCode(-103);
            String string = remoteException.getMessage();
            if (!TextUtils.isEmpty((CharSequence)string)) {
                networkResponse.setDesc(StringUtils.concatString(networkResponse.getDesc(), "|", string));
            }
        }
        catch (Exception exception) {
            networkResponse.setStatusCode(-201);
        }
        return networkResponse;
    }
}

