/*
 * Decompiled with CFR 0.152.
 */
package com.umeng.commonsdk.vchannel;

import android.content.Context;
import android.text.TextUtils;
import com.umeng.commonsdk.debug.UMRTLog;
import com.umeng.commonsdk.framework.UMEnvelopeBuild;
import com.umeng.commonsdk.framework.UMFrUtils;
import com.umeng.commonsdk.framework.UMWorkDispatch;
import com.umeng.commonsdk.internal.crash.UMCrashManager;
import com.umeng.commonsdk.vchannel.a;
import com.umeng.commonsdk.vchannel.b;
import java.util.Map;
import org.json.JSONObject;

public class Sender {
    private static long lastTriggerTime = 0L;
    private static long INTERVAL_THRESHOLD = 500L;
    private static Map<String, String> customHeader = null;
    public static final String VCHANNEL_VERSION = "1.0.0";

    public static void setCustomHeader(Map<String, String> map) {
        if (map != null) {
            customHeader = map;
        }
    }

    public static void onEvent(Context context, String string, Map<String, Object> map) {
        if (context == null) {
            UMRTLog.e("MobclickRT", "--->>> Sender: onEvent: context is null.");
            return;
        }
        if (TextUtils.isEmpty((CharSequence)string)) {
            UMRTLog.e("MobclickRT", "--->>> Sender: onEvent: eventID is null or an empty string.");
            return;
        }
        if (map == null) {
            UMRTLog.e("MobclickRT", "--->>> Sender: onEvent: map is null.");
            return;
        }
        if (!UMFrUtils.isOnline(context)) {
            UMRTLog.e("MobclickRT", "--->>> Sender: onEvent: Network unavailable.");
            return;
        }
        long l2 = System.currentTimeMillis();
        if (l2 - lastTriggerTime < INTERVAL_THRESHOLD) {
            UMRTLog.e("MobclickRT", "--->>> Sender: onEvent: The interval between events is less than 500 milliseconds.");
            return;
        }
        b b2 = new b(context);
        b2.a(string);
        b2.a(System.currentTimeMillis());
        b2.a(map);
        try {
            UMWorkDispatch.sendEvent(context, 32779, com.umeng.commonsdk.internal.b.a(context).a(), b2);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        lastTriggerTime = System.currentTimeMillis();
    }

    public static void handleEvent(Context context, b b2) {
        if (context == null) {
            UMRTLog.e("MobclickRT", "--->>> Sender:handleEvent: context is null.");
            return;
        }
        try {
            JSONObject jSONObject = new JSONObject();
            try {
                jSONObject.put("v_sdk_v", (Object)VCHANNEL_VERSION);
                if (customHeader != null && customHeader.size() > 0) {
                    for (String string : customHeader.keySet()) {
                        jSONObject.put(string, (Object)customHeader.get(string));
                    }
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            JSONObject jSONObject2 = new JSONObject();
            jSONObject2.put("analytics", (Object)b2.d());
            UMEnvelopeBuild.buildEnvelopeWithExtHeader(context, jSONObject, jSONObject2, a.c, "v", VCHANNEL_VERSION);
        }
        catch (Throwable throwable) {
            UMCrashManager.reportCrash(context, throwable);
        }
    }
}

