/*
 * Decompiled with CFR 0.152.
 */
package com.umeng.socialize.handler;

import android.content.Context;
import android.content.SharedPreferences;
import android.os.Bundle;
import android.text.TextUtils;
import java.util.HashMap;
import java.util.Map;

public class WeixinPreferences {
    private static final String KEY_ACCESS_TOKEN = "access_token";
    private static final String KEY_REFRESH_TOKEN = "refresh_token";
    private static final String KEY_REFRESH_TOKEN_TTL = "rt_expires_in";
    private static final String KEY_OPENID = "openid";
    private static final String KEY_UID = "unionid";
    private static final String KEY_EXPIRES_IN = "expires_in";
    private final SharedPreferences sharedPreferences;
    private String mUID;
    private String mOpenid;
    private String mAccessToken;
    private long mAccessTokenTTL;
    private String mRefreshToken;
    private long mRefreshTokenTTL;

    public WeixinPreferences(Context context, String name) {
        this.sharedPreferences = context.getSharedPreferences(name + "full", 0);
        this.mUID = this.sharedPreferences.getString(KEY_UID, null);
        this.mOpenid = this.sharedPreferences.getString(KEY_OPENID, null);
        this.mAccessToken = this.sharedPreferences.getString(KEY_ACCESS_TOKEN, null);
        this.mAccessTokenTTL = this.sharedPreferences.getLong(KEY_EXPIRES_IN, 0L);
        this.mRefreshToken = this.sharedPreferences.getString(KEY_REFRESH_TOKEN, null);
        this.mRefreshTokenTTL = this.sharedPreferences.getLong(KEY_REFRESH_TOKEN_TTL, 0L);
    }

    public WeixinPreferences setBundle(Bundle bundle) {
        long refreshTTL;
        if (TextUtils.isEmpty((CharSequence)bundle.getString(KEY_UID))) {
            this.mUID = bundle.getString(KEY_UID);
        }
        if (TextUtils.isEmpty((CharSequence)bundle.getString(KEY_OPENID))) {
            this.mOpenid = bundle.getString(KEY_OPENID);
        }
        this.mAccessToken = bundle.getString(KEY_ACCESS_TOKEN);
        this.mRefreshToken = bundle.getString(KEY_REFRESH_TOKEN);
        String expiresIn = bundle.getString(KEY_EXPIRES_IN);
        if (!TextUtils.isEmpty((CharSequence)expiresIn)) {
            this.mAccessTokenTTL = Long.valueOf(expiresIn) * 1000L + System.currentTimeMillis();
        }
        if ((refreshTTL = bundle.getLong("refresh_token_expires")) != 0L) {
            this.mRefreshTokenTTL = refreshTTL * 1000L + System.currentTimeMillis();
        }
        this.commit();
        return this;
    }

    public String getUID() {
        return this.mUID;
    }

    public String getOpenid() {
        return this.mOpenid;
    }

    public String getRefreshToken() {
        return this.mRefreshToken;
    }

    public Map<String, String> getMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(KEY_ACCESS_TOKEN, this.mAccessToken);
        map.put(KEY_UID, this.mUID);
        map.put(KEY_OPENID, this.mOpenid);
        map.put(KEY_REFRESH_TOKEN, this.mRefreshToken);
        map.put(KEY_EXPIRES_IN, String.valueOf(this.mAccessTokenTTL));
        return map;
    }

    public boolean isAccessTokenAvailable() {
        boolean isNull = TextUtils.isEmpty((CharSequence)this.mAccessToken);
        boolean isExpired = this.mAccessTokenTTL - System.currentTimeMillis() <= 0L;
        return !isNull && !isExpired;
    }

    public String getAccessToken() {
        return this.mAccessToken;
    }

    public long getAccessTokenTTL() {
        return this.mAccessTokenTTL;
    }

    public boolean isAuthValid() {
        boolean isNull = TextUtils.isEmpty((CharSequence)this.mRefreshToken);
        boolean isExpired = this.mRefreshTokenTTL - System.currentTimeMillis() <= 0L;
        return !isNull && !isExpired;
    }

    public boolean isAuth() {
        boolean isNull = TextUtils.isEmpty((CharSequence)this.getAccessToken());
        return !isNull;
    }

    public void delete() {
        this.sharedPreferences.edit().clear().commit();
        this.mAccessToken = "";
        this.mRefreshToken = "";
    }

    public void commit() {
        this.sharedPreferences.edit().putString(KEY_UID, this.mUID).putString(KEY_OPENID, this.mOpenid).putString(KEY_ACCESS_TOKEN, this.mAccessToken).putString(KEY_REFRESH_TOKEN, this.mRefreshToken).putLong(KEY_REFRESH_TOKEN_TTL, this.mRefreshTokenTTL).putLong(KEY_EXPIRES_IN, this.mAccessTokenTTL).commit();
    }
}

