/*
 * Decompiled with CFR 0.152.
 */
package com.unfbx.chatgpt.entity.moderations;

import com.unfbx.chatgpt.exception.BaseException;
import com.unfbx.chatgpt.exception.CommonError;
import java.io.Serializable;
import java.util.List;
import java.util.Objects;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Moderation
implements Serializable {
    private static final Logger log = LoggerFactory.getLogger(Moderation.class);
    @NonNull
    private List<String> input;
    private String model;

    public void setInput(List<String> input) {
        if (Objects.isNull(input) || input.size() == 0) {
            log.error("input\u4e0d\u80fd\u4e3a\u7a7a");
            throw new BaseException(CommonError.PARAM_ERROR);
        }
        this.input = input;
    }

    public void setModel(Model model) {
        if (Objects.isNull((Object)model)) {
            model = Model.TEXT_MODERATION_LATEST;
        }
        this.model = model.getName();
    }

    private static String $default$model() {
        return Model.TEXT_MODERATION_LATEST.getName();
    }

    public static ModerationBuilder builder() {
        return new ModerationBuilder();
    }

    @NonNull
    public List<String> getInput() {
        return this.input;
    }

    public String getModel() {
        return this.model;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Moderation)) {
            return false;
        }
        Moderation other = (Moderation)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<String> this$input = this.getInput();
        List<String> other$input = other.getInput();
        if (this$input == null ? other$input != null : !((Object)this$input).equals(other$input)) {
            return false;
        }
        String this$model = this.getModel();
        String other$model = other.getModel();
        return !(this$model == null ? other$model != null : !this$model.equals(other$model));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Moderation;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<String> $input = this.getInput();
        result = result * 59 + ($input == null ? 43 : ((Object)$input).hashCode());
        String $model = this.getModel();
        result = result * 59 + ($model == null ? 43 : $model.hashCode());
        return result;
    }

    public String toString() {
        return "Moderation(input=" + this.getInput() + ", model=" + this.getModel() + ")";
    }

    public Moderation() {
        this.model = Moderation.$default$model();
    }

    public Moderation(@NonNull List<String> input, String model) {
        if (input == null) {
            throw new NullPointerException("input is marked non-null but is null");
        }
        this.input = input;
        this.model = model;
    }

    public static class ModerationBuilder {
        private List<String> input;
        private boolean model$set;
        private String model$value;

        ModerationBuilder() {
        }

        public ModerationBuilder input(@NonNull List<String> input) {
            if (input == null) {
                throw new NullPointerException("input is marked non-null but is null");
            }
            this.input = input;
            return this;
        }

        public ModerationBuilder model(String model) {
            this.model$value = model;
            this.model$set = true;
            return this;
        }

        public Moderation build() {
            String model$value = this.model$value;
            if (!this.model$set) {
                model$value = Moderation.$default$model();
            }
            return new Moderation(this.input, model$value);
        }

        public String toString() {
            return "Moderation.ModerationBuilder(input=" + this.input + ", model$value=" + this.model$value + ")";
        }
    }

    public static enum Model {
        TEXT_MODERATION_STABLE("text-moderation-stable"),
        TEXT_MODERATION_LATEST("text-moderation-latest");

        private final String name;

        public String getName() {
            return this.name;
        }

        private Model(String name) {
            this.name = name;
        }
    }
}

