/*
 * Decompiled with CFR 0.152.
 */
package com.ironsource.adapters.unityads;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.os.Build;
import android.text.TextUtils;
import android.widget.FrameLayout;
import com.ironsource.adapters.unityads.UnityAdsBannerListener;
import com.ironsource.adapters.unityads.UnityAdsInterstitialListener;
import com.ironsource.adapters.unityads.UnityAdsRewardedVideoListener;
import com.ironsource.environment.ContextProvider;
import com.ironsource.mediationsdk.AbstractAdapter;
import com.ironsource.mediationsdk.AdapterUtils;
import com.ironsource.mediationsdk.INetworkInitCallbackListener;
import com.ironsource.mediationsdk.ISBannerSize;
import com.ironsource.mediationsdk.IntegrationData;
import com.ironsource.mediationsdk.IronSource;
import com.ironsource.mediationsdk.IronSourceBannerLayout;
import com.ironsource.mediationsdk.LoadWhileShowSupportState;
import com.ironsource.mediationsdk.logger.IronLog;
import com.ironsource.mediationsdk.logger.IronSourceError;
import com.ironsource.mediationsdk.metadata.MetaData;
import com.ironsource.mediationsdk.metadata.MetaDataUtils;
import com.ironsource.mediationsdk.sdk.BannerSmashListener;
import com.ironsource.mediationsdk.sdk.InterstitialSmashListener;
import com.ironsource.mediationsdk.sdk.RewardedVideoSmashListener;
import com.ironsource.mediationsdk.utils.ErrorBuilder;
import com.ironsource.mediationsdk.utils.IronSourceUtils;
import com.unity3d.ads.IUnityAdsInitializationListener;
import com.unity3d.ads.IUnityAdsLoadListener;
import com.unity3d.ads.IUnityAdsShowListener;
import com.unity3d.ads.IUnityAdsTokenListener;
import com.unity3d.ads.UnityAds;
import com.unity3d.ads.UnityAdsLoadOptions;
import com.unity3d.ads.UnityAdsShowOptions;
import com.unity3d.ads.metadata.MediationMetaData;
import com.unity3d.ads.metadata.MetaData;
import com.unity3d.ads.metadata.PlayerMetaData;
import com.unity3d.services.banners.BannerView;
import com.unity3d.services.banners.UnityBannerSize;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.NotNull;
import org.json.JSONObject;

class UnityAdsAdapter
extends AbstractAdapter
implements IUnityAdsInitializationListener,
INetworkInitCallbackListener {
    private final String MEDIATION_NAME = "ironSource";
    private final String ADAPTER_VERSION_KEY = "adapter_version";
    private static final String VERSION = "4.3.48";
    private static final String GitHash = "99b6578";
    private final String GAME_ID = "sourceId";
    private final String PLACEMENT_ID = "zoneId";
    private ConcurrentHashMap<String, RewardedVideoSmashListener> mPlacementIdToRewardedVideoSmashListener;
    private ConcurrentHashMap<String, UnityAdsRewardedVideoListener> mPlacementIdToRewardedVideoListener;
    private ConcurrentHashMap<String, String> mRewardedVideoPlacementIdToLoadedAdObjectId;
    protected ConcurrentHashMap<String, Boolean> mRewardedVideoAdsAvailability;
    private CopyOnWriteArraySet<String> mRewardedVideoPlacementIdsForInitCallbacks;
    private ConcurrentHashMap<String, InterstitialSmashListener> mPlacementIdToInterstitialSmashListener;
    private ConcurrentHashMap<String, UnityAdsInterstitialListener> mPlacementIdToInterstitialListener;
    private ConcurrentHashMap<String, String> mInterstitialPlacementIdToLoadedAdObjectId;
    protected ConcurrentHashMap<String, Boolean> mInterstitialAdsAvailability;
    private ConcurrentHashMap<String, BannerSmashListener> mPlacementIdToBannerSmashListener;
    private ConcurrentHashMap<String, UnityAdsBannerListener> mPlacementIdToBannerListener;
    private ConcurrentHashMap<String, BannerView> mPlacementIdToBannerAd;
    private static HashSet<INetworkInitCallbackListener> initCallbackListeners = new HashSet();
    private static InitState mInitState = InitState.INIT_STATE_NONE;
    private static AtomicBoolean mWasInitCalled = new AtomicBoolean(false);
    private final String CONSENT_GDPR = "gdpr.consent";
    private final String CONSENT_CCPA = "privacy.consent";
    private final String UNITYADS_COPPA = "user.nonBehavioral";
    private final String UNITYADS_METADATA_COPPA_KEY = "unityads_coppa";
    private final String GAME_DESIGNATION = "mode";
    private final String MIXED_AUDIENCE = "mixed";
    private final String ADS_GATEWAY_ENABLED = "adsGatewayV2";
    private static String asyncToken = null;
    private final String LWS_SUPPORT_STATE = "isSupportedLWS";
    private final Object mUnityAdsStorageLock = new Object();
    private boolean isAdsGateway = false;

    public static UnityAdsAdapter startAdapter(String providerName) {
        return new UnityAdsAdapter(providerName);
    }

    private UnityAdsAdapter(String providerName) {
        super(providerName);
        IronLog.INTERNAL.verbose();
        this.mPlacementIdToRewardedVideoSmashListener = new ConcurrentHashMap();
        this.mPlacementIdToRewardedVideoListener = new ConcurrentHashMap();
        this.mRewardedVideoPlacementIdToLoadedAdObjectId = new ConcurrentHashMap();
        this.mRewardedVideoAdsAvailability = new ConcurrentHashMap();
        this.mRewardedVideoPlacementIdsForInitCallbacks = new CopyOnWriteArraySet();
        this.mPlacementIdToInterstitialSmashListener = new ConcurrentHashMap();
        this.mPlacementIdToInterstitialListener = new ConcurrentHashMap();
        this.mInterstitialPlacementIdToLoadedAdObjectId = new ConcurrentHashMap();
        this.mInterstitialAdsAvailability = new ConcurrentHashMap();
        this.mPlacementIdToBannerSmashListener = new ConcurrentHashMap();
        this.mPlacementIdToBannerListener = new ConcurrentHashMap();
        this.mPlacementIdToBannerAd = new ConcurrentHashMap();
    }

    public static IntegrationData getIntegrationData(Context context) {
        return new IntegrationData("UnityAds", VERSION);
    }

    public String getVersion() {
        return VERSION;
    }

    public String getCoreSDKVersion() {
        return UnityAds.getVersion();
    }

    public static String getAdapterSDKVersion() {
        return UnityAds.getVersion();
    }

    public boolean isUsingActivityBeforeImpression(@NotNull IronSource.AD_UNIT adUnit) {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initSDK(String gameId, JSONObject config) {
        if (mInitState == InitState.INIT_STATE_NONE || mInitState == InitState.INIT_STATE_IN_PROGRESS) {
            initCallbackListeners.add(this);
        }
        if (mWasInitCalled.compareAndSet(false, true)) {
            IronLog.ADAPTER_API.verbose();
            mInitState = InitState.INIT_STATE_IN_PROGRESS;
            Object object = this.mUnityAdsStorageLock;
            synchronized (object) {
                MediationMetaData mediationMetaData = new MediationMetaData(ContextProvider.getInstance().getApplicationContext());
                mediationMetaData.setName("ironSource");
                mediationMetaData.setVersion(IronSourceUtils.getSDKVersion());
                mediationMetaData.set("adapter_version", (Object)VERSION);
                mediationMetaData.commit();
            }
            this.isAdsGateway = config.optBoolean("adsGatewayV2", false);
            this.setUnityAdsMetaData("adsGatewayV2", this.isAdsGateway);
            UnityAds.setDebugMode((boolean)this.isAdaptersDebugEnabled());
            UnityAds.initialize((Context)ContextProvider.getInstance().getApplicationContext(), (String)gameId, (boolean)false, (IUnityAdsInitializationListener)this);
            if (!this.isAdsGateway) {
                this.getAsyncToken();
            }
        }
    }

    public void onNetworkInitCallbackSuccess() {
        IronLog.ADAPTER_CALLBACK.verbose();
        for (String string : this.mPlacementIdToRewardedVideoSmashListener.keySet()) {
            RewardedVideoSmashListener listener = this.mPlacementIdToRewardedVideoSmashListener.get(string);
            if (this.mRewardedVideoPlacementIdsForInitCallbacks.contains(string)) {
                listener.onRewardedVideoInitSuccess();
                continue;
            }
            this.loadRewardedVideoInternal(string, null, listener);
        }
        for (InterstitialSmashListener interstitialSmashListener : this.mPlacementIdToInterstitialSmashListener.values()) {
            interstitialSmashListener.onInterstitialInitSuccess();
        }
        for (BannerSmashListener bannerSmashListener : this.mPlacementIdToBannerSmashListener.values()) {
            bannerSmashListener.onBannerInitSuccess();
        }
    }

    public void onNetworkInitCallbackFailed(String error) {
        IronLog.ADAPTER_CALLBACK.verbose();
        for (String string : this.mPlacementIdToRewardedVideoSmashListener.keySet()) {
            RewardedVideoSmashListener listener = this.mPlacementIdToRewardedVideoSmashListener.get(string);
            if (this.mRewardedVideoPlacementIdsForInitCallbacks.contains(string)) {
                listener.onRewardedVideoInitFailed(ErrorBuilder.buildInitFailedError((String)error, (String)"Rewarded Video"));
                continue;
            }
            listener.onRewardedVideoAvailabilityChanged(false);
        }
        for (InterstitialSmashListener interstitialSmashListener : this.mPlacementIdToInterstitialSmashListener.values()) {
            interstitialSmashListener.onInterstitialInitFailed(ErrorBuilder.buildInitFailedError((String)error, (String)"Interstitial"));
        }
        for (BannerSmashListener bannerSmashListener : this.mPlacementIdToBannerSmashListener.values()) {
            bannerSmashListener.onBannerInitFailed(ErrorBuilder.buildInitFailedError((String)error, (String)"Banner"));
        }
    }

    public void onInitializationComplete() {
        IronLog.ADAPTER_CALLBACK.verbose();
        mInitState = InitState.INIT_STATE_SUCCESS;
        for (INetworkInitCallbackListener adapter : initCallbackListeners) {
            adapter.onNetworkInitCallbackSuccess();
        }
        initCallbackListeners.clear();
    }

    public void onInitializationFailed(UnityAds.UnityAdsInitializationError error, String message) {
        IronLog.ADAPTER_CALLBACK.verbose();
        mInitState = InitState.INIT_STATE_FAILED;
        String initError = this.getUnityAdsInitializationErrorCode(error) + message;
        for (INetworkInitCallbackListener adapter : initCallbackListeners) {
            adapter.onNetworkInitCallbackFailed(initError);
        }
        initCallbackListeners.clear();
    }

    public void initRewardedVideoWithCallback(String appKey, String userId, JSONObject config, RewardedVideoSmashListener listener) {
        String gameId = config.optString("sourceId");
        String placementId = config.optString("zoneId");
        if (!this.isOSSupported()) {
            IronSourceError error = this.errorForUnsupportedAdapter("Rewarded Video");
            IronLog.INTERNAL.error(error.getErrorMessage());
            listener.onRewardedVideoInitFailed(error);
            return;
        }
        if (TextUtils.isEmpty((CharSequence)gameId)) {
            IronLog.INTERNAL.error("missing params = sourceId");
            listener.onRewardedVideoInitFailed(ErrorBuilder.buildInitFailedError((String)"Missing params - sourceId", (String)"Rewarded Video"));
            return;
        }
        if (TextUtils.isEmpty((CharSequence)placementId)) {
            IronLog.INTERNAL.error("missing params = zoneId");
            listener.onRewardedVideoInitFailed(ErrorBuilder.buildInitFailedError((String)"Missing params - zoneId", (String)"Rewarded Video"));
            return;
        }
        IronLog.ADAPTER_API.verbose("gameId = " + gameId + ", placementId = " + placementId);
        this.mPlacementIdToRewardedVideoSmashListener.put(placementId, listener);
        this.mRewardedVideoPlacementIdsForInitCallbacks.add(placementId);
        switch (mInitState) {
            case INIT_STATE_NONE: 
            case INIT_STATE_IN_PROGRESS: {
                this.initSDK(gameId, config);
                break;
            }
            case INIT_STATE_SUCCESS: {
                listener.onRewardedVideoInitSuccess();
                break;
            }
            case INIT_STATE_FAILED: {
                listener.onRewardedVideoInitFailed(ErrorBuilder.buildInitFailedError((String)"UnityAds SDK init failed", (String)"Rewarded Video"));
            }
        }
    }

    public void initAndLoadRewardedVideo(String appKey, String userId, JSONObject config, JSONObject adData, RewardedVideoSmashListener listener) {
        String gameId = config.optString("sourceId");
        String placementId = config.optString("zoneId");
        if (!this.isOSSupported()) {
            IronSourceError error = this.errorForUnsupportedAdapter("Rewarded Video");
            IronLog.INTERNAL.error(error.getErrorMessage());
            listener.onRewardedVideoAvailabilityChanged(false);
            return;
        }
        if (TextUtils.isEmpty((CharSequence)gameId)) {
            IronLog.INTERNAL.error("missing params = sourceId");
            listener.onRewardedVideoAvailabilityChanged(false);
            return;
        }
        if (TextUtils.isEmpty((CharSequence)placementId)) {
            IronLog.INTERNAL.error("missing params = zoneId");
            listener.onRewardedVideoAvailabilityChanged(false);
            return;
        }
        IronLog.ADAPTER_API.verbose("gameId = " + gameId + ", placementId = " + placementId);
        this.mPlacementIdToRewardedVideoSmashListener.put(placementId, listener);
        switch (mInitState) {
            case INIT_STATE_NONE: 
            case INIT_STATE_IN_PROGRESS: {
                this.initSDK(gameId, config);
                break;
            }
            case INIT_STATE_SUCCESS: {
                this.loadRewardedVideoInternal(placementId, null, listener);
                break;
            }
            case INIT_STATE_FAILED: {
                listener.onRewardedVideoAvailabilityChanged(false);
            }
        }
    }

    public void loadRewardedVideoForBidding(JSONObject config, JSONObject adData, String serverData, RewardedVideoSmashListener listener) {
        String placementId = config.optString("zoneId");
        IronLog.ADAPTER_API.verbose("placementId = " + placementId);
        this.loadRewardedVideoInternal(placementId, serverData, listener);
    }

    public void loadRewardedVideo(JSONObject config, JSONObject adData, RewardedVideoSmashListener listener) {
        String placementId = config.optString("zoneId");
        IronLog.ADAPTER_API.verbose("placementId = " + placementId);
        this.loadRewardedVideoInternal(placementId, null, listener);
    }

    private void loadRewardedVideoInternal(String placementId, String serverData, RewardedVideoSmashListener listener) {
        IronLog.ADAPTER_API.verbose("placementId = " + placementId);
        this.mRewardedVideoAdsAvailability.put(placementId, false);
        UnityAdsRewardedVideoListener rewardedVideoAdListener = new UnityAdsRewardedVideoListener(this, listener, placementId);
        this.mPlacementIdToRewardedVideoListener.put(placementId, rewardedVideoAdListener);
        UnityAdsLoadOptions loadOptions = new UnityAdsLoadOptions();
        String mObjectId = UUID.randomUUID().toString();
        loadOptions.setObjectId(mObjectId);
        if (!TextUtils.isEmpty((CharSequence)serverData)) {
            loadOptions.setAdMarkup(serverData);
        }
        this.mRewardedVideoPlacementIdToLoadedAdObjectId.put(placementId, mObjectId);
        UnityAds.load((String)placementId, (UnityAdsLoadOptions)loadOptions, (IUnityAdsLoadListener)rewardedVideoAdListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void showRewardedVideo(JSONObject config, RewardedVideoSmashListener listener) {
        String placementId = config.optString("zoneId");
        IronLog.ADAPTER_API.verbose("placementId = " + placementId);
        if (this.isRewardedVideoAvailable(config)) {
            this.mRewardedVideoAdsAvailability.put(placementId, false);
            if (!TextUtils.isEmpty((CharSequence)this.getDynamicUserId())) {
                Object object = this.mUnityAdsStorageLock;
                synchronized (object) {
                    PlayerMetaData playerMetaData = new PlayerMetaData(ContextProvider.getInstance().getApplicationContext());
                    playerMetaData.setServerId(this.getDynamicUserId());
                    playerMetaData.commit();
                }
            }
            UnityAdsRewardedVideoListener rewardedVideoAdListener = this.mPlacementIdToRewardedVideoListener.get(placementId);
            String objectId = this.mRewardedVideoPlacementIdToLoadedAdObjectId.get(placementId);
            UnityAdsShowOptions showOptions = new UnityAdsShowOptions();
            showOptions.setObjectId(objectId);
            UnityAds.show((Activity)ContextProvider.getInstance().getCurrentActiveActivity(), (String)placementId, (UnityAdsShowOptions)showOptions, (IUnityAdsShowListener)rewardedVideoAdListener);
        } else {
            listener.onRewardedVideoAdShowFailed(ErrorBuilder.buildNoAdsToShowError((String)"Rewarded Video"));
        }
    }

    public boolean isRewardedVideoAvailable(JSONObject config) {
        if (!this.isOSSupported()) {
            IronSourceError error = this.errorForUnsupportedAdapter("Rewarded Video");
            IronLog.INTERNAL.error(error.getErrorMessage());
            return false;
        }
        String placementId = config.optString("zoneId");
        IronLog.ADAPTER_API.verbose("placementId = " + placementId);
        return this.mRewardedVideoAdsAvailability.containsKey(placementId) && this.mRewardedVideoAdsAvailability.get(placementId) != false;
    }

    public Map<String, Object> getRewardedVideoBiddingData(JSONObject config, JSONObject adData) {
        return this.getBiddingData();
    }

    public void initInterstitialForBidding(String appKey, String userId, JSONObject config, InterstitialSmashListener listener) {
        IronLog.ADAPTER_API.verbose();
        this.initInterstitial(appKey, userId, config, listener);
    }

    public void initInterstitial(String appKey, String userId, JSONObject config, InterstitialSmashListener listener) {
        String gameId = config.optString("sourceId");
        String placementId = config.optString("zoneId");
        if (!this.isOSSupported()) {
            IronSourceError error = this.errorForUnsupportedAdapter("Interstitial");
            IronLog.INTERNAL.error(error.getErrorMessage());
            listener.onInterstitialInitFailed(error);
            return;
        }
        if (TextUtils.isEmpty((CharSequence)gameId)) {
            IronLog.INTERNAL.error("missing params = sourceId");
            listener.onInterstitialInitFailed(ErrorBuilder.buildInitFailedError((String)"Missing params - sourceId", (String)"Interstitial"));
            return;
        }
        if (TextUtils.isEmpty((CharSequence)placementId)) {
            IronLog.INTERNAL.error("missing params = zoneId");
            listener.onInterstitialInitFailed(ErrorBuilder.buildInitFailedError((String)"Missing params - zoneId", (String)"Interstitial"));
            return;
        }
        IronLog.ADAPTER_API.verbose("gameId = " + gameId + ", placementId = " + placementId);
        this.mPlacementIdToInterstitialSmashListener.put(placementId, listener);
        switch (mInitState) {
            case INIT_STATE_NONE: 
            case INIT_STATE_IN_PROGRESS: {
                this.initSDK(gameId, config);
                break;
            }
            case INIT_STATE_SUCCESS: {
                listener.onInterstitialInitSuccess();
                break;
            }
            case INIT_STATE_FAILED: {
                listener.onInterstitialInitFailed(ErrorBuilder.buildInitFailedError((String)"UnityAds SDK init failed", (String)"Interstitial"));
            }
        }
    }

    public void loadInterstitialForBidding(JSONObject config, JSONObject adData, String serverData, InterstitialSmashListener listener) {
        String placementId = config.optString("zoneId");
        IronLog.ADAPTER_API.verbose("placementId = " + placementId);
        this.loadInterstitialInternal(config, listener, serverData, placementId);
    }

    public void loadInterstitial(JSONObject config, JSONObject adData, InterstitialSmashListener listener) {
        String placementId = config.optString("zoneId");
        IronLog.ADAPTER_API.verbose("placementId = " + placementId);
        this.loadInterstitialInternal(config, listener, null, placementId);
    }

    private void loadInterstitialInternal(JSONObject config, InterstitialSmashListener listener, String serverData, String placementId) {
        IronLog.ADAPTER_API.verbose("placementId = " + placementId);
        this.mInterstitialAdsAvailability.put(placementId, false);
        UnityAdsInterstitialListener interstitialAdListener = new UnityAdsInterstitialListener(this, listener, placementId);
        this.mPlacementIdToInterstitialListener.put(placementId, interstitialAdListener);
        UnityAdsLoadOptions loadOptions = new UnityAdsLoadOptions();
        String mObjectId = UUID.randomUUID().toString();
        loadOptions.setObjectId(mObjectId);
        if (!TextUtils.isEmpty((CharSequence)serverData)) {
            loadOptions.setAdMarkup(serverData);
        }
        this.mInterstitialPlacementIdToLoadedAdObjectId.put(placementId, mObjectId);
        UnityAds.load((String)placementId, (UnityAdsLoadOptions)loadOptions, (IUnityAdsLoadListener)interstitialAdListener);
    }

    public void showInterstitial(JSONObject config, InterstitialSmashListener listener) {
        String placementId = config.optString("zoneId");
        IronLog.ADAPTER_API.verbose("placementId = " + placementId);
        if (this.isInterstitialReady(config)) {
            this.mInterstitialAdsAvailability.put(placementId, false);
            Activity currentActiveActivity = ContextProvider.getInstance().getCurrentActiveActivity();
            UnityAdsInterstitialListener unityAdsInterstitialListener = this.mPlacementIdToInterstitialListener.get(placementId);
            String mObjectId = this.mInterstitialPlacementIdToLoadedAdObjectId.get(placementId);
            UnityAdsShowOptions showOptions = new UnityAdsShowOptions();
            showOptions.setObjectId(mObjectId);
            UnityAds.show((Activity)currentActiveActivity, (String)placementId, (UnityAdsShowOptions)showOptions, (IUnityAdsShowListener)unityAdsInterstitialListener);
        } else {
            listener.onInterstitialAdShowFailed(ErrorBuilder.buildNoAdsToShowError((String)"Interstitial"));
        }
    }

    public boolean isInterstitialReady(JSONObject config) {
        if (!this.isOSSupported()) {
            IronSourceError error = this.errorForUnsupportedAdapter("Interstitial");
            IronLog.INTERNAL.error(error.getErrorMessage());
            return false;
        }
        String placementId = config.optString("zoneId");
        IronLog.ADAPTER_API.verbose("placementId = " + placementId);
        return this.mInterstitialAdsAvailability.containsKey(placementId) && this.mInterstitialAdsAvailability.get(placementId) != false;
    }

    public Map<String, Object> getInterstitialBiddingData(JSONObject config, JSONObject adData) {
        return this.getBiddingData();
    }

    public void initBannerForBidding(String appKey, String userId, JSONObject config, BannerSmashListener listener) {
        this.initBanners(appKey, userId, config, listener);
    }

    public void initBanners(String appKey, String userId, JSONObject config, BannerSmashListener listener) {
        String gameId = config.optString("sourceId");
        String placementId = config.optString("zoneId");
        if (!this.isOSSupported()) {
            IronSourceError error = this.errorForUnsupportedAdapter("Banner");
            IronLog.INTERNAL.error(error.getErrorMessage());
            listener.onBannerInitFailed(error);
            return;
        }
        if (TextUtils.isEmpty((CharSequence)gameId)) {
            IronLog.INTERNAL.error("missing params = sourceId");
            listener.onBannerInitFailed(ErrorBuilder.buildInitFailedError((String)"Missing params - sourceId", (String)"Banner"));
            return;
        }
        if (TextUtils.isEmpty((CharSequence)placementId)) {
            IronLog.INTERNAL.error("missing params = zoneId");
            listener.onBannerInitFailed(ErrorBuilder.buildInitFailedError((String)"Missing params - zoneId", (String)"Banner"));
            return;
        }
        IronLog.ADAPTER_API.verbose("gameId = " + gameId + ", placementId = " + placementId);
        this.mPlacementIdToBannerSmashListener.put(placementId, listener);
        switch (mInitState) {
            case INIT_STATE_NONE: 
            case INIT_STATE_IN_PROGRESS: {
                this.initSDK(gameId, config);
                break;
            }
            case INIT_STATE_SUCCESS: {
                listener.onBannerInitSuccess();
                break;
            }
            case INIT_STATE_FAILED: {
                listener.onBannerInitFailed(ErrorBuilder.buildInitFailedError((String)"UnityAds SDK init failed", (String)"Banner"));
            }
        }
    }

    public void loadBannerForBidding(JSONObject config, JSONObject adData, String serverData, IronSourceBannerLayout banner, BannerSmashListener listener) {
        this.loadBannerInternal(config, adData, banner, listener, serverData);
    }

    public void loadBanner(JSONObject config, JSONObject adData, IronSourceBannerLayout banner, BannerSmashListener listener) {
        this.loadBannerInternal(config, adData, banner, listener, null);
    }

    public void loadBannerInternal(JSONObject config, JSONObject adData, IronSourceBannerLayout banner, BannerSmashListener listener, String serverData) {
        String placementId = config.optString("zoneId");
        if (banner == null) {
            IronLog.INTERNAL.error("banner is null");
            listener.onBannerAdLoadFailed(ErrorBuilder.buildNoConfigurationAvailableError((String)"banner is null"));
            return;
        }
        if (!this.isBannerSizeSupported(banner.getSize()).booleanValue()) {
            IronLog.ADAPTER_API.verbose("size not supported, size = " + banner.getSize().getDescription());
            listener.onBannerAdLoadFailed(ErrorBuilder.unsupportedBannerSize((String)this.getProviderName()));
            return;
        }
        IronLog.ADAPTER_API.verbose("placementId = " + placementId);
        BannerView bannerView = this.getBannerView(banner, placementId, listener);
        UnityAdsLoadOptions loadOptions = new UnityAdsLoadOptions();
        String mObjectId = UUID.randomUUID().toString();
        loadOptions.setObjectId(mObjectId);
        if (!TextUtils.isEmpty((CharSequence)serverData)) {
            loadOptions.setAdMarkup(serverData);
        }
        bannerView.load(loadOptions);
    }

    public void destroyBanner(JSONObject config) {
        String placementId = config.optString("zoneId");
        IronLog.ADAPTER_API.verbose("placementId = " + placementId);
        if (this.mPlacementIdToBannerAd.get(placementId) != null) {
            this.mPlacementIdToBannerAd.get(placementId).destroy();
            this.mPlacementIdToBannerAd.remove(placementId);
        }
    }

    public Map<String, Object> getBannerBiddingData(JSONObject config, JSONObject adData) {
        return this.getBiddingData();
    }

    public void releaseMemory(IronSource.AD_UNIT adUnit, JSONObject config) {
        IronLog.INTERNAL.verbose("adUnit = " + adUnit);
        if (adUnit == IronSource.AD_UNIT.REWARDED_VIDEO) {
            this.mPlacementIdToRewardedVideoSmashListener.clear();
            this.mPlacementIdToRewardedVideoListener.clear();
            this.mRewardedVideoPlacementIdToLoadedAdObjectId.clear();
            this.mRewardedVideoAdsAvailability.clear();
            this.mRewardedVideoPlacementIdsForInitCallbacks.clear();
        } else if (adUnit == IronSource.AD_UNIT.INTERSTITIAL) {
            this.mPlacementIdToInterstitialSmashListener.clear();
            this.mPlacementIdToInterstitialListener.clear();
            this.mInterstitialPlacementIdToLoadedAdObjectId.clear();
            this.mInterstitialAdsAvailability.clear();
        } else if (adUnit == IronSource.AD_UNIT.BANNER) {
            for (BannerView adView : this.mPlacementIdToBannerAd.values()) {
                adView.destroy();
            }
            this.mPlacementIdToBannerSmashListener.clear();
            this.mPlacementIdToBannerListener.clear();
            this.mPlacementIdToBannerAd.clear();
        }
    }

    protected void setConsent(boolean consent) {
        IronLog.ADAPTER_API.verbose("setConsent = " + consent);
        this.setUnityAdsMetaData("gdpr.consent", consent);
    }

    protected void setMetaData(String key, List<String> values) {
        if (values.isEmpty()) {
            return;
        }
        String value = values.get(0);
        IronLog.ADAPTER_API.verbose("key = " + key + ", value = " + value);
        if (MetaDataUtils.isValidCCPAMetaData((String)key, (String)value)) {
            this.setCCPAValue(MetaDataUtils.getMetaDataBooleanValue((String)value));
        } else {
            String formattedValue = MetaDataUtils.formatValueForType((String)value, (MetaData.MetaDataValueTypes)MetaData.MetaDataValueTypes.META_DATA_VALUE_BOOLEAN);
            if (MetaDataUtils.isValidMetaData((String)key, (String)"unityads_coppa", (String)formattedValue)) {
                this.setCOPPAValue(MetaDataUtils.getMetaDataBooleanValue((String)formattedValue));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setUnityAdsMetaData(String key, boolean value) {
        IronLog.INTERNAL.verbose("key = " + key + "value = " + value);
        Object object = this.mUnityAdsStorageLock;
        synchronized (object) {
            MetaData metaData = new MetaData(ContextProvider.getInstance().getApplicationContext());
            metaData.set(key, (Object)value);
            if (key.equals("user.nonBehavioral")) {
                metaData.set("mode", (Object)"mixed");
            }
            metaData.commit();
        }
    }

    private void setCOPPAValue(boolean value) {
        IronLog.ADAPTER_API.verbose("value = " + value);
        this.setUnityAdsMetaData("user.nonBehavioral", value);
    }

    private void setCCPAValue(boolean value) {
        IronLog.ADAPTER_API.verbose("value = " + value);
        boolean optIn = !value;
        this.setUnityAdsMetaData("privacy.consent", optIn);
    }

    private Map<String, Object> getBiddingData() {
        String bidderToken;
        if (this.isAdsGateway) {
            bidderToken = UnityAds.getToken();
        } else if (InitState.INIT_STATE_SUCCESS == mInitState) {
            bidderToken = UnityAds.getToken();
        } else if (!TextUtils.isEmpty((CharSequence)asyncToken)) {
            bidderToken = asyncToken;
            this.getAsyncToken();
        } else {
            IronLog.INTERNAL.verbose("returning null as token since init did not finish successfully and async token did not return");
            return null;
        }
        String returnedToken = !TextUtils.isEmpty((CharSequence)bidderToken) ? bidderToken : "";
        IronLog.ADAPTER_API.verbose("token = " + returnedToken);
        HashMap<String, Object> ret = new HashMap<String, Object>();
        ret.put("token", returnedToken);
        return ret;
    }

    private Boolean isBannerSizeSupported(ISBannerSize size) {
        switch (size.getDescription()) {
            case "BANNER": 
            case "LARGE": 
            case "RECTANGLE": 
            case "SMART": {
                return true;
            }
        }
        return false;
    }

    private UnityBannerSize getBannerSize(ISBannerSize size, boolean isLargeScreen) {
        switch (size.getDescription()) {
            case "BANNER": 
            case "LARGE": {
                return new UnityBannerSize(320, 50);
            }
            case "RECTANGLE": {
                return new UnityBannerSize(300, 250);
            }
            case "SMART": {
                return isLargeScreen ? new UnityBannerSize(728, 90) : new UnityBannerSize(320, 50);
            }
        }
        return null;
    }

    private BannerView getBannerView(IronSourceBannerLayout banner, String placementId, BannerSmashListener listener) {
        if (this.mPlacementIdToBannerAd.get(placementId) != null) {
            this.mPlacementIdToBannerAd.get(placementId).destroy();
            this.mPlacementIdToBannerAd.remove(placementId);
        }
        UnityBannerSize unityBannerSize = this.getBannerSize(banner.getSize(), AdapterUtils.isLargeScreen((Context)ContextProvider.getInstance().getApplicationContext()));
        BannerView bannerView = new BannerView(ContextProvider.getInstance().getCurrentActiveActivity(), placementId, unityBannerSize);
        UnityAdsBannerListener bannerAdListener = new UnityAdsBannerListener(this, listener, placementId);
        this.mPlacementIdToBannerListener.put(placementId, bannerAdListener);
        bannerView.setListener((BannerView.IListener)bannerAdListener);
        this.mPlacementIdToBannerAd.put(placementId, bannerView);
        return bannerView;
    }

    protected FrameLayout.LayoutParams createLayoutParams(UnityBannerSize size) {
        int widthPixel = AdapterUtils.dpToPixels((Context)ContextProvider.getInstance().getApplicationContext(), (int)size.getWidth());
        FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(widthPixel, -2, 17);
        return layoutParams;
    }

    private IronSourceError errorForUnsupportedAdapter(String adUnit) {
        IronSourceError error = ErrorBuilder.buildInitFailedError((String)"UnityAds SDK version is not supported", (String)adUnit);
        return error;
    }

    @SuppressLint(value={"ObsoleteSdkInt"})
    private boolean isOSSupported() {
        return Build.VERSION.SDK_INT >= 19;
    }

    private int getUnityAdsInitializationErrorCode(UnityAds.UnityAdsInitializationError error) {
        if (error != null) {
            for (UnityAds.UnityAdsInitializationError e : UnityAds.UnityAdsInitializationError.values()) {
                if (!e.name().equalsIgnoreCase(error.toString())) continue;
                return UnityAds.UnityAdsInitializationError.valueOf((String)error.toString()).ordinal();
            }
        }
        return 510;
    }

    protected int getUnityAdsLoadErrorCode(UnityAds.UnityAdsLoadError error) {
        if (error != null) {
            for (UnityAds.UnityAdsLoadError e : UnityAds.UnityAdsLoadError.values()) {
                if (!e.name().equalsIgnoreCase(error.toString())) continue;
                return UnityAds.UnityAdsLoadError.valueOf((String)error.toString()).ordinal();
            }
        }
        return 510;
    }

    protected int getUnityAdsShowErrorCode(UnityAds.UnityAdsShowError error) {
        if (error != null) {
            for (UnityAds.UnityAdsShowError e : UnityAds.UnityAdsShowError.values()) {
                if (!e.name().equalsIgnoreCase(error.toString())) continue;
                return UnityAds.UnityAdsShowError.valueOf((String)error.toString()).ordinal();
            }
        }
        return 510;
    }

    public LoadWhileShowSupportState getLoadWhileShowSupportState(JSONObject mAdUnitSettings) {
        boolean isSupportedLWS;
        LoadWhileShowSupportState loadWhileShowSupportState = LoadWhileShowSupportState.LOAD_WHILE_SHOW_BY_INSTANCE;
        if (mAdUnitSettings != null && !(isSupportedLWS = mAdUnitSettings.optBoolean("isSupportedLWS", true))) {
            loadWhileShowSupportState = LoadWhileShowSupportState.NONE;
        }
        return loadWhileShowSupportState;
    }

    public void getAsyncToken() {
        IronLog.INTERNAL.verbose();
        UnityAds.getToken((IUnityAdsTokenListener)new IUnityAdsTokenListener(){

            public void onUnityAdsTokenReady(String token) {
                IronLog.ADAPTER_CALLBACK.verbose("async token returned");
                asyncToken = token;
            }
        });
    }

    private static enum InitState {
        INIT_STATE_NONE,
        INIT_STATE_IN_PROGRESS,
        INIT_STATE_SUCCESS,
        INIT_STATE_FAILED;

    }
}

