/*
 * Decompiled with CFR 0.152.
 */
package com.ironsource.adapters.unityads;

import android.view.View;
import com.ironsource.adapters.unityads.UnityAdsAdapter;
import com.ironsource.mediationsdk.logger.IronLog;
import com.ironsource.mediationsdk.logger.IronSourceError;
import com.ironsource.mediationsdk.sdk.BannerSmashListener;
import com.ironsource.mediationsdk.utils.ErrorBuilder;
import com.unity3d.services.banners.BannerErrorCode;
import com.unity3d.services.banners.BannerErrorInfo;
import com.unity3d.services.banners.BannerView;
import java.lang.ref.WeakReference;

final class UnityAdsBannerListener
implements BannerView.IListener {
    private String mPlacementId;
    private BannerSmashListener mListener;
    private WeakReference<UnityAdsAdapter> mAdapter;

    UnityAdsBannerListener(UnityAdsAdapter adapter, BannerSmashListener listener, String placementId) {
        this.mAdapter = new WeakReference<UnityAdsAdapter>(adapter);
        this.mPlacementId = placementId;
        this.mListener = listener;
    }

    public void onBannerLoaded(BannerView bannerView) {
        IronLog.ADAPTER_CALLBACK.verbose("placementId = " + this.mPlacementId);
        if (this.mListener == null) {
            IronLog.INTERNAL.verbose("listener is null");
            return;
        }
        if (this.mAdapter == null || this.mAdapter.get() == null) {
            IronLog.INTERNAL.verbose("adapter is null");
            return;
        }
        this.mListener.onBannerAdLoaded((View)bannerView, ((UnityAdsAdapter)((Object)this.mAdapter.get())).createLayoutParams(bannerView.getSize()));
    }

    public void onBannerShown(BannerView bannerAdView) {
        IronLog.ADAPTER_CALLBACK.verbose("placementId = " + this.mPlacementId);
        if (this.mListener == null) {
            IronLog.INTERNAL.verbose("listener is null");
            return;
        }
        if (this.mAdapter == null || this.mAdapter.get() == null) {
            IronLog.INTERNAL.verbose("adapter is null");
            return;
        }
        this.mListener.onBannerAdShown();
    }

    public void onBannerFailedToLoad(BannerView bannerView, BannerErrorInfo bannerErrorInfo) {
        if (this.mListener == null) {
            IronLog.INTERNAL.verbose("listener is null");
            return;
        }
        if (this.mAdapter == null || this.mAdapter.get() == null) {
            IronLog.INTERNAL.verbose("adapter is null");
            return;
        }
        String message = ((UnityAdsAdapter)((Object)this.mAdapter.get())).getProviderName() + " banner, onAdLoadFailed placementId " + this.mPlacementId + " with error: " + bannerErrorInfo.errorMessage;
        IronSourceError ironSourceError = bannerErrorInfo.errorCode == BannerErrorCode.NO_FILL ? new IronSourceError(606, message) : ErrorBuilder.buildLoadFailedError((String)message);
        IronLog.ADAPTER_CALLBACK.error("placementId = " + this.mPlacementId + " ironSourceError = " + ironSourceError);
        this.mListener.onBannerAdLoadFailed(ironSourceError);
    }

    public void onBannerClick(BannerView bannerView) {
        IronLog.ADAPTER_CALLBACK.verbose("placementId = " + this.mPlacementId);
        if (this.mListener == null) {
            IronLog.INTERNAL.verbose("listener is null");
            return;
        }
        this.mListener.onBannerAdClicked();
    }

    public void onBannerLeftApplication(BannerView bannerView) {
        IronLog.ADAPTER_CALLBACK.verbose("placementId = " + this.mPlacementId);
        if (this.mListener == null) {
            IronLog.INTERNAL.verbose("listener is null");
            return;
        }
        this.mListener.onBannerAdLeftApplication();
    }
}

