/*
 * Decompiled with CFR 0.152.
 */
package com.ironsource.adapters.unityads;

import com.ironsource.adapters.unityads.UnityAdsAdapter;
import com.ironsource.mediationsdk.logger.IronLog;
import com.ironsource.mediationsdk.logger.IronSourceError;
import com.ironsource.mediationsdk.sdk.InterstitialSmashListener;
import com.ironsource.mediationsdk.utils.ErrorBuilder;
import com.unity3d.ads.IUnityAdsLoadListener;
import com.unity3d.ads.IUnityAdsShowListener;
import com.unity3d.ads.UnityAds;
import java.lang.ref.WeakReference;

final class UnityAdsInterstitialListener
implements IUnityAdsLoadListener,
IUnityAdsShowListener {
    private String mPlacementId;
    private InterstitialSmashListener mListener;
    private WeakReference<UnityAdsAdapter> mAdapter;

    UnityAdsInterstitialListener(UnityAdsAdapter adapter, InterstitialSmashListener listener, String placementId) {
        this.mAdapter = new WeakReference<UnityAdsAdapter>(adapter);
        this.mPlacementId = placementId;
        this.mListener = listener;
    }

    public void onUnityAdsAdLoaded(String placementId) {
        IronLog.ADAPTER_CALLBACK.verbose("placementId = " + this.mPlacementId);
        if (this.mListener == null) {
            IronLog.INTERNAL.verbose("listener is null");
            return;
        }
        if (this.mAdapter == null || this.mAdapter.get() == null) {
            IronLog.INTERNAL.verbose("adapter is null");
            return;
        }
        ((UnityAdsAdapter)((Object)this.mAdapter.get())).mInterstitialAdsAvailability.put(this.mPlacementId, true);
        this.mListener.onInterstitialAdReady();
    }

    public void onUnityAdsFailedToLoad(String placementId, UnityAds.UnityAdsLoadError error, String message) {
        IronSourceError ironSourceError;
        if (this.mListener == null) {
            IronLog.INTERNAL.verbose("listener is null");
            return;
        }
        if (this.mAdapter == null || this.mAdapter.get() == null) {
            IronLog.INTERNAL.verbose("adapter is null");
            return;
        }
        if (error != null) {
            int errorCode = error == UnityAds.UnityAdsLoadError.NO_FILL ? 1158 : ((UnityAdsAdapter)((Object)this.mAdapter.get())).getUnityAdsLoadErrorCode(error);
            ironSourceError = new IronSourceError(errorCode, message);
        } else {
            ironSourceError = ErrorBuilder.buildLoadFailedError((String)"Interstitial", (String)((UnityAdsAdapter)((Object)this.mAdapter.get())).getProviderName(), (String)message);
        }
        IronLog.ADAPTER_CALLBACK.error("placementId = " + this.mPlacementId + " ironSourceError = " + ironSourceError);
        this.mListener.onInterstitialAdLoadFailed(ironSourceError);
        ((UnityAdsAdapter)((Object)this.mAdapter.get())).mInterstitialAdsAvailability.put(this.mPlacementId, false);
    }

    public void onUnityAdsShowStart(String placementId) {
        IronLog.ADAPTER_CALLBACK.verbose("placementId = " + this.mPlacementId);
        if (this.mListener == null) {
            IronLog.INTERNAL.verbose("listener is null");
            return;
        }
        this.mListener.onInterstitialAdOpened();
        this.mListener.onInterstitialAdShowSucceeded();
    }

    public void onUnityAdsShowFailure(String placementId, UnityAds.UnityAdsShowError error, String message) {
        if (this.mListener == null) {
            IronLog.INTERNAL.verbose("listener is null");
            return;
        }
        if (this.mAdapter == null || this.mAdapter.get() == null) {
            IronLog.INTERNAL.verbose("adapter is null");
            return;
        }
        IronSourceError ironSourceError = error != null ? new IronSourceError(((UnityAdsAdapter)((Object)this.mAdapter.get())).getUnityAdsShowErrorCode(error), message) : ErrorBuilder.buildShowFailedError((String)"Interstitial", (String)message);
        IronLog.ADAPTER_CALLBACK.error("placementId = " + this.mPlacementId + "ironSourceError = " + ironSourceError);
        this.mListener.onInterstitialAdShowFailed(ironSourceError);
    }

    public void onUnityAdsShowClick(String placementId) {
        IronLog.ADAPTER_CALLBACK.verbose("placementId = " + this.mPlacementId);
        if (this.mListener == null) {
            IronLog.INTERNAL.verbose("listener is null");
            return;
        }
        this.mListener.onInterstitialAdClicked();
    }

    public void onUnityAdsShowComplete(String placementId, UnityAds.UnityAdsShowCompletionState completionState) {
        IronLog.ADAPTER_CALLBACK.verbose("placementId = " + this.mPlacementId + " completionState: " + completionState);
        if (this.mListener == null) {
            IronLog.INTERNAL.verbose("listener is null");
            return;
        }
        switch (completionState) {
            case SKIPPED: 
            case COMPLETED: {
                this.mListener.onInterstitialAdClosed();
                break;
            }
        }
    }
}

