/*
 * Decompiled with CFR 0.152.
 */
package com.ironsource.adapters.unityads;

import com.ironsource.adapters.unityads.UnityAdsAdapter;
import com.ironsource.mediationsdk.logger.IronLog;
import com.ironsource.mediationsdk.logger.IronSourceError;
import com.ironsource.mediationsdk.sdk.RewardedVideoSmashListener;
import com.ironsource.mediationsdk.utils.ErrorBuilder;
import com.unity3d.ads.IUnityAdsLoadListener;
import com.unity3d.ads.IUnityAdsShowListener;
import com.unity3d.ads.UnityAds;
import java.lang.ref.WeakReference;

final class UnityAdsRewardedVideoListener
implements IUnityAdsLoadListener,
IUnityAdsShowListener {
    private String mPlacementId;
    private RewardedVideoSmashListener mListener;
    private WeakReference<UnityAdsAdapter> mAdapter;

    UnityAdsRewardedVideoListener(UnityAdsAdapter adapter, RewardedVideoSmashListener listener, String placementId) {
        this.mAdapter = new WeakReference<UnityAdsAdapter>(adapter);
        this.mPlacementId = placementId;
        this.mListener = listener;
    }

    public void onUnityAdsAdLoaded(String placementId) {
        IronLog.ADAPTER_CALLBACK.verbose("placementId = " + this.mPlacementId);
        if (this.mListener == null) {
            IronLog.INTERNAL.verbose("listener is null");
            return;
        }
        if (this.mAdapter == null || this.mAdapter.get() == null) {
            IronLog.INTERNAL.verbose("adapter is null");
            return;
        }
        ((UnityAdsAdapter)((Object)this.mAdapter.get())).mRewardedVideoAdsAvailability.put(this.mPlacementId, true);
        this.mListener.onRewardedVideoAvailabilityChanged(true);
    }

    public void onUnityAdsFailedToLoad(String placementId, UnityAds.UnityAdsLoadError error, String message) {
        IronSourceError ironSourceError;
        if (this.mListener == null) {
            IronLog.INTERNAL.verbose("listener is null");
            return;
        }
        if (this.mAdapter == null || this.mAdapter.get() == null) {
            IronLog.INTERNAL.verbose("adapter is null");
            return;
        }
        ((UnityAdsAdapter)((Object)this.mAdapter.get())).mRewardedVideoAdsAvailability.put(this.mPlacementId, false);
        this.mListener.onRewardedVideoAvailabilityChanged(false);
        if (error != null) {
            int errorCode = error == UnityAds.UnityAdsLoadError.NO_FILL ? 1058 : ((UnityAdsAdapter)((Object)this.mAdapter.get())).getUnityAdsLoadErrorCode(error);
            ironSourceError = new IronSourceError(errorCode, message);
            this.mListener.onRewardedVideoLoadFailed(ironSourceError);
        } else {
            ironSourceError = ErrorBuilder.buildLoadFailedError((String)"Rewarded Video", (String)((UnityAdsAdapter)((Object)this.mAdapter.get())).getProviderName(), (String)message);
        }
        IronLog.ADAPTER_CALLBACK.error("placementId = " + this.mPlacementId + " ironSourceError = " + ironSourceError);
    }

    public void onUnityAdsShowStart(String placementId) {
        IronLog.ADAPTER_CALLBACK.verbose("placementId = " + this.mPlacementId);
        if (this.mListener == null) {
            IronLog.INTERNAL.verbose("listener is null");
            return;
        }
        this.mListener.onRewardedVideoAdOpened();
        this.mListener.onRewardedVideoAdStarted();
    }

    public void onUnityAdsShowFailure(String placementId, UnityAds.UnityAdsShowError error, String message) {
        if (this.mListener == null) {
            IronLog.INTERNAL.verbose("listener is null");
            return;
        }
        if (this.mAdapter == null || this.mAdapter.get() == null) {
            IronLog.INTERNAL.verbose("adapter is null");
            return;
        }
        IronSourceError ironSourceError = error != null ? new IronSourceError(((UnityAdsAdapter)((Object)this.mAdapter.get())).getUnityAdsShowErrorCode(error), message) : ErrorBuilder.buildShowFailedError((String)"Rewarded Video", (String)message);
        IronLog.ADAPTER_CALLBACK.error("placementId = " + this.mPlacementId + " ironSourceError = " + ironSourceError);
        this.mListener.onRewardedVideoAdShowFailed(ironSourceError);
    }

    public void onUnityAdsShowClick(String placementId) {
        IronLog.ADAPTER_CALLBACK.verbose("placementId = " + this.mPlacementId);
        if (this.mListener == null) {
            IronLog.INTERNAL.verbose("listener is null");
            return;
        }
        this.mListener.onRewardedVideoAdClicked();
    }

    public void onUnityAdsShowComplete(String placementId, UnityAds.UnityAdsShowCompletionState completionState) {
        IronLog.ADAPTER_CALLBACK.verbose("placementId = " + this.mPlacementId + " completionState: " + completionState);
        if (this.mListener == null) {
            IronLog.INTERNAL.verbose("listener is null");
            return;
        }
        switch (completionState) {
            case SKIPPED: {
                this.mListener.onRewardedVideoAdClosed();
                break;
            }
            case COMPLETED: {
                this.mListener.onRewardedVideoAdEnded();
                this.mListener.onRewardedVideoAdRewarded();
                this.mListener.onRewardedVideoAdClosed();
                break;
            }
        }
    }
}

