/*
 * Decompiled with CFR 0.152.
 */
package com.virjar.dungproxy.client.httpclient;

import com.alibaba.fastjson.JSONObject;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.virjar.dungproxy.client.httpclient.NameValuePairBuilder;
import com.virjar.dungproxy.client.ippool.config.ProxyConstant;
import com.virjar.dungproxy.client.util.CharsetDetector;
import java.io.Closeable;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpException;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.NameValuePair;
import org.apache.http.auth.AuthSchemeProvider;
import org.apache.http.auth.AuthState;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.CookieStore;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.Configurable;
import org.apache.http.client.methods.HttpExecutionAware;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestWrapper;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.params.HttpClientParamConfig;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.http.config.Lookup;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.ClientConnectionRequest;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.ManagedClientConnection;
import org.apache.http.conn.routing.HttpRoute;
import org.apache.http.conn.routing.HttpRoutePlanner;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.cookie.CookieSpecProvider;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.execchain.ClientExecChain;
import org.apache.http.params.HttpParams;
import org.apache.http.params.HttpParamsNames;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.Args;
import org.apache.http.util.EntityUtils;
import org.mozilla.universalchardet.UniversalDetector;

public class CrawlerHttpClient
extends CloseableHttpClient
implements Configurable {
    private final Log log = LogFactory.getLog(((Object)((Object)this)).getClass());
    private final ClientExecChain execChain;
    private final HttpClientConnectionManager connManager;
    private HttpRoutePlanner routePlanner;
    private final Lookup<CookieSpecProvider> cookieSpecRegistry;
    private final Lookup<AuthSchemeProvider> authSchemeRegistry;
    private final CookieStore cookieStore;
    private final CredentialsProvider credentialsProvider;
    private final RequestConfig defaultConfig;
    private final List<Closeable> closeables;
    private ConcurrentMap<String, Charset> charsetCache = Maps.newConcurrentMap();
    private boolean charsetCacheEnable = true;

    CrawlerHttpClient(ClientExecChain execChain, HttpClientConnectionManager connManager, HttpRoutePlanner routePlanner, Lookup<CookieSpecProvider> cookieSpecRegistry, Lookup<AuthSchemeProvider> authSchemeRegistry, CookieStore cookieStore, CredentialsProvider credentialsProvider, RequestConfig defaultConfig, List<Closeable> closeables, boolean charsetCacheEnable) {
        Args.notNull((Object)execChain, (String)"HTTP client exec chain");
        Args.notNull((Object)connManager, (String)"HTTP connection manager");
        Args.notNull((Object)routePlanner, (String)"HTTP route planner");
        this.execChain = execChain;
        this.connManager = connManager;
        this.routePlanner = routePlanner;
        this.cookieSpecRegistry = cookieSpecRegistry;
        this.authSchemeRegistry = authSchemeRegistry;
        this.cookieStore = cookieStore;
        this.credentialsProvider = credentialsProvider;
        this.defaultConfig = defaultConfig;
        this.closeables = closeables;
        this.charsetCacheEnable = charsetCacheEnable;
    }

    public HttpRoutePlanner getRoutePlanner() {
        return this.routePlanner;
    }

    public void setRoutePlanner(HttpRoutePlanner routePlanner) {
        Preconditions.checkNotNull((Object)routePlanner);
        this.routePlanner = routePlanner;
    }

    private HttpRoute determineRoute(HttpHost target, HttpRequest request, HttpContext context) throws HttpException {
        HttpHost host = target;
        if (host == null) {
            host = (HttpHost)request.getParams().getParameter("http.default-host");
        }
        return this.routePlanner.determineRoute(host, request, context);
    }

    private void setupContext(HttpClientContext context) {
        if (context.getAttribute("http.auth.target-scope") == null) {
            context.setAttribute("http.auth.target-scope", (Object)new AuthState());
        }
        if (context.getAttribute("http.auth.proxy-scope") == null) {
            context.setAttribute("http.auth.proxy-scope", (Object)new AuthState());
        }
        if (context.getAttribute("http.authscheme-registry") == null) {
            context.setAttribute("http.authscheme-registry", this.authSchemeRegistry);
        }
        if (context.getAttribute("http.cookiespec-registry") == null) {
            context.setAttribute("http.cookiespec-registry", this.cookieSpecRegistry);
        }
        if (context.getAttribute("http.cookie-store") == null) {
            context.setAttribute("http.cookie-store", (Object)this.cookieStore);
        }
        if (context.getAttribute("http.auth.credentials-provider") == null) {
            context.setAttribute("http.auth.credentials-provider", (Object)this.credentialsProvider);
        }
        if (context.getAttribute("http.request-config") == null) {
            context.setAttribute("http.request-config", (Object)this.defaultConfig);
        }
    }

    public CookieStore getCookieStore() {
        return this.cookieStore;
    }

    protected CloseableHttpResponse doExecute(HttpHost target, HttpRequest request, HttpContext context) throws IOException {
        Args.notNull((Object)request, (String)"HTTP request");
        HttpExecutionAware execAware = null;
        if (request instanceof HttpExecutionAware) {
            execAware = (HttpExecutionAware)request;
        }
        try {
            HttpRequestWrapper wrapper = HttpRequestWrapper.wrap((HttpRequest)request, (HttpHost)target);
            HttpClientContext localcontext = HttpClientContext.adapt((HttpContext)(context != null ? context : new BasicHttpContext()));
            RequestConfig config = null;
            if (request instanceof Configurable) {
                config = ((Configurable)request).getConfig();
            }
            if (config == null) {
                HttpParams params = request.getParams();
                if (params instanceof HttpParamsNames) {
                    if (!((HttpParamsNames)params).getNames().isEmpty()) {
                        config = HttpClientParamConfig.getRequestConfig((HttpParams)params);
                    }
                } else {
                    config = HttpClientParamConfig.getRequestConfig((HttpParams)params);
                }
            }
            if (config != null) {
                localcontext.setRequestConfig(config);
            }
            this.setupContext(localcontext);
            HttpRoute route = this.determineRoute(target, (HttpRequest)wrapper, (HttpContext)localcontext);
            return this.execChain.execute(route, wrapper, localcontext, execAware);
        }
        catch (HttpException httpException) {
            throw new ClientProtocolException((Throwable)httpException);
        }
    }

    public RequestConfig getConfig() {
        return this.defaultConfig;
    }

    public void close() {
        if (this.closeables != null) {
            for (Closeable closeable : this.closeables) {
                try {
                    closeable.close();
                }
                catch (IOException ex) {
                    this.log.error((Object)ex.getMessage(), (Throwable)ex);
                }
            }
        }
    }

    public HttpParams getParams() {
        throw new UnsupportedOperationException();
    }

    public ClientConnectionManager getConnectionManager() {
        return new ClientConnectionManager(){

            public void shutdown() {
                CrawlerHttpClient.this.connManager.shutdown();
            }

            public ClientConnectionRequest requestConnection(HttpRoute route, Object state) {
                throw new UnsupportedOperationException();
            }

            public void releaseConnection(ManagedClientConnection conn, long validDuration, TimeUnit timeUnit) {
                throw new UnsupportedOperationException();
            }

            public SchemeRegistry getSchemeRegistry() {
                throw new UnsupportedOperationException();
            }

            public void closeIdleConnections(long idletime, TimeUnit tunit) {
                CrawlerHttpClient.this.connManager.closeIdleConnections(idletime, tunit);
            }

            public void closeExpiredConnections() {
                CrawlerHttpClient.this.connManager.closeExpiredConnections();
            }
        };
    }

    public String get(String url, Map<String, String> params, Charset charset, Header[] headers, String proxyIp, int proxyPort) {
        return this.get(url, this.convert(params), charset, headers, proxyIp, proxyPort);
    }

    public String get(String url, Charset charset, Header[] headers, String proxyIp, int proxyPort) {
        return this.get(url, (List<NameValuePair>)null, charset, headers, proxyIp, proxyPort);
    }

    public String get(String url, List<NameValuePair> nameValuePairs, Header[] headers, String proxyIp, int proxyPort) {
        return this.get(url, nameValuePairs, null, headers, proxyIp, proxyPort);
    }

    public String get(String url, List<NameValuePair> params, Charset charset, String proxyIp, int proxyPort) {
        return this.get(url, params, charset, null, proxyIp, proxyPort);
    }

    public String get(String url, List<NameValuePair> params, Charset charset, Header[] headers) {
        return this.get(url, params, charset, headers, null, -1);
    }

    public String get(String url, Header[] headers, HttpClientContext httpClientContext) {
        return this.get(url, null, null, headers, null, 0, httpClientContext);
    }

    public String get(String url, Header[] headers, String proxyIp, int proxyPort) {
        return this.get(url, (List<NameValuePair>)null, null, headers, proxyIp, proxyPort);
    }

    public String get(String url, Charset charset, String proxyIp, int proxyPort) {
        return this.get(url, (List<NameValuePair>)null, charset, null, proxyIp, proxyPort);
    }

    public String get(String url, Charset charset, Header[] headers) {
        return this.get(url, (List<NameValuePair>)null, charset, headers, null, -1);
    }

    public String get(String url, List<NameValuePair> params, String proxyIp, int proxyPort) {
        return this.get(url, params, null, null, proxyIp, proxyPort);
    }

    public String get(String url, List<NameValuePair> params, Header[] headers) {
        return this.get(url, params, null, headers, null, -1);
    }

    public String get(String url, List<NameValuePair> params, Charset charset) {
        return this.get(url, params, charset, null, null, -1);
    }

    public String get(String url, List<NameValuePair> params) {
        return this.get(url, params, null, null, null, -1);
    }

    public String get(String url, Charset charset) {
        return this.get(url, (List<NameValuePair>)null, charset, null, null, -1);
    }

    public String get(String url, Header[] headers) {
        return this.get(url, (List<NameValuePair>)null, null, headers, null, -1);
    }

    public String get(String url, String proxyIp, int proxyPort) {
        return this.get(url, (List<NameValuePair>)null, null, null, proxyIp, proxyPort);
    }

    public String get(String url) {
        return this.get(url, (List<NameValuePair>)null, null, null, null, -1);
    }

    public String get(String url, HttpClientContext httpClientContext) {
        return this.get(url, null, null, null, null, -1, httpClientContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getStatus(String url, String proxyIp, int proxyPort) {
        HttpGet httpGet = new HttpGet(url);
        RequestConfig.Builder builder = RequestConfig.custom().setSocketTimeout(ProxyConstant.SOCKET_TIMEOUT).setConnectTimeout(ProxyConstant.CONNECT_TIMEOUT).setConnectionRequestTimeout(ProxyConstant.REQUEST_TIMEOUT).setRedirectsEnabled(true).setCircularRedirectsAllowed(true);
        if (StringUtils.isNotEmpty((CharSequence)proxyIp)) {
            builder.setProxy(new HttpHost(proxyIp, proxyPort));
        }
        httpGet.setConfig(builder.build());
        try {
            CloseableHttpResponse execute = this.execute((HttpUriRequest)httpGet);
            int n = execute.getStatusLine().getStatusCode();
            return n;
        }
        catch (IOException e) {
            int n = -1;
            return n;
        }
        finally {
            httpGet.releaseConnection();
        }
    }

    public String get(String url, List<NameValuePair> params, Charset charset, Header[] headers, String proxyIp, int proxyPort) {
        return this.get(url, params, charset, headers, proxyIp, proxyPort, null);
    }

    public String get(String url, List<NameValuePair> params, Header[] headers, HttpClientContext httpClientContext) {
        return this.get(url, params, null, headers, null, 0, httpClientContext);
    }

    public String get(String url, List<NameValuePair> params, Charset charset, Header[] headers, String proxyIp, int proxyPort, HttpClientContext httpClientContext) {
        if (params != null && params.size() > 0) {
            url = url.endsWith("?") ? url + URLEncodedUtils.format(params, (String)"utf-8") : url + "?" + URLEncodedUtils.format(params, (String)"utf-8");
        }
        HttpGet httpGet = new HttpGet(url);
        RequestConfig.Builder builder = RequestConfig.custom().setSocketTimeout(ProxyConstant.SOCKET_TIMEOUT).setConnectTimeout(ProxyConstant.CONNECT_TIMEOUT).setConnectionRequestTimeout(ProxyConstant.REQUEST_TIMEOUT).setRedirectsEnabled(true).setCircularRedirectsAllowed(true);
        if (StringUtils.isNotEmpty((CharSequence)proxyIp)) {
            builder.setProxy(new HttpHost(proxyIp, proxyPort));
        }
        httpGet.setConfig(builder.build());
        if (headers != null && headers.length > 0) {
            httpGet.setHeaders(headers);
        }
        try {
            return this.decodeHttpResponse(this.execute((HttpUriRequest)httpGet, (HttpContext)httpClientContext), charset, httpGet.getURI().getScheme() + httpGet.getURI().getHost());
        }
        catch (IOException e) {
            return null;
        }
    }

    public byte[] getEntity(String url, List<NameValuePair> params, Charset charset, Header[] headers, String proxyIp, int proxyPort, HttpClientContext httpClientContext) {
        if (params != null && params.size() > 0) {
            url = url + "?" + URLEncodedUtils.format(params, (String)"utf-8");
        }
        HttpGet httpGet = new HttpGet(url);
        RequestConfig.Builder builder = RequestConfig.custom().setSocketTimeout(ProxyConstant.SOCKET_TIMEOUT).setConnectTimeout(ProxyConstant.CONNECT_TIMEOUT).setConnectionRequestTimeout(ProxyConstant.REQUEST_TIMEOUT).setRedirectsEnabled(true).setCircularRedirectsAllowed(true);
        if (StringUtils.isNotEmpty((CharSequence)proxyIp)) {
            builder.setProxy(new HttpHost(proxyIp, proxyPort));
        }
        httpGet.setConfig(builder.build());
        if (headers != null && headers.length > 0) {
            httpGet.setHeaders(headers);
        }
        try {
            return EntityUtils.toByteArray((HttpEntity)this.execute((HttpUriRequest)httpGet, (HttpContext)httpClientContext).getEntity());
        }
        catch (IOException e) {
            return null;
        }
    }

    public byte[] getEntity(String url) {
        return this.getEntity(url, null, null, null, null, 0, null);
    }

    public byte[] getEntity(String url, Header[] headers) {
        return this.getEntity(url, null, null, headers, null, 0, null);
    }

    public String post(String url, String entity, Charset charset, Header[] headers, String proxyIp, int proxyPort) {
        return this.post(url, (HttpEntity)new StringEntity(entity, ContentType.TEXT_PLAIN), charset, headers, proxyIp, proxyPort, null);
    }

    public String postJSON(String url, Object entity, Charset charset, Header[] headers, String proxyIp, int proxyPort) {
        return this.post(url, (HttpEntity)new StringEntity(JSONObject.toJSONString((Object)entity), ContentType.APPLICATION_JSON), charset, headers, proxyIp, proxyPort, null);
    }

    public String post(String url, List<NameValuePair> params, Charset charset, Header[] headers, String proxyIp, int proxyPort) {
        return this.post(url, (HttpEntity)new UrlEncodedFormEntity(params, Charset.defaultCharset()), charset, headers, proxyIp, proxyPort, null);
    }

    public String post(String url, List<NameValuePair> params, Header[] headers) {
        return this.post(url, (HttpEntity)new UrlEncodedFormEntity(params, Charset.defaultCharset()), null, headers, null, -1, null);
    }

    public String post(String url, Map<String, String> params, Header[] headers) {
        return this.post(url, (HttpEntity)new UrlEncodedFormEntity(this.convert(params), Charset.defaultCharset()), null, headers, null, -1, null);
    }

    public String post(String url, String entity, Header[] headers) {
        return this.post(url, (HttpEntity)new StringEntity(entity, ContentType.create((String)"text/plain", (Charset)Charset.defaultCharset())), null, headers, null, -1, null);
    }

    public String postJSON(String url, Object entity, Header[] headers) {
        return this.post(url, (HttpEntity)new StringEntity(JSONObject.toJSONString((Object)entity), ContentType.APPLICATION_JSON), null, headers, null, -1, null);
    }

    public String post(String url, Map<String, String> params) {
        return this.post(url, (HttpEntity)new UrlEncodedFormEntity(this.convert(params), Charset.defaultCharset()), null, null, null, -1, null);
    }

    public String post(String url, List<NameValuePair> params, HttpClientContext httpClientContext) {
        return this.post(url, (HttpEntity)new UrlEncodedFormEntity(params, Charset.defaultCharset()), null, null, null, -1, httpClientContext);
    }

    public String post(String url, List<NameValuePair> params, Header[] headers, HttpClientContext httpClientContext) {
        return this.post(url, (HttpEntity)new UrlEncodedFormEntity(params, Charset.defaultCharset()), null, headers, null, -1, httpClientContext);
    }

    public String post(String url, Map<String, String> params, HttpClientContext httpClientContext) {
        return this.post(url, (HttpEntity)new UrlEncodedFormEntity(this.convert(params), Charset.defaultCharset()), null, null, null, -1, httpClientContext);
    }

    public String post(String url, String entity) {
        return this.post(url, (HttpEntity)new StringEntity(entity, ContentType.create((String)"text/plain", (Charset)Charset.defaultCharset())), null, null, null, -1, null);
    }

    public String postJSON(String url, Object entity) {
        return this.post(url, (HttpEntity)new StringEntity(JSONObject.toJSONString((Object)entity), ContentType.APPLICATION_JSON), null, null, null, -1, null);
    }

    public String postJSON(String url, Object entity, HttpClientContext httpClientContext) {
        return this.post(url, (HttpEntity)new StringEntity(JSONObject.toJSONString((Object)entity), ContentType.APPLICATION_JSON), null, null, null, -1, httpClientContext);
    }

    public String post(String url, List<NameValuePair> params) {
        return this.post(url, (HttpEntity)new UrlEncodedFormEntity(params, Charset.defaultCharset()), null, null, null, -1, null);
    }

    public String post(String url, Map<String, String> params, Charset charset, Header[] headers, String proxyIp, int proxyPort) {
        return this.post(url, (HttpEntity)new UrlEncodedFormEntity(this.convert(params), Charset.defaultCharset()), charset, headers, proxyIp, proxyPort, null);
    }

    public String post(String url, Map<String, String> params, Header[] headers, String proxyIp, int proxyPort) {
        return this.post(url, (HttpEntity)new UrlEncodedFormEntity(this.convert(params), Charset.defaultCharset()), null, headers, proxyIp, proxyPort, null);
    }

    public String post(String url, List<NameValuePair> params, Header[] headers, String proxyIp, int proxyPort) {
        return this.post(url, (HttpEntity)new UrlEncodedFormEntity(params, Charset.defaultCharset()), null, headers, proxyIp, proxyPort, null);
    }

    public String post(String url, HttpEntity entity, Charset charset, Header[] headers, String proxyIp, int proxyPort, HttpClientContext httpClientContext) {
        HttpPost httpPost = new HttpPost(url);
        RequestConfig.Builder builder = RequestConfig.custom().setSocketTimeout(ProxyConstant.SOCKET_TIMEOUT).setConnectTimeout(ProxyConstant.CONNECT_TIMEOUT).setConnectionRequestTimeout(ProxyConstant.REQUEST_TIMEOUT).setRedirectsEnabled(true).setCircularRedirectsAllowed(true);
        if (StringUtils.isNotEmpty((CharSequence)proxyIp)) {
            builder.setProxy(new HttpHost(proxyIp, proxyPort));
        }
        httpPost.setConfig(builder.build());
        if (headers != null && headers.length > 0) {
            httpPost.setHeaders(headers);
        }
        httpPost.setEntity(entity);
        try {
            return this.decodeHttpResponse(this.execute((HttpUriRequest)httpPost, (HttpContext)httpClientContext), charset, httpPost.getURI().getScheme() + httpPost.getURI().getHost());
        }
        catch (IOException e) {
            return null;
        }
    }

    private String decodeHttpResponse(CloseableHttpResponse response, Charset charset, String hostKey) throws IOException {
        byte[] bytes = EntityUtils.toByteArray((HttpEntity)response.getEntity());
        String charsetStr = null;
        try {
            Header contentType;
            if (charset == null && this.charsetCacheEnable) {
                charset = (Charset)this.charsetCache.get(hostKey);
            }
            if (charset == null && (contentType = response.getFirstHeader("Content-Type")) != null && (charsetStr = CharsetDetector.detectHeader(contentType)) != null) {
                charset = Charset.forName(charsetStr.trim());
            }
            if (charset == null && (charsetStr = CharsetDetector.detectHtmlContent(bytes)) != null) {
                charset = Charset.forName(charsetStr.trim());
            }
            if (charset == null) {
                UniversalDetector detector = new UniversalDetector(null);
                detector.handleData(bytes, 0, bytes.length);
                detector.dataEnd();
                String encoding = detector.getDetectedCharset();
                if (encoding != null) {
                    charset = Charset.forName(encoding);
                }
                detector.reset();
            }
            if (charset != null && this.charsetCacheEnable) {
                this.charsetCache.putIfAbsent(hostKey, charset);
            }
            if (charset == null) {
                charset = Charset.defaultCharset();
            }
        }
        catch (IllegalCharsetNameException e) {
            this.log.warn((Object)("\u5b57\u7b26\u96c6" + charsetStr + "\u4e0d\u80fd\u8bc6\u522b"), (Throwable)e);
            charset = Charset.defaultCharset();
        }
        catch (UnsupportedCharsetException ue) {
            this.log.warn((Object)("\u5b57\u7b26\u96c6" + charsetStr + "\u4e0d\u80fd\u8bc6\u522b"), (Throwable)ue);
            charset = Charset.defaultCharset();
        }
        return new String(bytes, charset);
    }

    private List<NameValuePair> convert(Map<String, String> params) {
        return NameValuePairBuilder.create().addParams(params).build();
    }
}

