/*
 * Decompiled with CFR 0.152.
 */
package com.virjar.dungproxy.client.httpclient;

import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.http.NameValuePair;
import org.apache.http.message.BasicNameValuePair;

public class NameValuePairBuilder {
    private List<NameValuePair> params = Lists.newLinkedList();

    public static NameValuePairBuilder create() {
        return new NameValuePairBuilder();
    }

    public NameValuePairBuilder addParam(String name, String value) {
        this.params.add((NameValuePair)new BasicNameValuePair(name, value));
        return this;
    }

    public NameValuePairBuilder addParam(String name) {
        return this.addParam(name, "");
    }

    public NameValuePairBuilder addParams(Map<String, String> params) {
        for (Map.Entry<String, String> entry : params.entrySet()) {
            this.addParam(entry.getKey(), entry.getValue());
        }
        return this;
    }

    public NameValuePairBuilder addParams(Collection<NameValuePair> params) {
        this.params.addAll(params);
        return this;
    }

    public List<NameValuePair> build() {
        return Lists.newArrayList(this.params);
    }
}

