/*
 * Decompiled with CFR 0.152.
 */
package com.virjar.dungproxy.client.httpclient.conn;

import com.virjar.dungproxy.client.ippool.IpPool;
import com.virjar.dungproxy.client.ippool.IpPoolHolder;
import com.virjar.dungproxy.client.model.AvProxy;
import com.virjar.dungproxy.client.util.PoolUtil;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.Header;
import org.apache.http.HttpException;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpRequestWrapper;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.conn.SchemePortResolver;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.conn.DefaultRoutePlanner;
import org.apache.http.protocol.HttpContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProxyBindRoutPlanner
extends DefaultRoutePlanner {
    private static final Logger logger = LoggerFactory.getLogger(ProxyBindRoutPlanner.class);
    private IpPool ipPool;
    private SchemePortResolver schemePortResolver;

    public ProxyBindRoutPlanner() {
        this(null, null);
    }

    public ProxyBindRoutPlanner(SchemePortResolver schemePortResolver) {
        this(schemePortResolver, null);
    }

    public ProxyBindRoutPlanner(SchemePortResolver schemePortResolver, IpPool ipPool) {
        super(schemePortResolver);
        this.schemePortResolver = schemePortResolver;
        if (ipPool == null) {
            ipPool = IpPoolHolder.getIpPool();
        }
        this.ipPool = ipPool;
    }

    public SchemePortResolver getSchemePortResolver() {
        return this.schemePortResolver;
    }

    protected HttpHost determineProxy(HttpHost target, HttpRequest request, HttpContext context) throws HttpException {
        HttpClientContext httpClientContext = HttpClientContext.adapt((HttpContext)context);
        AvProxy bind = (AvProxy)context.getAttribute("USED_PROXY_KEY");
        String accessUrl = null;
        if (request instanceof HttpRequestWrapper || request instanceof HttpGet) {
            accessUrl = ((HttpUriRequest)HttpUriRequest.class.cast(request)).getURI().toString();
        }
        if (!PoolUtil.isDungProxyEnabled(httpClientContext)) {
            logger.info("{}\u4e0d\u4f1a\u88ab\u4ee3\u7406", (Object)accessUrl);
            return null;
        }
        if (bind == null || bind.isDisable()) {
            bind = this.ipPool.bind(target.getHostName(), accessUrl);
        }
        if (bind == null) {
            return null;
        }
        logger.info("{} \u5f53\u524d\u4f7f\u7528IP\u4e3a:{}:{}", new Object[]{target.getHostName(), bind.getIp(), bind.getPort()});
        bind.recordUsage();
        context.setAttribute("USED_PROXY_KEY", (Object)bind);
        if (bind.getAuthenticationHeaders() != null) {
            for (Header header : bind.getAuthenticationHeaders()) {
                request.addHeader(header);
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)bind.getUsername()) && StringUtils.isNotEmpty((CharSequence)bind.getPassword())) {
            BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
            httpClientContext.setCredentialsProvider((CredentialsProvider)credsProvider);
            credsProvider.setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(bind.getUsername(), bind.getPassword()));
        }
        return new HttpHost(bind.getIp(), bind.getPort().intValue());
    }
}

