/*
 * Decompiled with CFR 0.152.
 */
package com.virjar.dungproxy.client.httpclient.cookie;

import com.google.common.collect.Maps;
import com.virjar.dungproxy.client.httpclient.cookie.CookieStoreGenerator;
import java.util.Date;
import java.util.List;
import java.util.concurrent.ConcurrentMap;
import org.apache.http.client.CookieStore;
import org.apache.http.cookie.Cookie;
import org.apache.http.impl.client.BasicCookieStore;

public class MultiUserCookieStore
implements CookieStore {
    private static final String DEFAULT_USER = "DUNGPROXY_DEFAULT_USER";
    private ConcurrentMap<Object, CookieStore> cookieStores = Maps.newConcurrentMap();
    private CookieStoreGenerator cookieStoreGenerator;
    private static final MultiUserCookieStore defaultMultiUserCookieStore = new MultiUserCookieStore();

    public static MultiUserCookieStore getDefaultMultiUserCookieStore() {
        return defaultMultiUserCookieStore;
    }

    public MultiUserCookieStore() {
        this(null);
    }

    public MultiUserCookieStore(CookieStoreGenerator cookieStoreGenerator) {
        if (cookieStoreGenerator == null) {
            cookieStoreGenerator = new CookieStoreGenerator(){

                @Override
                public CookieStore generate(String user) {
                    return new BasicCookieStore();
                }
            };
        }
        this.cookieStoreGenerator = cookieStoreGenerator;
    }

    public void addCookie(Cookie cookie) {
        this.addCookie(cookie, null);
    }

    public List<Cookie> getCookies() {
        return this.getCookies(null);
    }

    public boolean clearExpired(Date date) {
        return this.clearExpired(date, null);
    }

    public void clear() {
        this.clear(null);
    }

    public void addCookie(Cookie cookie, String user) {
        this.createOrGetCookieStore(user).addCookie(cookie);
    }

    public List<Cookie> getCookies(String user) {
        return this.createOrGetCookieStore(user).getCookies();
    }

    public boolean clearExpired(Date date, String user) {
        return this.createOrGetCookieStore(user).clearExpired(date);
    }

    public void clear(String user) {
        this.createOrGetCookieStore(user).clear();
    }

    public void clearAllUser() {
        for (CookieStore cookieStore : this.cookieStores.values()) {
            cookieStore.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private CookieStore createOrGetCookieStore(String user) {
        CookieStore cookieStore;
        if (user == null) {
            user = DEFAULT_USER;
        }
        if ((cookieStore = (CookieStore)this.cookieStores.get(user)) != null) return cookieStore;
        Class<MultiUserCookieStore> clazz = MultiUserCookieStore.class;
        synchronized (MultiUserCookieStore.class) {
            cookieStore = (CookieStore)this.cookieStores.get(user);
            if (cookieStore != null) return cookieStore;
            this.cookieStores.put(user, this.cookieStoreGenerator.generate(user));
            return (CookieStore)this.cookieStores.get(user);
        }
    }
}

