/*
 * Decompiled with CFR 0.152.
 */
package com.virjar.dungproxy.client.ippool;

import java.util.Collection;
import java.util.LinkedList;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BlockLinkedList<T>
extends LinkedList<T> {
    private static Logger logger = LoggerFactory.getLogger(BlockLinkedList.class);
    private ReentrantLock lock = new ReentrantLock();
    private Condition condition = this.lock.newCondition();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyIfNotEmpty() {
        if (this.size() > 0 && this.size() < 3) {
            try {
                this.lock.lock();
                this.condition.signal();
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean add(T t) {
        this.lock.lock();
        try {
            boolean ret = super.add(t);
            this.notifyIfNotEmpty();
            boolean bl = ret;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(int index, T element) {
        this.lock.lock();
        try {
            super.add(index, element);
            this.notifyIfNotEmpty();
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addAll(Collection<? extends T> c) {
        this.lock.lock();
        try {
            boolean ret = super.addAll(c);
            this.notifyIfNotEmpty();
            boolean bl = ret;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addAll(int index, Collection<? extends T> c) {
        this.lock.lock();
        try {
            boolean ret = super.addAll(index, c);
            this.notifyIfNotEmpty();
            boolean bl = ret;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addFirst(T t) {
        this.lock.lock();
        try {
            super.addFirst(t);
            this.notifyIfNotEmpty();
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addLast(T t) {
        this.lock.lock();
        try {
            super.addLast(t);
            this.notifyIfNotEmpty();
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean offer(T t) {
        this.lock.lock();
        try {
            boolean ret = super.offer(t);
            this.notifyIfNotEmpty();
            boolean bl = ret;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean offerFirst(T t) {
        this.lock.lock();
        try {
            boolean ret = super.offerFirst(t);
            this.notifyIfNotEmpty();
            boolean bl = ret;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean offerLast(T t) {
        this.lock.lock();
        try {
            boolean ret = super.offerLast(t);
            this.notifyIfNotEmpty();
            boolean bl = ret;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T take(long time, TimeUnit timeUnit) {
        T t = this.poll();
        while (t == null) {
            try {
                this.lock.lock();
                try {
                    if (time <= 0L) {
                        this.condition.await();
                    } else {
                        this.condition.await(time, timeUnit);
                    }
                }
                catch (InterruptedException e) {
                    logger.error("error when await new element", (Throwable)e);
                    T t2 = null;
                    this.lock.unlock();
                    return t2;
                }
            }
            finally {
                this.lock.unlock();
            }
            t = this.poll();
        }
        return t;
    }

    public T take() {
        return this.take(0L, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T get(int index) {
        this.lock.lock();
        try {
            Object e = super.get(index);
            return (T)e;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T getFirst() {
        this.lock.lock();
        try {
            Object e = super.getFirst();
            return (T)e;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T getLast() {
        this.lock.lock();
        try {
            Object e = super.getLast();
            return (T)e;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T peek() {
        this.lock.lock();
        try {
            Object e = super.peek();
            return (T)e;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T peekFirst() {
        this.lock.lock();
        try {
            Object e = super.peekFirst();
            return (T)e;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T peekLast() {
        this.lock.lock();
        try {
            Object e = super.peekLast();
            return (T)e;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T poll() {
        this.lock.lock();
        try {
            Object e = super.poll();
            return (T)e;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T pollFirst() {
        this.lock.lock();
        try {
            Object e = super.pollFirst();
            return (T)e;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T pollLast() {
        this.lock.lock();
        try {
            Object e = super.pollLast();
            return (T)e;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T pop() {
        this.lock.lock();
        try {
            Object e = super.pop();
            return (T)e;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void push(T t) {
        this.lock.lock();
        try {
            super.push(t);
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T remove() {
        this.lock.lock();
        try {
            Object e = super.remove();
            return (T)e;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T remove(int index) {
        this.lock.lock();
        try {
            Object e = super.remove(index);
            return (T)e;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(Object o) {
        this.lock.lock();
        try {
            boolean bl = super.remove(o);
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T removeFirst() {
        this.lock.lock();
        try {
            Object e = super.removeFirst();
            return (T)e;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T removeLast() {
        this.lock.lock();
        try {
            Object e = super.removeLast();
            return (T)e;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeFirstOccurrence(Object o) {
        this.lock.lock();
        try {
            boolean bl = super.removeFirstOccurrence(o);
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeLastOccurrence(Object o) {
        this.lock.lock();
        try {
            boolean bl = super.removeLastOccurrence(o);
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T set(int index, T element) {
        this.lock.lock();
        try {
            T t = super.set(index, element);
            return t;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T element() {
        this.lock.lock();
        try {
            Object e = super.element();
            return (T)e;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        this.lock.lock();
        try {
            super.clear();
        }
        finally {
            this.lock.unlock();
        }
    }
}

