/*
 * Decompiled with CFR 0.152.
 */
package com.virjar.dungproxy.client.ippool;

import com.alibaba.fastjson.JSONObject;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.virjar.dungproxy.client.ippool.SmartProxyQueue;
import com.virjar.dungproxy.client.ippool.config.DomainContext;
import com.virjar.dungproxy.client.ippool.strategy.ResourceFacade;
import com.virjar.dungproxy.client.model.AvProxy;
import com.virjar.dungproxy.client.model.AvProxyVO;
import com.virjar.dungproxy.client.ningclient.concurrent.NamedThreadFactory;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DomainPool {
    private String domain;
    private ResourceFacade resourceFacade;
    private int coreSize = 50;
    private List<String> testUrls = Lists.newArrayList();
    private Random random = new Random(System.currentTimeMillis());
    private SmartProxyQueue smartProxyQueue;
    private List<AvProxy> removedProxies = Lists.newArrayList();
    private List<AvProxy> blockedProxies = Lists.newLinkedList();
    private ConcurrentLinkedQueue<AvProxyVO> candidateProxies = new ConcurrentLinkedQueue();
    private AtomicBoolean isCandidateProxiesDownloading = new AtomicBoolean(false);
    private volatile long lastIpImportTimeStamp = 0L;
    private static final Logger logger = LoggerFactory.getLogger(DomainPool.class);
    private AtomicInteger refreshTaskNumber = new AtomicInteger(0);
    private static ThreadPoolExecutor threadPool = new ThreadPoolExecutor(5, 25, 5L, TimeUnit.MINUTES, new LinkedBlockingDeque<Runnable>(), new NamedThreadFactory("ip-refresh"), new ThreadPoolExecutor.DiscardPolicy());
    private DomainContext domainContext;

    public DomainContext getDomainContext() {
        return this.domainContext;
    }

    public DomainPool(String domain, DomainContext domainContext) {
        List<? extends AvProxy> avProxies;
        this.domain = domain;
        this.resourceFacade = domainContext.getResourceFacade();
        this.domainContext = domainContext;
        this.coreSize = domainContext.getCoreSize();
        this.smartProxyQueue = new SmartProxyQueue(domainContext.getSmartProxyQueueRatio(), domainContext.getUseInterval());
        for (AvProxyVO cloudProxy : domainContext.getDungProxyContext().getCloudProxies()) {
            if (cloudProxy.getPartnerSize() == null || cloudProxy.getPartnerSize() < 1 || !cloudProxy.getCloud().booleanValue()) {
                this.addAvailable(cloudProxy.toModel(this));
                continue;
            }
            avProxies = cloudProxy.toPartnerModels(domainContext);
            for (AvProxy avProxy : avProxies) {
                this.addAvailable(avProxy);
            }
        }
        for (AvProxyVO defaultProxy : domainContext.getDefaultProxy()) {
            if (defaultProxy.getPartnerSize() == null || defaultProxy.getPartnerSize() < 1 || !defaultProxy.getCloud().booleanValue()) {
                this.addAvailable(defaultProxy.toModel(this));
                continue;
            }
            avProxies = defaultProxy.toPartnerModels(domainContext);
            for (AvProxy avProxy : avProxies) {
                this.addAvailable(avProxy);
            }
        }
    }

    public void addAvailable(Collection<AvProxy> avProxyList) {
        for (AvProxy avProxy : avProxyList) {
            avProxy.setDomainPool(this);
            this.smartProxyQueue.addWithScore(avProxy);
        }
    }

    public void addAvailable(AvProxy avProxy) {
        avProxy.setDomainPool(this);
        this.smartProxyQueue.addWithScore(avProxy);
    }

    public List<AvProxy> availableProxy() {
        return Lists.newArrayList(this.smartProxyQueue.values());
    }

    public AvProxy bind(String url) {
        if (StringUtils.isNotEmpty((CharSequence)url)) {
            if (this.testUrls.size() < 10) {
                this.testUrls.add(url);
            } else {
                this.testUrls.set(this.random.nextInt(10), url);
            }
        }
        if (this.needFresh()) {
            this.refresh();
        }
        return this.smartProxyQueue.getAndAdjustPriority((double)this.smartProxyQueue.availableSize() * this.smartProxyQueue.getRatio() <= 2.0, this.domainContext.getDungProxyContext().isWaitIfNoAvailableProxy());
    }

    public boolean needFresh() {
        if (this.smartProxyQueue.availableSize() < this.coreSize) {
            this.smartProxyQueue.recoveryBlockedProxy();
        }
        return this.smartProxyQueue.availableSize() < this.coreSize;
    }

    private int expectedRefreshTaskNumber() {
        if (this.smartProxyQueue.availableSize() >= this.coreSize) {
            return 0;
        }
        int threadNumber = (this.coreSize - this.smartProxyQueue.availableSize()) * 10 / this.coreSize;
        if (threadNumber == 0) {
            threadNumber = 1;
        }
        return threadNumber;
    }

    public void feedBack() {
        this.resourceFacade.feedBack(this.domain, Lists.transform((List)Lists.newArrayList(this.smartProxyQueue.values()), (Function)new Function<AvProxy, AvProxyVO>(){

            public AvProxyVO apply(AvProxy input) {
                return AvProxyVO.fromModel(input);
            }
        }), Lists.transform(this.removedProxies, (Function)new Function<AvProxy, AvProxyVO>(){

            public AvProxyVO apply(AvProxy input) {
                return AvProxyVO.fromModel(input);
            }
        }));
        this.removedProxies.clear();
    }

    public void refresh() {
        if (this.testUrls.size() == 0) {
            return;
        }
        int expectedThreadNumber = this.expectedRefreshTaskNumber();
        if (this.refreshTaskNumber.get() > expectedThreadNumber) {
            return;
        }
        if (this.refreshTaskNumber.incrementAndGet() <= expectedThreadNumber) {
            threadPool.execute(new RefreshThread());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkAndExtendCandidateResource() {
        if (System.currentTimeMillis() - this.lastIpImportTimeStamp < 120000L) {
            return;
        }
        if ((double)(this.candidateProxies.size() + this.smartProxyQueue.availableSize()) > (double)this.coreSize * 1.5) {
            return;
        }
        if (this.isCandidateProxiesDownloading.compareAndSet(false, true)) {
            try {
                List<AvProxyVO> avProxies = this.resourceFacade.importProxy(this.domain, this.testUrls.get(this.random.nextInt(this.testUrls.size())), this.coreSize);
                logger.info("\u5728\u7ebfIP\u5237\u65b0,\u5f53\u524d\u4e0b\u8f7d\u5230\u7684IP\u6570\u76ee\u4e3a:{}", (Object)avProxies.size());
                this.candidateProxies.addAll(avProxies);
            }
            finally {
                this.lastIpImportTimeStamp = System.currentTimeMillis();
                this.isCandidateProxiesDownloading.set(false);
            }
        }
    }

    private void doRefresh() {
        AvProxyVO avProxy;
        this.checkAndExtendCandidateResource();
        while ((avProxy = this.candidateProxies.poll()) != null) {
            if (!this.domainContext.getProxyChecker().available(avProxy, this.testUrls.get(this.random.nextInt(this.testUrls.size())))) continue;
            avProxy.setAvgScore(0.5);
            this.addAvailable(avProxy.toModel(this.domainContext));
            logger.info("IP\u6c60{}\u5f53\u524d\u53ef\u7528IP\u6570\u76ee:{}", (Object)this.domain, (Object)this.smartProxyQueue.availableSize());
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DomainPool that = (DomainPool)o;
        return this.domain.equals(that.domain);
    }

    public int hashCode() {
        return (this.domain + "?/").hashCode();
    }

    public synchronized void block(AvProxy avProxy, long duration) {
        AvProxy next;
        Iterator<AvProxy> iterator = this.blockedProxies.iterator();
        while (iterator.hasNext() && (next = iterator.next()).getResueTime() <= System.currentTimeMillis()) {
            iterator.remove();
            this.addAvailable(next);
        }
        Preconditions.checkArgument((duration > 0L ? 1 : 0) != 0, (Object)" block duration must greater than zero");
        this.smartProxyQueue.offline(avProxy);
        avProxy.setResueTime(System.currentTimeMillis() + duration);
        this.blockedProxies.add(avProxy);
        logger.info("IP:{}\u6682\u65f6\u5c01\u7981,\u5c01\u7981\u65f6\u95f4:{} \u6beb\u79d2", (Object)JSONObject.toJSONString((Object)AvProxyVO.fromModel(avProxy)), (Object)duration);
    }

    public void offline(AvProxy avProxy) {
        this.smartProxyQueue.offline(avProxy);
        this.removedProxies.add(avProxy);
        if (avProxy.getReferCount() != 0) {
            logger.warn("IP offline {}", (Object)JSONObject.toJSONString((Object)AvProxyVO.fromModel(avProxy)));
        }
    }

    public String getDomain() {
        return this.domain;
    }

    public ResourceFacade getResourceFacade() {
        return this.resourceFacade;
    }

    public void adjustPriority(AvProxy avProxy) {
        this.smartProxyQueue.adjustPriority(avProxy);
    }

    public int getCoreSize() {
        return this.coreSize;
    }

    public void setCoreSize(int coreSize) {
        this.coreSize = coreSize;
    }

    public List<String> getTestUrls() {
        return this.testUrls;
    }

    public SmartProxyQueue getSmartProxyQueue() {
        return this.smartProxyQueue;
    }

    public boolean isRefreshing() {
        return this.refreshTaskNumber.get() > 0;
    }

    private class RefreshThread
    implements Runnable {
        private RefreshThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                logger.info("IP\u8d44\u6e90\u5237\u65b0\u5f00\u59cb,\u5f53\u524d\u5237\u65b0\u7ebf\u7a0b\u6570\u91cf:{}...", (Object)DomainPool.this.refreshTaskNumber.get());
                DomainPool.this.doRefresh();
                logger.info("IP\u8d44\u6e90\u5237\u65b0\u7ed3\u675f...");
            }
            finally {
                DomainPool.this.refreshTaskNumber.decrementAndGet();
            }
        }
    }
}

