/*
 * Decompiled with CFR 0.152.
 */
package com.virjar.dungproxy.client.ippool;

import com.google.common.base.Optional;
import com.google.common.base.Splitter;
import com.google.common.collect.Maps;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GroupBindRouter {
    private Logger logger = LoggerFactory.getLogger(GroupBindRouter.class);
    private Map<String, Optional<String>> routeData = Maps.newConcurrentMap();
    private Map<String, String> routeRule = Maps.newConcurrentMap();

    public void buildRule(String rule) {
        if (!StringUtils.contains((CharSequence)rule, (CharSequence)":")) {
            throw new IllegalArgumentException("domain:similarDomain1,similarDomain2,similarDomain3,similarDomain4  \":\" is lost");
        }
        String[] split = rule.split(":");
        String keyDomain = split[0];
        String similarDomainList = split[1];
        for (String similarDomain : Splitter.on((String)",").trimResults().split((CharSequence)similarDomainList)) {
            if (similarDomain.equals(keyDomain)) continue;
            this.routeRule.put(similarDomain, keyDomain);
        }
    }

    public void buildCombinationRule(String combinationRule) {
        if (StringUtils.isEmpty((CharSequence)combinationRule)) {
            return;
        }
        for (String rule : Splitter.on((String)";").split((CharSequence)combinationRule)) {
            this.buildRule(rule);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public String routeDomain(String similarDomain) {
        Optional<String> s = this.routeData.get(similarDomain);
        if (s == null) {
            Class<GroupBindRouter> clazz = GroupBindRouter.class;
            // MONITORENTER : com.virjar.dungproxy.client.ippool.GroupBindRouter.class
            s = this.routeData.get(similarDomain);
            if (s == null) {
                this.matchSimilarDomain(similarDomain);
                s = this.routeData.get(similarDomain);
            }
            // MONITOREXIT : clazz
        }
        if (!s.isPresent()) return similarDomain;
        String routedDomain = (String)s.get();
        this.logger.info("\u57df\u540d:{} \u7684\u4ee3\u7406\u89c4\u5219\u8def\u7531\u5230:{}", (Object)similarDomain, (Object)routedDomain);
        return routedDomain;
    }

    private void matchSimilarDomain(String similarDomain) {
        for (String pattern : this.routeRule.keySet()) {
            if (!pattern.equals(similarDomain) && !similarDomain.matches(pattern)) continue;
            this.routeData.put(similarDomain, (Optional<String>)Optional.of((Object)this.routeRule.get(pattern)));
            return;
        }
        this.routeData.put(similarDomain, (Optional<String>)Optional.absent());
    }

    public int ruleSize() {
        return this.routeRule.size();
    }
}

