/*
 * Decompiled with CFR 0.152.
 */
package com.virjar.dungproxy.client.ippool;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.virjar.dungproxy.client.ippool.DomainPool;
import com.virjar.dungproxy.client.ippool.GroupBindRouter;
import com.virjar.dungproxy.client.ippool.IpPoolHolder;
import com.virjar.dungproxy.client.ippool.config.DungProxyContext;
import com.virjar.dungproxy.client.ippool.exception.PoolDestroyException;
import com.virjar.dungproxy.client.ippool.strategy.AvProxyDumper;
import com.virjar.dungproxy.client.ippool.strategy.ProxyDomainStrategy;
import com.virjar.dungproxy.client.ippool.strategy.impl.ProxyAllStrategy;
import com.virjar.dungproxy.client.model.AvProxy;
import com.virjar.dungproxy.client.model.AvProxyVO;
import com.virjar.dungproxy.client.util.CommonUtil;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IpPool {
    private Logger logger = LoggerFactory.getLogger(IpPool.class);
    private Map<String, DomainPool> pool = Maps.newConcurrentMap();
    private volatile boolean isRunning = false;
    private GroupBindRouter groupBindRouter;
    private DungProxyContext dungProxyContext;
    private AvProxyDumper avProxyDumper;
    private ProxyDomainStrategy proxyDomainStrategy;

    private IpPool(DungProxyContext dungProxyContext) {
        this.dungProxyContext = dungProxyContext;
        this.init();
    }

    private void init() {
        this.groupBindRouter = this.dungProxyContext.getGroupBindRouter();
        this.proxyDomainStrategy = this.dungProxyContext.getNeedProxyStrategy();
        this.avProxyDumper = this.dungProxyContext.getAvProxyDumper();
        if (this.proxyDomainStrategy instanceof ProxyAllStrategy && this.groupBindRouter.ruleSize() == 0) {
            this.groupBindRouter.buildRule("www.virjar.com:.*");
        }
        this.isRunning = true;
        this.unSerialize();
        FeedBackThread feedBackThread = new FeedBackThread();
        feedBackThread.setDaemon(true);
        feedBackThread.start();
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                if (IpPool.this.isRunning) {
                    IpPool.this.destroy();
                }
            }
        });
    }

    public static IpPool getInstance() {
        return IpPoolHolder.getIpPool();
    }

    public static IpPool create(DungProxyContext dungProxyContext) {
        dungProxyContext.handleConfig();
        return new IpPool(dungProxyContext);
    }

    public void destroy() {
        this.isRunning = false;
        this.avProxyDumper.serializeProxy(Maps.transformValues(this.getPoolInfo(), (Function)new Function<List<AvProxy>, List<AvProxyVO>>(){

            public List<AvProxyVO> apply(List<AvProxy> input) {
                return Lists.transform(input, (Function)new Function<AvProxy, AvProxyVO>(){

                    public AvProxyVO apply(AvProxy input) {
                        return AvProxyVO.fromModel(input);
                    }
                });
            }
        }));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unSerialize() {
        AvProxy.needRecordChange = false;
        try {
            Map<String, List<AvProxyVO>> stringListMap = this.avProxyDumper.unSerializeProxy();
            if (stringListMap == null) {
                return;
            }
            for (final Map.Entry<String, List<AvProxyVO>> entry : stringListMap.entrySet()) {
                List proxies = Lists.transform(entry.getValue(), (Function)new Function<AvProxyVO, AvProxy>(){

                    public AvProxy apply(AvProxyVO input) {
                        return input.toModel(IpPool.this.dungProxyContext.genDomainContext((String)entry.getKey()));
                    }
                });
                if (this.pool.containsKey(entry.getKey())) {
                    this.pool.get(entry.getKey()).addAvailable(proxies);
                    continue;
                }
                this.pool.put(entry.getKey(), new DomainPool(entry.getKey(), this.dungProxyContext.genDomainContext(entry.getKey())));
                this.pool.get(entry.getKey()).addAvailable(proxies);
            }
        }
        finally {
            AvProxy.needRecordChange = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AvProxy bind(String host, String url) {
        AvProxy bind;
        if (!this.dungProxyContext.isPoolEnabled()) {
            return null;
        }
        if (!this.isRunning) {
            throw new PoolDestroyException("IP\u6c60\u5df2\u7ecf\u88ab\u9500\u6bc1,\u4e0d\u80fd\u63d0\u4f9bIP\u670d\u52a1");
        }
        if (!this.proxyDomainStrategy.needProxy(host = this.groupBindRouter.routeDomain(host))) {
            this.logger.info("\u57df\u540d:{}\u6ca1\u6709\u88ab\u4ee3\u7406", (Object)host);
            return null;
        }
        if (!this.pool.containsKey(host)) {
            IpPool ipPool = this;
            synchronized (ipPool) {
                if (!this.pool.containsKey(host)) {
                    this.pool.put(host, new DomainPool(host, this.dungProxyContext.genDomainContext(host)));
                }
            }
        }
        if ((bind = this.pool.get(host).bind(url)) == null) {
            this.logger.warn("IP\u6c60\u4e2d,\u57df\u540d:{} \u6682\u65f6\u6ca1\u6709IP", (Object)host);
        }
        return bind;
    }

    public Map<String, List<AvProxy>> getPoolInfo() {
        return Maps.transformValues(this.pool, (Function)new Function<DomainPool, List<AvProxy>>(){

            public List<AvProxy> apply(DomainPool domainPool) {
                return domainPool.availableProxy();
            }
        });
    }

    public int totalDomain() {
        return this.pool.size();
    }

    public Map<String, DomainPool> getPool() {
        return this.pool;
    }

    private class FreshResourceThread
    extends Thread {
        private FreshResourceThread() {
        }

        @Override
        public void run() {
            while (IpPool.this.isRunning) {
                for (DomainPool domainPool : IpPool.this.pool.values()) {
                    try {
                        if (!domainPool.needFresh()) continue;
                        domainPool.refresh();
                    }
                    catch (Exception e) {
                        IpPool.this.logger.error("error when refresh ip pool for domain:{}", (Object)domainPool.getDomain(), (Object)e);
                    }
                }
                CommonUtil.sleep(4000L);
            }
        }
    }

    private class FeedBackThread
    extends Thread {
        private FeedBackThread() {
        }

        @Override
        public void run() {
            while (IpPool.this.isRunning) {
                CommonUtil.sleep(IpPool.this.dungProxyContext.getFeedBackDuration());
                for (DomainPool domainPool : IpPool.this.pool.values()) {
                    try {
                        domainPool.feedBack();
                    }
                    catch (Exception e) {
                        IpPool.this.logger.error("ip feedBack error for domain:{}", (Object)domainPool.getDomain(), (Object)e);
                    }
                }
            }
        }
    }
}

