/*
 * Decompiled with CFR 0.152.
 */
package com.virjar.dungproxy.client.ippool;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.virjar.dungproxy.client.ippool.DomainPool;
import com.virjar.dungproxy.client.ippool.config.DungProxyContext;
import com.virjar.dungproxy.client.ippool.config.ObjectFactory;
import com.virjar.dungproxy.client.ippool.strategy.ProxyChecker;
import com.virjar.dungproxy.client.ippool.strategy.ResourceFacade;
import com.virjar.dungproxy.client.model.AvProxy;
import com.virjar.dungproxy.client.model.AvProxyVO;
import com.virjar.dungproxy.client.util.CommonUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PreHeater {
    private static final Logger logger = LoggerFactory.getLogger(PreHeater.class);
    private Set<String> taskUrls = Sets.newConcurrentHashSet();
    private int threadNumber = 40;
    private ExecutorService pool;
    private AtomicBoolean hasInit = new AtomicBoolean(false);
    private Map<String, DomainPool> stringDomainPoolMap;
    private AtomicLong passedProxyNumber = new AtomicLong(0L);
    private AtomicBoolean isRunning = new AtomicBoolean(false);
    private DungProxyContext dungProxyContext;

    public PreHeater(DungProxyContext dungProxyContext) {
        this.dungProxyContext = dungProxyContext;
    }

    public static void main(String[] args) {
        PreHeater.start();
    }

    public static void start() {
        PreHeater preHeater = DungProxyContext.create().buildDefaultConfigFile().handleConfig().getPreHeater();
        preHeater.doPreHeat();
        preHeater.destroy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init() {
        if (this.hasInit.compareAndSet(false, true)) {
            this.pool = Executors.newFixedThreadPool(this.threadNumber);
            this.isRunning.set(true);
            AvProxy.needRecordChange = false;
            try {
                this.unSerialize();
            }
            finally {
                AvProxy.needRecordChange = true;
            }
        }
    }

    public void destroy() {
        this.isRunning.set(false);
        this.pool.shutdown();
    }

    public PreHeater addTask(String url) {
        if (!url.startsWith("http")) {
            url = "http://" + url;
        }
        this.taskUrls.add(url);
        return this;
    }

    public synchronized void doPreHeat() {
        AvProxy.needRecordChange = false;
        if (this.taskUrls.size() == 0) {
            logger.warn("preHeater task is empty");
            return;
        }
        if (!this.hasInit.get()) {
            this.init();
        }
        logger.info("\u5f85\u6d4b\u8bd5\u4efb\u52a1:{}", (Object)JSONArray.toJSONString(this.taskUrls));
        Map<String, String> urlMap = this.transformDomainUrlMap(this.taskUrls);
        ArrayList futureList = Lists.newArrayList();
        ResourceFacade resourceFacade = ObjectFactory.newInstance(this.dungProxyContext.getDefaultResourceFacade());
        logger.info("\u4e0b\u8f7d\u53ef\u7528IP...");
        List<AvProxyVO> candidateProxies = resourceFacade.allAvailable();
        logger.info("\u603b\u5171\u4e0b\u8f7d\u5230{}\u4e2aIP\u8d44\u6e90", (Object)candidateProxies.size());
        for (Map.Entry<String, DomainPool> entry : this.stringDomainPoolMap.entrySet()) {
            if (!urlMap.containsKey(entry.getKey())) continue;
            Iterator<AvProxy> iterator = entry.getValue().availableProxy().iterator();
            while (iterator.hasNext()) {
                AvProxy avProxy = iterator.next();
                futureList.add(this.pool.submit(new UrlCheckTask(AvProxyVO.fromModel(avProxy), urlMap.get(entry.getKey()))));
                iterator.remove();
            }
        }
        for (AvProxyVO avProxy : candidateProxies) {
            for (String url : this.taskUrls) {
                futureList.add(this.pool.submit(new UrlCheckTask(avProxy, url)));
            }
        }
        CommonUtil.waitAllFutures(futureList);
        this.dungProxyContext.getAvProxyDumper().serializeProxy(this.getPoolInfo(this.stringDomainPoolMap));
    }

    private Map<String, String> transformDomainUrlMap(Collection<String> testUrls) {
        HashMap ret = Maps.newHashMap();
        for (String url : testUrls) {
            ret.put(CommonUtil.extractDomain(url), url);
        }
        return ret;
    }

    public PreHeater setThreadNumber(int threadNumber) {
        if (threadNumber < 1) {
            threadNumber = 1;
        }
        this.threadNumber = threadNumber;
        return this;
    }

    private void unSerialize() {
        ConcurrentMap pool;
        this.stringDomainPoolMap = pool = Maps.newConcurrentMap();
        Map<String, List<AvProxyVO>> stringListMap = this.dungProxyContext.getAvProxyDumper().unSerializeProxy();
        if (stringListMap == null) {
            return;
        }
        for (final Map.Entry<String, List<AvProxyVO>> entry : stringListMap.entrySet()) {
            List avProxies = Lists.transform(entry.getValue(), (Function)new Function<AvProxyVO, AvProxy>(){

                public AvProxy apply(AvProxyVO input) {
                    return input.toModel(PreHeater.this.dungProxyContext.genDomainContext((String)entry.getKey()));
                }
            });
            if (!pool.containsKey(entry.getKey())) {
                pool.put(entry.getKey(), new DomainPool(entry.getKey(), this.dungProxyContext.genDomainContext(entry.getKey())));
            }
            ((DomainPool)pool.get(entry.getKey())).addAvailable(avProxies);
        }
        this.stringDomainPoolMap = pool;
    }

    private Map<String, List<AvProxyVO>> getPoolInfo(Map<String, DomainPool> pool) {
        return Maps.transformValues(pool, (Function)new Function<DomainPool, List<AvProxyVO>>(){

            public List<AvProxyVO> apply(DomainPool domainPool) {
                return Lists.transform(domainPool.availableProxy(), (Function)new Function<AvProxy, AvProxyVO>(){

                    public AvProxyVO apply(AvProxy input) {
                        return AvProxyVO.fromModel(input);
                    }
                });
            }
        });
    }

    private class UrlCheckTask
    implements Callable<Boolean> {
        String url;
        AvProxyVO proxy;

        UrlCheckTask(AvProxyVO proxy, String url) {
            this.proxy = proxy;
            this.url = url;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        @Override
        public Boolean call() throws Exception {
            ProxyChecker proxyChecker;
            String domain = CommonUtil.extractDomain(this.url);
            domain = PreHeater.this.dungProxyContext.getGroupBindRouter().routeDomain(domain);
            DomainPool domainPool = (DomainPool)PreHeater.this.stringDomainPoolMap.get(domain);
            if (domainPool == null) {
                Class<UrlCheckTask> clazz = UrlCheckTask.class;
                // MONITORENTER : com.virjar.dungproxy.client.ippool.PreHeater$UrlCheckTask.class
                domainPool = (DomainPool)PreHeater.this.stringDomainPoolMap.get(domain);
                if (domainPool == null) {
                    domainPool = new DomainPool(domain, PreHeater.this.dungProxyContext.genDomainContext(domain));
                    PreHeater.this.stringDomainPoolMap.put(domain, domainPool);
                }
                // MONITOREXIT : clazz
            }
            if (!(proxyChecker = PreHeater.this.dungProxyContext.genDomainContext(domain).getProxyChecker()).available(this.proxy, this.url)) return false;
            domainPool.addAvailable(this.proxy.toModel(domainPool));
            logger.info("preHeater available test passed for proxy:{} for url:{}", (Object)JSONObject.toJSONString((Object)this.proxy), (Object)this.url);
            if (PreHeater.this.passedProxyNumber.incrementAndGet() % PreHeater.this.dungProxyContext.getSerializeStep() != 0L) return true;
            PreHeater.this.dungProxyContext.getAvProxyDumper().serializeProxy(PreHeater.this.getPoolInfo(PreHeater.this.stringDomainPoolMap));
            return true;
        }
    }
}

