/*
 * Decompiled with CFR 0.152.
 */
package com.virjar.dungproxy.client.ippool;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.virjar.dungproxy.client.ippool.BlockLinkedList;
import com.virjar.dungproxy.client.model.AvProxy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SmartProxyQueue {
    private static final Logger logger = LoggerFactory.getLogger(SmartProxyQueue.class);
    private double ratio;
    private long useInterval = 0L;
    private BlockLinkedList<AvProxy> proxies = new BlockLinkedList();
    private Set<AvProxy> consistentBuckets = Sets.newConcurrentHashSet();
    private LinkedList<AvProxy> blockedProxies = Lists.newLinkedList();
    private ReentrantLock reentrantLock = new ReentrantLock();

    public SmartProxyQueue(double ratio, long useInterval) {
        if (ratio < 0.0 || ratio > 1.0) {
            throw new IllegalStateException("ratio for SmartProxyQueue need between 0 and 1");
        }
        this.useInterval = useInterval;
        this.ratio = ratio;
    }

    public void addAllProxy(Collection<AvProxy> avProxies) {
        for (AvProxy avProxy : avProxies) {
            this.addWithScore(avProxy);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addWithScore(AvProxy avProxy) {
        this.checkScore(avProxy.getAvgScore());
        if (this.consistentBuckets.contains(avProxy)) {
            return;
        }
        int index = (int)((double)this.proxies.size() * (this.ratio + (1.0 - this.ratio) * (1.0 - avProxy.getAvgScore())));
        this.proxies.add(index, avProxy);
        this.reentrantLock.lock();
        try {
            this.consistentBuckets.add(avProxy);
        }
        finally {
            this.reentrantLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AvProxy getAndAdjustPriority(boolean adjustTail, boolean waitIfNoProxy) {
        boolean hasBlock = false;
        try {
            AvProxy poll;
            while (true) {
                if ((poll = waitIfNoProxy ? this.proxies.take() : this.proxies.poll()) == null) {
                    AvProxy avProxy = null;
                    return avProxy;
                }
                if (System.currentTimeMillis() - poll.getLastUsedTime() >= this.useInterval) break;
                hasBlock = true;
                this.reentrantLock.lock();
                try {
                    this.blockedProxies.addLast(poll);
                }
                finally {
                    this.reentrantLock.unlock();
                }
                logger.info("IP:{}\u4f7f\u7528\u5c0f\u4e8e\u89c4\u5b9a\u65f6\u95f4\u95f4\u9694{}\u79d2,\u6682\u65f6\u5c01\u7981", (Object)poll.getIp(), (Object)(this.useInterval / 1000L));
            }
            int index = this.proxies.size();
            if (!adjustTail) {
                index = (int)((double)this.proxies.size() * this.ratio);
            }
            this.proxies.add(index, poll);
            AvProxy avProxy = poll;
            return avProxy;
        }
        finally {
            if (hasBlock) {
                this.recoveryBlockedProxy();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recoveryBlockedProxy() {
        if (this.blockedProxies.size() == 0) {
            return;
        }
        int recoveredNumber = 0;
        ArrayList recoveryProxies = Lists.newArrayList();
        this.reentrantLock.lock();
        try {
            Iterator iterator = this.blockedProxies.iterator();
            while (iterator.hasNext()) {
                AvProxy next = (AvProxy)iterator.next();
                if (System.currentTimeMillis() - next.getLastUsedTime() <= this.useInterval) continue;
                recoveryProxies.add(next);
                iterator.remove();
                ++recoveredNumber;
            }
        }
        finally {
            this.reentrantLock.unlock();
        }
        this.proxies.addAll(recoveryProxies);
        logger.info("\u672c\u6b21IP\u89e3\u7981\u6570\u76ee\u4e3a:{}", (Object)recoveredNumber);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void adjustPriority(AvProxy avProxy) {
        if (!this.consistentBuckets.contains(avProxy)) {
            return;
        }
        if (!this.proxies.remove(avProxy)) {
            try {
                this.reentrantLock.lock();
                this.blockedProxies.remove(avProxy);
            }
            finally {
                this.reentrantLock.unlock();
            }
        }
        this.reentrantLock.lock();
        try {
            this.consistentBuckets.remove(avProxy);
        }
        finally {
            this.reentrantLock.unlock();
        }
        this.addWithScore(avProxy);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void offline(AvProxy avProxy) {
        if (!this.proxies.remove(avProxy)) {
            this.reentrantLock.lock();
            try {
                this.blockedProxies.remove(avProxy);
            }
            finally {
                this.reentrantLock.unlock();
            }
        }
        try {
            this.reentrantLock.lock();
            this.consistentBuckets.remove(avProxy);
        }
        finally {
            this.reentrantLock.unlock();
        }
    }

    public void offlineWithScore(double score) {
        this.checkScore(score);
        AvProxy last = this.proxies.getLast();
        while (last != null && last.getAvgScore() < score) {
            last.offline();
            last = this.proxies.getLast();
        }
        last = this.proxies.getLast();
        while (last != null && last.getAvgScore() < score) {
            last.offline();
            last = this.proxies.getLast();
        }
    }

    private void checkScore(double score) {
        if (score < 0.0 || score > 1.0) {
            throw new IllegalStateException("avgScore for a AvProxy need between 0 and 1");
        }
    }

    public Iterator<? extends AvProxy> values() {
        return new ProxyQueueIterator();
    }

    public int availableSize() {
        return this.proxies.size();
    }

    public int allSize() {
        return this.proxies.size() + this.blockedProxies.size();
    }

    @Deprecated
    public AvProxy hint(int hash) {
        return null;
    }

    public double getRatio() {
        return this.ratio;
    }

    private class ProxyQueueIterator
    implements Iterator<AvProxy> {
        Iterator<AvProxy> activedProxies;
        Iterator<AvProxy> blockedProxiesIterator;
        boolean firstCollection;

        private ProxyQueueIterator() {
            this.activedProxies = SmartProxyQueue.this.proxies.iterator();
            this.blockedProxiesIterator = SmartProxyQueue.this.blockedProxies.iterator();
            this.firstCollection = true;
        }

        @Override
        public boolean hasNext() {
            if (!this.firstCollection) {
                return this.blockedProxiesIterator.hasNext();
            }
            if (this.activedProxies.hasNext()) {
                return true;
            }
            this.firstCollection = false;
            return this.blockedProxiesIterator.hasNext();
        }

        @Override
        public AvProxy next() {
            if (this.firstCollection) {
                return this.activedProxies.next();
            }
            return this.blockedProxiesIterator.next();
        }

        @Override
        public void remove() {
            if (this.firstCollection) {
                this.activedProxies.remove();
            } else {
                this.blockedProxiesIterator.remove();
            }
        }
    }
}

