/*
 * Decompiled with CFR 0.152.
 */
package com.virjar.dungproxy.client.ippool.config;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.virjar.dungproxy.client.ippool.config.DungProxyContext;
import com.virjar.dungproxy.client.ippool.config.ObjectFactory;
import com.virjar.dungproxy.client.ippool.strategy.Offline;
import com.virjar.dungproxy.client.ippool.strategy.ProxyChecker;
import com.virjar.dungproxy.client.ippool.strategy.ResourceFacade;
import com.virjar.dungproxy.client.ippool.strategy.Scoring;
import com.virjar.dungproxy.client.model.AvProxyVO;
import java.util.List;

public class DomainContext {
    private DungProxyContext dungProxyContext;
    private ResourceFacade resourceFacade;
    private Scoring scoring;
    private Offline offline;
    private ProxyChecker proxyChecker;
    private int coreSize;
    private double smartProxyQueueRatio;
    private long useInterval;
    private String domain;
    private int scoreFactory;
    private List<AvProxyVO> defaultProxy;

    DomainContext(String domain) {
        this.domain = domain;
    }

    public int getCoreSize() {
        return this.coreSize;
    }

    public DomainContext setCoreSize(int coreSize) {
        Preconditions.checkArgument((coreSize > 0 ? 1 : 0) != 0, (Object)"domain pool core size must greater zero");
        this.coreSize = coreSize;
        return this;
    }

    public DungProxyContext getDungProxyContext() {
        return this.dungProxyContext;
    }

    public DomainContext setDungProxyContext(DungProxyContext dungProxyContext) {
        this.dungProxyContext = dungProxyContext;
        return this;
    }

    public ResourceFacade getResourceFacade() {
        return this.resourceFacade;
    }

    public DomainContext setResourceFacade(ResourceFacade resourceFacade) {
        this.resourceFacade = resourceFacade;
        return this;
    }

    public double getSmartProxyQueueRatio() {
        return this.smartProxyQueueRatio;
    }

    public DomainContext setSmartProxyQueueRatio(double smartProxyQueueRatio) {
        this.smartProxyQueueRatio = smartProxyQueueRatio;
        return this;
    }

    public long getUseInterval() {
        return this.useInterval;
    }

    public DomainContext setUseInterval(long useInterval) {
        Preconditions.checkArgument((useInterval > 0L ? 1 : 0) != 0, (Object)"useInterval must greater zero");
        this.useInterval = useInterval;
        return this;
    }

    public String getDomain() {
        return this.domain;
    }

    public static DomainContext create(String domain) {
        Preconditions.checkNotNull((Object)domain);
        return new DomainContext(domain);
    }

    public Offline getOffline() {
        return this.offline;
    }

    public DomainContext setOffline(Offline offline) {
        this.offline = offline;
        return this;
    }

    public Scoring getScoring() {
        return this.scoring;
    }

    public DomainContext setScoring(Scoring scoring) {
        this.scoring = scoring;
        return this;
    }

    public int getScoreFactory() {
        return this.scoreFactory;
    }

    public DomainContext setScoreFactory(int scoreFactory) {
        Preconditions.checkArgument((scoreFactory > 0 ? 1 : 0) != 0, (Object)"scoreFactory must greater than zero");
        this.scoreFactory = scoreFactory;
        return this;
    }

    public ProxyChecker getProxyChecker() {
        return this.proxyChecker;
    }

    public DomainContext setProxyChecker(ProxyChecker proxyChecker) {
        this.proxyChecker = proxyChecker;
        return this;
    }

    public List<AvProxyVO> getDefaultProxy() {
        return this.defaultProxy;
    }

    public DomainContext setDefaultProxy(List<AvProxyVO> defaultProxy) {
        this.defaultProxy = defaultProxy;
        return this;
    }

    DomainContext extendWithDungProxyContext(DungProxyContext dungProxyContext) {
        this.dungProxyContext = dungProxyContext;
        if (this.coreSize <= 1) {
            this.coreSize = dungProxyContext.getDefaultCoreSize();
        }
        if (this.smartProxyQueueRatio <= 0.1) {
            this.smartProxyQueueRatio = dungProxyContext.getDefaultSmartProxyQueueRatio();
        }
        if (this.useInterval <= 1L) {
            this.useInterval = dungProxyContext.getDefaultUseInterval();
        }
        if (this.resourceFacade == null) {
            this.resourceFacade = ObjectFactory.newInstance(dungProxyContext.getDefaultResourceFacade());
        }
        if (this.scoring == null) {
            this.scoring = ObjectFactory.newInstance(dungProxyContext.getDefaultScoring());
        }
        if (this.offline == null) {
            this.offline = ObjectFactory.newInstance(dungProxyContext.getDefaultOffliner());
        }
        if (this.scoreFactory <= 0) {
            this.scoreFactory = dungProxyContext.getDefaultScoreFactory();
        }
        if (this.proxyChecker == null) {
            this.proxyChecker = ObjectFactory.newInstance(dungProxyContext.getDefaultProxyChecker());
        }
        if (this.defaultProxy == null) {
            this.defaultProxy = Lists.newArrayList();
        }
        return this;
    }
}

