/*
 * Decompiled with CFR 0.152.
 */
package com.virjar.dungproxy.client.ippool.config;

import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.virjar.dungproxy.client.ippool.GroupBindRouter;
import com.virjar.dungproxy.client.ippool.PreHeater;
import com.virjar.dungproxy.client.ippool.config.DomainContext;
import com.virjar.dungproxy.client.ippool.config.ObjectFactory;
import com.virjar.dungproxy.client.ippool.config.ProxyConstant;
import com.virjar.dungproxy.client.ippool.strategy.AvProxyDumper;
import com.virjar.dungproxy.client.ippool.strategy.Offline;
import com.virjar.dungproxy.client.ippool.strategy.ProxyChecker;
import com.virjar.dungproxy.client.ippool.strategy.ProxyDomainStrategy;
import com.virjar.dungproxy.client.ippool.strategy.ResourceFacade;
import com.virjar.dungproxy.client.ippool.strategy.Scoring;
import com.virjar.dungproxy.client.ippool.strategy.impl.AvProxyDumperWrapper;
import com.virjar.dungproxy.client.ippool.strategy.impl.BlackListProxyStrategy;
import com.virjar.dungproxy.client.ippool.strategy.impl.DefaultOffliner;
import com.virjar.dungproxy.client.ippool.strategy.impl.DefaultProxyChecker;
import com.virjar.dungproxy.client.ippool.strategy.impl.DefaultResourceFacade;
import com.virjar.dungproxy.client.ippool.strategy.impl.DefaultScoring;
import com.virjar.dungproxy.client.ippool.strategy.impl.JSONFileAvProxyDumper;
import com.virjar.dungproxy.client.ippool.strategy.impl.ProxyAllStrategy;
import com.virjar.dungproxy.client.ippool.strategy.impl.WhiteListProxyStrategy;
import com.virjar.dungproxy.client.model.AvProxyVO;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DungProxyContext {
    private AvProxyDumper avProxyDumper;
    private ProxyDomainStrategy needProxyStrategy;
    private String clientID;
    private GroupBindRouter groupBindRouter = new GroupBindRouter();
    private long feedBackDuration;
    private PreHeater preHeater = new PreHeater(this);
    private String serverBaseUrl;
    private long serializeStep;
    private boolean poolEnabled;
    private Class<? extends ResourceFacade> defaultResourceFacade;
    private Class<? extends Offline> defaultOffliner;
    private Class<? extends Scoring> defaultScoring;
    private Class<? extends ProxyChecker> defaultProxyChecker;
    private int defaultCoreSize;
    private double defaultSmartProxyQueueRatio;
    private long defaultUseInterval;
    private int defaultScoreFactory;
    private Map<String, DomainContext> domainConfig = Maps.newConcurrentMap();
    private Set<AvProxyVO> cloudProxySet = Sets.newConcurrentHashSet();
    private boolean waitIfNoAvailableProxy = false;
    private Logger logger = LoggerFactory.getLogger(DungProxyContext.class);

    private void fillDefaultStrategy() {
        this.avProxyDumper = new JSONFileAvProxyDumper();
        this.needProxyStrategy = new ProxyAllStrategy();
        this.feedBackDuration = 1200000L;
        this.defaultResourceFacade = DefaultResourceFacade.class;
        this.defaultOffliner = DefaultOffliner.class;
        this.defaultScoring = DefaultScoring.class;
        this.defaultProxyChecker = DefaultProxyChecker.class;
        this.defaultCoreSize = 50;
        this.defaultSmartProxyQueueRatio = 0.3;
        this.defaultUseInterval = 15000L;
        this.defaultScoreFactory = 15;
        this.serverBaseUrl = "http://proxy.scumall.com:8080";
        this.serializeStep = 30L;
        this.poolEnabled = false;
        this.waitIfNoAvailableProxy = false;
        this.handleConfig();
    }

    public AvProxyDumper getAvProxyDumper() {
        return this.avProxyDumper;
    }

    public DungProxyContext setAvProxyDumper(AvProxyDumper avProxyDumper) {
        this.avProxyDumper = new AvProxyDumperWrapper(avProxyDumper);
        return this;
    }

    public boolean isPoolEnabled() {
        return this.poolEnabled;
    }

    public DungProxyContext setWaitIfNoAvailableProxy(boolean waitIfNoAvailableProxy) {
        this.waitIfNoAvailableProxy = waitIfNoAvailableProxy;
        return this;
    }

    public boolean isWaitIfNoAvailableProxy() {
        return this.waitIfNoAvailableProxy;
    }

    public DungProxyContext setPoolEnabled(boolean poolEnabled) {
        this.poolEnabled = poolEnabled;
        return this;
    }

    public String getClientID() {
        return this.clientID;
    }

    public DungProxyContext setClientID(String clientID) {
        this.clientID = clientID;
        return this;
    }

    public long getDefaultUseInterval() {
        return this.defaultUseInterval;
    }

    public DungProxyContext setDefaultUseInterval(long defaultUseInterval) {
        this.defaultUseInterval = defaultUseInterval;
        return this;
    }

    public int getDefaultCoreSize() {
        return this.defaultCoreSize;
    }

    public DungProxyContext setDefaultCoreSize(int defaultCoreSize) {
        this.defaultCoreSize = defaultCoreSize;
        return this;
    }

    public Class<? extends Offline> getDefaultOffliner() {
        return this.defaultOffliner;
    }

    public DungProxyContext setDefaultOffliner(Class<? extends Offline> defaultOffliner) {
        this.defaultOffliner = defaultOffliner;
        return this;
    }

    public Class<? extends ResourceFacade> getDefaultResourceFacade() {
        return this.defaultResourceFacade;
    }

    public DungProxyContext setDefaultResourceFacade(Class<? extends ResourceFacade> defaultResourceFacade) {
        this.defaultResourceFacade = defaultResourceFacade;
        return this;
    }

    public Class<? extends Scoring> getDefaultScoring() {
        return this.defaultScoring;
    }

    public DungProxyContext setDefaultScoring(Class<? extends Scoring> defaultScoring) {
        this.defaultScoring = defaultScoring;
        return this;
    }

    public double getDefaultSmartProxyQueueRatio() {
        return this.defaultSmartProxyQueueRatio;
    }

    public void setDefaultSmartProxyQueueRatio(double defaultSmartProxyQueueRatio) {
        this.defaultSmartProxyQueueRatio = defaultSmartProxyQueueRatio;
    }

    public Map<String, DomainContext> getDomainConfig() {
        return this.domainConfig;
    }

    public DungProxyContext addDomainConfig(DomainContext domainConfig) {
        this.domainConfig.put(domainConfig.getDomain(), domainConfig);
        domainConfig.setDungProxyContext(this);
        domainConfig.extendWithDungProxyContext(this);
        return this;
    }

    public long getFeedBackDuration() {
        return this.feedBackDuration;
    }

    public DungProxyContext setFeedBackDuration(long feedBackDuration) {
        this.feedBackDuration = feedBackDuration;
        return this;
    }

    public GroupBindRouter getGroupBindRouter() {
        return this.groupBindRouter;
    }

    public DungProxyContext setGroupBindRouter(GroupBindRouter groupBindRouter) {
        this.groupBindRouter = groupBindRouter;
        return this;
    }

    public ProxyDomainStrategy getNeedProxyStrategy() {
        return this.needProxyStrategy;
    }

    public DungProxyContext setNeedProxyStrategy(ProxyDomainStrategy needProxyStrategy) {
        this.needProxyStrategy = needProxyStrategy;
        return this;
    }

    public PreHeater getPreHeater() {
        return this.preHeater;
    }

    public DungProxyContext setPreHeater(PreHeater preHeater) {
        this.preHeater = preHeater;
        return this;
    }

    public long getSerializeStep() {
        return this.serializeStep;
    }

    public DungProxyContext setSerializeStep(long serializeStep) {
        this.serializeStep = serializeStep;
        return this;
    }

    public String getServerBaseUrl() {
        return this.serverBaseUrl;
    }

    public DungProxyContext setServerBaseUrl(String serverBaseUrl) {
        this.serverBaseUrl = serverBaseUrl;
        return this;
    }

    public int getDefaultScoreFactory() {
        return this.defaultScoreFactory;
    }

    public DungProxyContext setDefaultScoreFactory(int defaultScoreFactory) {
        this.defaultScoreFactory = defaultScoreFactory;
        return this;
    }

    public Class<? extends ProxyChecker> getDefaultProxyChecker() {
        return this.defaultProxyChecker;
    }

    public DungProxyContext setDefaultProxyChecker(Class<? extends ProxyChecker> defaultProxyChecker) {
        this.defaultProxyChecker = defaultProxyChecker;
        return this;
    }

    public DungProxyContext addCloudProxy(AvProxyVO cloudProxy) {
        this.cloudProxySet.add(cloudProxy);
        return this;
    }

    public Collection<AvProxyVO> getCloudProxies() {
        return Lists.newArrayList(this.cloudProxySet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DomainContext genDomainContext(String domain) {
        DomainContext domainContext = this.domainConfig.get(domain);
        if (domainContext != null) {
            return domainContext;
        }
        Class<DungProxyContext> clazz = DungProxyContext.class;
        synchronized (DungProxyContext.class) {
            domainContext = this.domainConfig.get(domain);
            if (domainContext != null) {
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return domainContext;
            }
            this.domainConfig.put(domain, DomainContext.create(domain).extendWithDungProxyContext(this));
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return this.domainConfig.get(domain);
        }
    }

    public static DungProxyContext create() {
        DungProxyContext context = new DungProxyContext();
        context.fillDefaultStrategy();
        context.buildDefaultConfigFile();
        context.handleConfig();
        return context;
    }

    public DungProxyContext handleConfig() {
        if (this.defaultResourceFacade.isAssignableFrom(DefaultResourceFacade.class)) {
            DefaultResourceFacade.setAllAvUrl(this.serverBaseUrl + "/proxyipcenter/allAv");
            DefaultResourceFacade.setAvUrl(this.serverBaseUrl + "/proxyipcenter/av");
            DefaultResourceFacade.setFeedBackUrl(this.serverBaseUrl + "/proxyipcenter/feedBack");
            DefaultResourceFacade.setClientID(this.clientID);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DungProxyContext buildDefaultConfigFile() {
        InputStream resourceAsStream = DungProxyContext.class.getClassLoader().getResourceAsStream(ProxyConstant.CLIENT_CONFIG_FILE_NAME);
        if (resourceAsStream == null) {
            this.logger.warn("\u6ca1\u6709\u627e\u5230\u914d\u7f6e\u6587\u4ef6:{},\u4ee3\u7406\u89c4\u5219\u53ef\u4ee5\u901a\u8fc7\u4ee3\u7801\u6765\u63a7\u5236", (Object)ProxyConstant.CLIENT_CONFIG_FILE_NAME);
            return this;
        }
        Properties properties = new Properties();
        try {
            properties.load(resourceAsStream);
            DungProxyContext dungProxyContext = this.buildWithProperties(properties);
            return dungProxyContext;
        }
        catch (IOException e) {
            this.logger.error("config file load error for file:{}", (Object)ProxyConstant.CLIENT_CONFIG_FILE_NAME, (Object)e);
        }
        finally {
            IOUtils.closeQuietly((InputStream)resourceAsStream);
        }
        return this;
    }

    public DungProxyContext buildWithProperties(Properties properties) {
        String proxyUseInterval;
        String preheaterSerilizeStep;
        String preHeaterTaskList;
        String defaultAvDumpeFileName;
        String avDumper;
        String proxyDomainStrategy;
        String defaultResourceServerAddress;
        if (properties == null) {
            return this;
        }
        String resourceFace = properties.getProperty("proxyclient.resouce.resourceFacade");
        if (StringUtils.isNotEmpty((CharSequence)resourceFace)) {
            this.defaultResourceFacade = ObjectFactory.classForName(resourceFace);
        }
        if (StringUtils.isNotEmpty((CharSequence)(defaultResourceServerAddress = properties.getProperty("proxyclient.resource.defaultResourceServerAddress")))) {
            this.serverBaseUrl = defaultResourceServerAddress;
        }
        if (StringUtils.isEmpty((CharSequence)(proxyDomainStrategy = properties.getProperty("proxyclient.proxyDomainStrategy")))) {
            proxyDomainStrategy = properties.getProperty("proxyclient.proxyDomainStrategy.whiteList") != null ? WhiteListProxyStrategy.class.getName() : (properties.getProperty("proxyclient.proxyDomainStrategy.whiteList") != null ? BlackListProxyStrategy.class.getName() : ProxyAllStrategy.class.getName());
        }
        if ("WHITE_LIST".equalsIgnoreCase(proxyDomainStrategy)) {
            proxyDomainStrategy = WhiteListProxyStrategy.class.getName();
        } else if ("BLACK_LIST".equalsIgnoreCase(proxyDomainStrategy)) {
            proxyDomainStrategy = BlackListProxyStrategy.class.getName();
        }
        this.needProxyStrategy = (ProxyDomainStrategy)ObjectFactory.newInstance(proxyDomainStrategy);
        if (this.needProxyStrategy instanceof WhiteListProxyStrategy) {
            WhiteListProxyStrategy whiteListProxyStrategy = (WhiteListProxyStrategy)this.needProxyStrategy;
            String whiteListProperty = properties.getProperty("proxyclient.proxyDomainStrategy.whiteList");
            whiteListProxyStrategy.addAllHost(whiteListProperty);
        } else if (this.needProxyStrategy instanceof BlackListProxyStrategy) {
            BlackListProxyStrategy blackListProxyStrategy = (BlackListProxyStrategy)this.needProxyStrategy;
            String proxyDomainStrategyWhiteList = properties.getProperty("proxyclient.proxyDomainStrategy.whiteList");
            blackListProxyStrategy.addAllHost(proxyDomainStrategyWhiteList);
        }
        String feedBackDurationProperties = properties.getProperty("proxyclient.feedback.duration");
        if (!Strings.isNullOrEmpty((String)feedBackDurationProperties)) {
            this.feedBackDuration = NumberUtils.toLong((String)feedBackDurationProperties);
        }
        if (StringUtils.isNotEmpty((CharSequence)(avDumper = properties.getProperty("proxyclient.serialize.serializer")))) {
            AvProxyDumper tempDumper = (AvProxyDumper)ObjectFactory.newInstance(avDumper);
            this.setAvProxyDumper(tempDumper);
        }
        if (StringUtils.isNotEmpty((CharSequence)(defaultAvDumpeFileName = properties.getProperty("proxyclient.DefaultAvProxyDumper.dumpFileName")))) {
            this.avProxyDumper.setDumpFileName(defaultAvDumpeFileName);
        }
        if (StringUtils.isNotEmpty((CharSequence)(preHeaterTaskList = properties.getProperty("proxyclient.preHeater.testList")))) {
            for (String url : Splitter.on((String)",").split((CharSequence)preHeaterTaskList)) {
                this.preHeater.addTask(url);
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)(preheaterSerilizeStep = properties.getProperty("proxyclient.preHeater.serialize.step")))) {
            this.serializeStep = NumberUtils.toLong((String)preheaterSerilizeStep, (long)30L);
        }
        if (StringUtils.isNotEmpty((CharSequence)(proxyUseInterval = properties.getProperty("proxyclient.proxyUseIntervalMillis")))) {
            this.defaultUseInterval = NumberUtils.toLong((String)proxyUseInterval, (long)15000L);
        }
        this.clientID = properties.getProperty("proxyclient.clientID");
        String ruleRouter = properties.getProperty("proxyclient.proxyDomainStrategy.group");
        if (StringUtils.isNotEmpty((CharSequence)ruleRouter)) {
            this.groupBindRouter.buildCombinationRule(ruleRouter);
        }
        this.handleConfig();
        return this;
    }
}

