/*
 * Decompiled with CFR 0.152.
 */
package com.virjar.dungproxy.client.ippool.config;

import com.google.common.base.Preconditions;
import com.virjar.dungproxy.client.ippool.exception.ObjectCreateException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObjectFactory {
    private static final Logger logger = LoggerFactory.getLogger(ObjectFactory.class);

    public static <T> T newInstance(String className) {
        Preconditions.checkNotNull((Object)className);
        try {
            Class<?> aClass = Class.forName(className);
            return (T)aClass.newInstance();
        }
        catch (Exception e) {
            logger.error("can not create instance for class :{}", (Object)className);
            throw new ObjectCreateException("can not create instance for class " + className, e);
        }
    }

    public static <T> T newInstance(Class<T> tClass) {
        try {
            return tClass.newInstance();
        }
        catch (Exception e) {
            logger.error("can not create instance for class :{}", tClass);
            throw new ObjectCreateException("can not create instance for class " + tClass, e);
        }
    }

    public static <T> Class<T> classForName(String className) {
        try {
            return Class.forName(className);
        }
        catch (Exception e) {
            logger.error("can not create instance for class :{}", (Object)className);
            throw new ObjectCreateException("can not create instance for class " + className, e);
        }
    }
}

