/*
 * Decompiled with CFR 0.152.
 */
package com.virjar.dungproxy.client.ippool.strategy.impl;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.virjar.dungproxy.client.ippool.strategy.AvProxyDumper;
import com.virjar.dungproxy.client.model.AvProxyVO;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;

public class AvProxyDumperWrapper
implements AvProxyDumper {
    private AvProxyDumper delegate;
    private AtomicBoolean isDumpring = new AtomicBoolean(false);

    public AvProxyDumperWrapper(AvProxyDumper delegate) {
        Preconditions.checkNotNull((Object)delegate);
        this.delegate = delegate;
    }

    @Override
    public void setDumpFileName(String dumpFileName) {
        this.delegate.setDumpFileName(dumpFileName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void serializeProxy(Map<String, List<AvProxyVO>> data) {
        if (data == null || data.size() == 0) {
            return;
        }
        if (this.isDumpring.compareAndSet(false, true)) {
            try {
                this.delegate.serializeProxy(Maps.transformValues(data, (Function)new Function<List<AvProxyVO>, List<AvProxyVO>>(){

                    public List<AvProxyVO> apply(List<AvProxyVO> input) {
                        return Lists.newArrayList((Iterable)Iterables.filter(input, (Predicate)new Predicate<AvProxyVO>(){

                            public boolean apply(AvProxyVO input) {
                                return input.getCloud() == false;
                            }
                        }));
                    }
                }));
            }
            finally {
                this.isDumpring.set(false);
            }
        }
    }

    @Override
    public Map<String, List<AvProxyVO>> unSerializeProxy() {
        return this.delegate.unSerializeProxy();
    }
}

