/*
 * Decompiled with CFR 0.152.
 */
package com.virjar.dungproxy.client.ippool.strategy.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.io.Files;
import com.virjar.dungproxy.client.ippool.strategy.AvProxyDumper;
import com.virjar.dungproxy.client.model.AvProxyVO;
import com.virjar.dungproxy.client.util.CommonUtil;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JSONFileAvProxyDumper
implements AvProxyDumper {
    private Logger logger = LoggerFactory.getLogger(JSONFileAvProxyDumper.class);
    private String dumpFileName;

    public JSONFileAvProxyDumper() {
    }

    public JSONFileAvProxyDumper(String dumpFileName) {
        this.dumpFileName = dumpFileName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void serializeProxy(Map<String, List<AvProxyVO>> data) {
        BufferedWriter bufferedWriter;
        block6: {
            if (data == null || data.size() == 0) {
                return;
            }
            bufferedWriter = null;
            try {
                bufferedWriter = Files.newWriter((File)new File(CommonUtil.ensurePathExist(this.trimFileName())), (Charset)Charset.defaultCharset());
                String s = JSONObject.toJSONString(data);
                if (StringUtils.isEmpty((CharSequence)s)) {
                    this.logger.warn("\u5e8f\u5217\u5316\u7684\u65f6\u5019,\u6570\u636e\u635f\u574f,\u653e\u5f03\u5e8f\u5217\u5316");
                    break block6;
                }
                bufferedWriter.write(s);
            }
            catch (IOException e) {
                try {
                    this.logger.error("error when serialize proxy data", (Throwable)e);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(bufferedWriter);
                    throw throwable;
                }
                IOUtils.closeQuietly((Writer)bufferedWriter);
            }
        }
        IOUtils.closeQuietly((Writer)bufferedWriter);
    }

    @Override
    public Map<String, List<AvProxyVO>> unSerializeProxy() {
        HashMap ret = Maps.newHashMap();
        if (!new File(this.trimFileName()).exists()) {
            return ret;
        }
        try {
            JSONObject jsonObject = JSONObject.parseObject((String)Files.toString((File)new File(this.trimFileName()), (Charset)Charset.defaultCharset()));
            if (jsonObject == null) {
                this.logger.warn("\u672c\u5730\u4ee3\u7406IP\u6c60\u5e8f\u5217\u5316\u6587\u4ef6\u635f\u574f");
                return ret;
            }
            for (Map.Entry entry : jsonObject.entrySet()) {
                ret.put(entry.getKey(), Lists.transform((List)((JSONArray)JSONArray.class.cast(entry.getValue())).subList(0, ((JSONArray)JSONArray.class.cast(entry.getValue())).size()), (Function)new Function<Object, AvProxyVO>(){

                    public AvProxyVO apply(Object input) {
                        return (AvProxyVO)JSONObject.toJavaObject((JSON)((JSON)JSONObject.class.cast(input)), AvProxyVO.class);
                    }
                }));
            }
        }
        catch (Exception e) {
            this.logger.error("error when unSerializeProxy proxy data", (Throwable)e);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String trimFileName() {
        try {
            if (StringUtils.isEmpty((CharSequence)this.dumpFileName)) {
                this.dumpFileName = "availableProxy.json";
            }
            if (this.dumpFileName.startsWith("/") || this.dumpFileName.charAt(1) == ':') {
                String string = this.dumpFileName;
                return string;
            }
            String classPath = JSONFileAvProxyDumper.class.getResource("/").getFile();
            this.dumpFileName = new File(classPath, this.dumpFileName).getAbsolutePath();
        }
        finally {
            this.logger.info("json\u5e8f\u5217\u5316\u5668,\u6587\u4ef6\u8def\u5f84\u4e3a:{}", (Object)this.dumpFileName);
        }
        return this.dumpFileName;
    }

    @Override
    public void setDumpFileName(String dumpFileName) {
        this.dumpFileName = dumpFileName;
    }
}

