/*
 * Decompiled with CFR 0.152.
 */
package com.virjar.dungproxy.client.ippool.strategy.impl;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.io.Files;
import com.virjar.dungproxy.client.ippool.strategy.AvProxyDumper;
import com.virjar.dungproxy.client.model.AvProxyVO;
import com.virjar.dungproxy.client.util.CommonUtil;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PlainTextFileAvProxyDumper
implements AvProxyDumper {
    private Logger logger = LoggerFactory.getLogger(PlainTextFileAvProxyDumper.class);
    private String dumpFileName;

    @Override
    public void setDumpFileName(String dumpFileName) {
        this.dumpFileName = dumpFileName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void serializeProxy(Map<String, List<AvProxyVO>> data) {
        BufferedWriter bufferedWriter = null;
        int resultNum = 0;
        try {
            bufferedWriter = Files.newWriter((File)new File(CommonUtil.ensurePathExist(this.trimFileName())), (Charset)Charset.defaultCharset());
            for (List<AvProxyVO> proxies : data.values()) {
                for (AvProxyVO avProxy : proxies) {
                    bufferedWriter.write(avProxy.getIp() + ":" + avProxy.getPort());
                    bufferedWriter.newLine();
                    ++resultNum;
                }
            }
        }
        catch (IOException e) {
            try {
                this.logger.error("error when serialize proxy data", (Throwable)e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(bufferedWriter);
                throw throwable;
            }
            IOUtils.closeQuietly((Writer)bufferedWriter);
        }
        IOUtils.closeQuietly((Writer)bufferedWriter);
        this.logger.info("total checked proxy num " + resultNum);
    }

    @Override
    public Map<String, List<AvProxyVO>> unSerializeProxy() {
        HashMap ret = Maps.newHashMap();
        if (!new File(this.trimFileName()).exists()) {
            return ret;
        }
        try {
            List proxies = Files.readLines((File)new File(this.trimFileName()), (Charset)Charset.defaultCharset());
            LinkedList avProxies = Lists.newLinkedList();
            for (String proxyString : proxies) {
                AvProxyVO avProxy = new AvProxyVO();
                String[] tmpString = proxyString.split(":");
                avProxy.setIp(tmpString[0]);
                avProxy.setPort(new Integer(tmpString[1]));
                avProxies.add(avProxy);
            }
            ret.put("", avProxies);
        }
        catch (Exception e) {
            this.logger.error("error when unSerializeProxy proxy data", (Throwable)e);
        }
        return ret;
    }

    private String trimFileName() {
        if (StringUtils.isEmpty((CharSequence)this.dumpFileName)) {
            this.dumpFileName = "availableProxy.json";
        }
        if (this.dumpFileName.startsWith("/") || this.dumpFileName.charAt(1) == ':') {
            return this.dumpFileName;
        }
        String classPath = PlainTextFileAvProxyDumper.class.getResource("/").getFile();
        return new File(classPath, this.dumpFileName).getAbsolutePath();
    }
}

