/*
 * Decompiled with CFR 0.152.
 */
package com.virjar.dungproxy.client.ippool.strategy.impl;

import com.google.common.base.Splitter;
import com.google.common.collect.Sets;
import com.virjar.dungproxy.client.ippool.strategy.ProxyDomainStrategy;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WhiteListProxyStrategy
implements ProxyDomainStrategy {
    private Logger logger = LoggerFactory.getLogger(WhiteListProxyStrategy.class);
    private Set<String> whiteList = Sets.newConcurrentHashSet();

    public WhiteListProxyStrategy() {
    }

    public WhiteListProxyStrategy(String whiteList) {
        if (StringUtils.isNotEmpty((CharSequence)whiteList)) {
            this.whiteList.addAll(Splitter.on((String)";").omitEmptyStrings().trimResults().splitToList((CharSequence)whiteList));
        }
    }

    @Override
    public boolean needProxy(String host) {
        return this.whiteList.contains(host);
    }

    public void addWhiteHost(String host) {
        if (StringUtils.startsWithIgnoreCase((CharSequence)host, (CharSequence)"http") || StringUtils.contains((CharSequence)host, (CharSequence)":") || StringUtils.contains((CharSequence)host, (CharSequence)"/")) {
            throw new IllegalArgumentException(host + " \u4e0d\u662f\u4e00\u4e2a\u5408\u6cd5\u57df\u540d,\u8bf7\u6ce8\u610f\u586b\u5199\u7684\u662f\u57df\u540d,\u4e0d\u662fURL");
        }
        this.whiteList.add(host);
    }

    public void addAllHost(String configRule) {
        if (StringUtils.isEmpty((CharSequence)configRule)) {
            this.logger.warn("\u60a8\u9009\u62e9\u4e86\u767d\u540d\u5355\u4ee3\u7406\u7b56\u7565,\u4f46\u662f\u6ca1\u6709\u63d0\u4f9b\u7b56\u7565\u914d\u7f6e,\u4ee3\u7406\u6c60\u5c06\u4e0d\u4f1a\u4ee3\u7406\u4efb\u4f55\u8bf7\u6c42");
            return;
        }
        for (String domain : Splitter.on((String)",").omitEmptyStrings().trimResults().split((CharSequence)configRule)) {
            this.addWhiteHost(domain);
        }
    }

    public void removeFromWhiteHost(String host) {
        this.whiteList.remove(host);
    }
}

