/*
 * Decompiled with CFR 0.152.
 */
package com.virjar.dungproxy.client.ippool.support.http;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.virjar.dungproxy.client.VERSION;
import com.virjar.dungproxy.client.ippool.DomainPool;
import com.virjar.dungproxy.client.ippool.IpPool;
import com.virjar.dungproxy.client.ippool.SmartProxyQueue;
import com.virjar.dungproxy.client.ippool.config.ProxyConstant;
import com.virjar.dungproxy.client.util.CommonUtil;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class PoolManager {
    public static final PoolManager instance = new PoolManager();
    private IpPool ipPool = IpPool.getInstance();

    public Map<String, Object> returnJSONBasicStat() {
        LinkedHashMap<String, Object> dataMap = new LinkedHashMap<String, Object>();
        dataMap.put("Version", VERSION.getVersionNumber());
        dataMap.put("JavaVMName", System.getProperty("java.vm.name"));
        dataMap.put("JavaVersion", System.getProperty("java.version"));
        dataMap.put("JavaClassPath", System.getProperty("java.class.path"));
        dataMap.put("StartTime", CommonUtil.toString(CommonUtil.getStartTime()));
        URL resource = PoolManager.class.getClassLoader().getResource(ProxyConstant.CLIENT_CONFIG_FILE_NAME);
        if (resource != null) {
            dataMap.put("configPath", resource.getFile());
        } else {
            dataMap.put("configPath", "not config ,ip pool not enable");
        }
        dataMap.put("domainNum", this.ipPool.totalDomain());
        return dataMap;
    }

    public List<Map<String, String>> domains() {
        Map<String, DomainPool> pool = this.ipPool.getPool();
        ArrayList ret = Lists.newArrayList();
        for (Map.Entry<String, DomainPool> entry : pool.entrySet()) {
            DomainPool domainPool = entry.getValue();
            HashMap record = Maps.newHashMap();
            record.put("domain", entry.getKey());
            record.put("coreSize", String.valueOf(domainPool.getCoreSize()));
            record.put("size", String.valueOf(domainPool.getSmartProxyQueue().allSize()));
            record.put("minSize", "\u672c\u5b57\u6bb5\u5e9f\u5f03");
            ret.add(record);
        }
        return ret;
    }

    public Map<String, Object> domainInfo(String domain) {
        HashMap ret = Maps.newHashMap();
        DomainPool domainPool = this.ipPool.getPool().get(domain);
        ret.put("domain", domain);
        ret.put("coreSize", domainPool.getCoreSize());
        ret.put("isRefreshing", domainPool.isRefreshing());
        ret.put("site", domainPool.getSmartProxyQueue().allSize());
        SmartProxyQueue smartProxyQueue = domainPool.getSmartProxyQueue();
        ret.put("queue_ratio", smartProxyQueue.getRatio());
        ret.put("queue_proxies", Lists.newArrayList(smartProxyQueue.values()));
        return ret;
    }
}

