/*
 * Decompiled with CFR 0.152.
 */
package com.virjar.dungproxy.client.ippool.support.http;

import com.google.common.collect.Lists;
import com.virjar.dungproxy.client.model.IPAddress;
import com.virjar.dungproxy.client.model.IPRange;
import com.virjar.dungproxy.client.util.ResourceUtil;
import java.io.IOException;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ResourceServlet
extends HttpServlet {
    private static final Logger LOG = LoggerFactory.getLogger(ResourceServlet.class);
    public static final String SESSION_USER_KEY = "dungproxy-user";
    public static final String PARAM_NAME_USERNAME = "loginUsername";
    public static final String PARAM_NAME_PASSWORD = "loginPassword";
    public static final String PARAM_NAME_ALLOW = "allow";
    public static final String PARAM_NAME_DENY = "deny";
    public static final String PARAM_REMOTE_ADDR = "remoteAddress";
    protected String username = null;
    protected String password = null;
    protected List<IPRange> allowList = Lists.newArrayList();
    protected List<IPRange> denyList = Lists.newArrayList();
    protected final String resourcePath;
    protected String remoteAddressHeader = null;

    public ResourceServlet(String resourcePath) {
        this.resourcePath = resourcePath;
    }

    public void init() throws ServletException {
        this.initAuthEnv();
    }

    private void initAuthEnv() {
        String msg;
        IPRange ipRange;
        String[] items;
        String param;
        String paramRemoteAddressHeader;
        String paramPassword;
        String paramUserName = this.getInitParameter(PARAM_NAME_USERNAME);
        if (!StringUtils.isEmpty((CharSequence)paramUserName)) {
            this.username = paramUserName;
        }
        if (!StringUtils.isEmpty((CharSequence)(paramPassword = this.getInitParameter(PARAM_NAME_PASSWORD)))) {
            this.password = paramPassword;
        }
        if (!StringUtils.isEmpty((CharSequence)(paramRemoteAddressHeader = this.getInitParameter(PARAM_REMOTE_ADDR)))) {
            this.remoteAddressHeader = paramRemoteAddressHeader;
        }
        try {
            param = this.getInitParameter(PARAM_NAME_ALLOW);
            if (param != null && param.trim().length() != 0) {
                param = param.trim();
                for (String item : items = param.split(",")) {
                    if (item == null || item.length() == 0) continue;
                    ipRange = new IPRange(item);
                    this.allowList.add(ipRange);
                }
            }
        }
        catch (Exception e) {
            msg = "initParameter config error, allow : " + this.getInitParameter(PARAM_NAME_ALLOW);
            LOG.error(msg, (Throwable)e);
        }
        try {
            param = this.getInitParameter(PARAM_NAME_DENY);
            if (param != null && param.trim().length() != 0) {
                param = param.trim();
                for (String item : items = param.split(",")) {
                    if (item == null || item.length() == 0) continue;
                    ipRange = new IPRange(item);
                    this.denyList.add(ipRange);
                }
            }
        }
        catch (Exception e) {
            msg = "initParameter config error, deny : " + this.getInitParameter(PARAM_NAME_DENY);
            LOG.error(msg, (Throwable)e);
        }
    }

    public boolean isPermittedRequest(String remoteAddress) {
        boolean ipV6;
        boolean bl = ipV6 = remoteAddress != null && remoteAddress.indexOf(58) != -1;
        if (ipV6) {
            return "0:0:0:0:0:0:0:1".equals(remoteAddress) || this.denyList.size() == 0 && this.allowList.size() == 0;
        }
        IPAddress ipAddress = new IPAddress(remoteAddress);
        for (IPRange range : this.denyList) {
            if (!range.isIPAddressInRange(ipAddress)) continue;
            return false;
        }
        if (this.allowList.size() > 0) {
            for (IPRange range : this.allowList) {
                if (!range.isIPAddressInRange(ipAddress)) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    protected String getFilePath(String fileName) {
        return this.resourcePath + fileName;
    }

    protected void returnResourceFile(String fileName, String uri, HttpServletResponse response) throws ServletException, IOException {
        String filePath = this.getFilePath(fileName);
        if (filePath.endsWith(".html")) {
            response.setContentType("text/html; charset=utf-8");
        }
        if (fileName.endsWith(".jpg")) {
            byte[] bytes = ResourceUtil.readByteArrayFromResource(filePath);
            if (bytes != null) {
                response.getOutputStream().write(bytes);
            }
            return;
        }
        String text = ResourceUtil.readFromResource(filePath);
        if (text == null) {
            response.sendRedirect(uri + "/index.html");
            return;
        }
        if (fileName.endsWith(".css")) {
            response.setContentType("text/css;charset=utf-8");
        } else if (fileName.endsWith(".js")) {
            response.setContentType("text/javascript;charset=utf-8");
        }
        response.getWriter().write(text);
    }

    public void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String contextPath = request.getContextPath();
        String servletPath = request.getServletPath();
        String requestURI = request.getRequestURI();
        response.setCharacterEncoding("utf-8");
        if (contextPath == null) {
            contextPath = "";
        }
        String uri = contextPath + servletPath;
        String path = requestURI.substring(contextPath.length() + servletPath.length());
        if (!this.isPermittedRequest(request)) {
            path = "/nopermit.html";
            this.returnResourceFile(path, uri, response);
            return;
        }
        if ("/submitLogin".equals(path)) {
            String usernameParam = request.getParameter(PARAM_NAME_USERNAME);
            String passwordParam = request.getParameter(PARAM_NAME_PASSWORD);
            if (this.username.equals(usernameParam) && this.password.equals(passwordParam)) {
                request.getSession().setAttribute(SESSION_USER_KEY, (Object)this.username);
                response.getWriter().print("success");
            } else {
                response.getWriter().print("error");
            }
            return;
        }
        if (!(!this.isRequireAuth() || this.ContainsUser(request) || "/login.html".equals(path) || path.startsWith("/css") || path.startsWith("/js") || path.startsWith("/img"))) {
            if (contextPath.equals("") || contextPath.equals("/")) {
                response.sendRedirect(servletPath + "/login.html");
            } else if ("".equals(path)) {
                response.sendRedirect(servletPath + "/login.html");
            } else {
                response.sendRedirect("login.html");
            }
            return;
        }
        if ("".equals(path)) {
            if (contextPath.equals("") || contextPath.equals("/")) {
                response.sendRedirect(servletPath + "/index.html");
            } else {
                response.sendRedirect(servletPath + "/index.html");
            }
            return;
        }
        if ("/".equals(path)) {
            response.sendRedirect("index.html");
            return;
        }
        if (path.contains(".json")) {
            String fullUrl = path;
            if (request.getQueryString() != null && request.getQueryString().length() > 0) {
                fullUrl = fullUrl + "?" + request.getQueryString();
            }
            response.getWriter().print(this.process(fullUrl));
            return;
        }
        this.returnResourceFile(path, uri, response);
    }

    public boolean ContainsUser(HttpServletRequest request) {
        HttpSession session = request.getSession(false);
        return session != null && session.getAttribute(SESSION_USER_KEY) != null;
    }

    public boolean isRequireAuth() {
        return this.username != null;
    }

    public boolean isPermittedRequest(HttpServletRequest request) {
        String remoteAddress = this.getRemoteAddress(request);
        return this.isPermittedRequest(remoteAddress);
    }

    protected String getRemoteAddress(HttpServletRequest request) {
        String remoteAddress = null;
        if (this.remoteAddressHeader != null) {
            remoteAddress = request.getHeader(this.remoteAddressHeader);
        }
        if (remoteAddress == null) {
            remoteAddress = request.getRemoteAddr();
        }
        return remoteAddress;
    }

    protected abstract String process(String var1);
}

