/*
 * Decompiled with CFR 0.152.
 */
package com.virjar.dungproxy.client.ippool.support.http;

import com.virjar.dungproxy.client.ippool.support.http.ResourceServlet;
import com.virjar.dungproxy.client.ippool.support.http.stat.DrungClientStatService;
import java.io.IOException;
import java.util.HashMap;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import javax.servlet.ServletException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StatViewServlet
extends ResourceServlet {
    private static final Logger LOG = LoggerFactory.getLogger(StatViewServlet.class);
    private static final long serialVersionUID = 1L;
    public static final String PARAM_NAME_RESET_ENABLE = "resetEnable";
    public static final String PARAM_NAME_JMX_URL = "jmxUrl";
    public static final String PARAM_NAME_JMX_USERNAME = "jmxUsername";
    public static final String PARAM_NAME_JMX_PASSWORD = "jmxPassword";
    private DrungClientStatService statService = DrungClientStatService.getInstance();
    private String jmxUrl = null;
    private String jmxUsername = null;
    private String jmxPassword = null;
    private MBeanServerConnection conn = null;

    public StatViewServlet() {
        super("support/http/dungresource");
    }

    @Override
    public void init() throws ServletException {
        String param;
        super.init();
        try {
            param = this.getInitParameter(PARAM_NAME_RESET_ENABLE);
            if (param != null && param.trim().length() != 0) {
                param = param.trim();
                boolean resetEnable = Boolean.parseBoolean(param);
            }
        }
        catch (Exception e) {
            String msg = "initParameter config error, resetEnable : " + this.getInitParameter(PARAM_NAME_RESET_ENABLE);
            LOG.error(msg, (Throwable)e);
        }
        param = this.readInitParam(PARAM_NAME_JMX_URL);
        if (param != null) {
            this.jmxUrl = param;
            this.jmxUsername = this.readInitParam(PARAM_NAME_JMX_USERNAME);
            this.jmxPassword = this.readInitParam(PARAM_NAME_JMX_PASSWORD);
            try {
                this.initJmxConn();
            }
            catch (IOException e) {
                LOG.error("init jmx connection error", (Throwable)e);
            }
        }
    }

    private String readInitParam(String key) {
        String value = null;
        try {
            String param = this.getInitParameter(key);
            if (param != null && (param = param.trim()).length() > 0) {
                value = param;
            }
        }
        catch (Exception e) {
            String msg = "initParameter config [" + key + "] error";
            LOG.warn(msg, (Throwable)e);
        }
        return value;
    }

    private void initJmxConn() throws IOException {
        if (this.jmxUrl != null) {
            JMXServiceURL url = new JMXServiceURL(this.jmxUrl);
            HashMap<String, String[]> env = null;
            if (this.jmxUsername != null) {
                env = new HashMap<String, String[]>();
                String[] credentials = new String[]{this.jmxUsername, this.jmxPassword};
                env.put("jmx.remote.credentials", credentials);
            }
            JMXConnector jmxc = JMXConnectorFactory.connect(url, env);
            this.conn = jmxc.getMBeanServerConnection();
        }
    }

    private String getJmxResult(MBeanServerConnection connetion, String url) throws Exception {
        ObjectName name = new ObjectName("com.alibaba.druid:type=DrungClientStatService");
        String result = (String)this.conn.invoke(name, "service", new String[]{url}, new String[]{String.class.getName()});
        return result;
    }

    @Override
    protected String process(String url) {
        String resp = null;
        if (this.jmxUrl == null) {
            resp = this.statService.service(url);
        } else if (this.conn == null) {
            try {
                this.initJmxConn();
            }
            catch (IOException e) {
                LOG.error("init jmx connection error", (Throwable)e);
                resp = DrungClientStatService.returnJSONResult(-1, "init jmx connection error" + e.getMessage());
            }
            if (this.conn != null) {
                try {
                    resp = this.getJmxResult(this.conn, url);
                }
                catch (Exception e) {
                    LOG.error("get jmx data error", (Throwable)e);
                    resp = DrungClientStatService.returnJSONResult(-1, "get data error:" + e.getMessage());
                }
            }
        } else {
            try {
                resp = this.getJmxResult(this.conn, url);
            }
            catch (Exception e) {
                LOG.error("get jmx data error", (Throwable)e);
                resp = DrungClientStatService.returnJSONResult(-1, "get data error" + e.getMessage());
            }
        }
        return resp;
    }
}

